/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.operation;

import com.mongodb.ExplainVerbosity;
import com.mongodb.MongoNamespace;
import com.mongodb.WriteConcern;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.model.Collation;
import com.mongodb.internal.TimeoutContext;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.binding.AsyncWriteBinding;
import com.mongodb.internal.binding.WriteBinding;
import com.mongodb.internal.connection.CommandHelper;
import com.mongodb.internal.operation.AsyncOperationHelper;
import com.mongodb.internal.operation.AsyncReadOperation;
import com.mongodb.internal.operation.AsyncWriteOperation;
import com.mongodb.internal.operation.CommandOperationHelper;
import com.mongodb.internal.operation.CommandReadOperation;
import com.mongodb.internal.operation.DocumentHelper;
import com.mongodb.internal.operation.ExplainHelper;
import com.mongodb.internal.operation.MapReduceHelper;
import com.mongodb.internal.operation.MapReduceStatistics;
import com.mongodb.internal.operation.ReadOperation;
import com.mongodb.internal.operation.SyncOperationHelper;
import com.mongodb.internal.operation.WriteConcernHelper;
import com.mongodb.internal.operation.WriteOperation;
import com.mongodb.lang.Nullable;
import java.util.Arrays;
import java.util.List;
import org.bson.BsonBoolean;
import org.bson.BsonDocument;
import org.bson.BsonJavaScript;
import org.bson.BsonString;
import org.bson.codecs.BsonDocumentCodec;

public class MapReduceToCollectionOperation
implements AsyncWriteOperation<MapReduceStatistics>,
WriteOperation<MapReduceStatistics> {
    private final MongoNamespace namespace;
    private final BsonJavaScript mapFunction;
    private final BsonJavaScript reduceFunction;
    private final String collectionName;
    private final WriteConcern writeConcern;
    private BsonJavaScript finalizeFunction;
    private BsonDocument scope;
    private BsonDocument filter;
    private BsonDocument sort;
    private int limit;
    private boolean jsMode;
    private boolean verbose;
    private String action = "replace";
    private String databaseName;
    private Boolean bypassDocumentValidation;
    private Collation collation;
    private static final List<String> VALID_ACTIONS = Arrays.asList("replace", "merge", "reduce");

    public MapReduceToCollectionOperation(MongoNamespace mongoNamespace, BsonJavaScript bsonJavaScript, BsonJavaScript bsonJavaScript2, @Nullable String string, @Nullable WriteConcern writeConcern) {
        this.namespace = Assertions.notNull("namespace", mongoNamespace);
        this.mapFunction = Assertions.notNull("mapFunction", bsonJavaScript);
        this.reduceFunction = Assertions.notNull("reduceFunction", bsonJavaScript2);
        this.collectionName = Assertions.notNull("collectionName", string);
        this.writeConcern = writeConcern;
    }

    public MongoNamespace getNamespace() {
        return this.namespace;
    }

    public BsonJavaScript getMapFunction() {
        return this.mapFunction;
    }

    public BsonJavaScript getReduceFunction() {
        return this.reduceFunction;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public WriteConcern getWriteConcern() {
        return this.writeConcern;
    }

    public BsonJavaScript getFinalizeFunction() {
        return this.finalizeFunction;
    }

    public MapReduceToCollectionOperation finalizeFunction(BsonJavaScript bsonJavaScript) {
        this.finalizeFunction = bsonJavaScript;
        return this;
    }

    public BsonDocument getScope() {
        return this.scope;
    }

    public MapReduceToCollectionOperation scope(@Nullable BsonDocument bsonDocument) {
        this.scope = bsonDocument;
        return this;
    }

    public BsonDocument getFilter() {
        return this.filter;
    }

    public MapReduceToCollectionOperation filter(@Nullable BsonDocument bsonDocument) {
        this.filter = bsonDocument;
        return this;
    }

    public BsonDocument getSort() {
        return this.sort;
    }

    public MapReduceToCollectionOperation sort(@Nullable BsonDocument bsonDocument) {
        this.sort = bsonDocument;
        return this;
    }

    public int getLimit() {
        return this.limit;
    }

    public MapReduceToCollectionOperation limit(int n) {
        this.limit = n;
        return this;
    }

    public boolean isJsMode() {
        return this.jsMode;
    }

    public MapReduceToCollectionOperation jsMode(boolean bl) {
        this.jsMode = bl;
        return this;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public MapReduceToCollectionOperation verbose(boolean bl) {
        this.verbose = bl;
        return this;
    }

    public String getAction() {
        return this.action;
    }

    public MapReduceToCollectionOperation action(String string) {
        Assertions.notNull("action", string);
        Assertions.isTrue("action must be one of: \"replace\", \"merge\", \"reduce\"", VALID_ACTIONS.contains(string));
        this.action = string;
        return this;
    }

    @Nullable
    public String getDatabaseName() {
        return this.databaseName;
    }

    public MapReduceToCollectionOperation databaseName(@Nullable String string) {
        this.databaseName = string;
        return this;
    }

    public Boolean getBypassDocumentValidation() {
        return this.bypassDocumentValidation;
    }

    public MapReduceToCollectionOperation bypassDocumentValidation(@Nullable Boolean bl) {
        this.bypassDocumentValidation = bl;
        return this;
    }

    public Collation getCollation() {
        return this.collation;
    }

    public MapReduceToCollectionOperation collation(@Nullable Collation collation) {
        this.collation = collation;
        return this;
    }

    @Override
    public MapReduceStatistics execute(WriteBinding writeBinding) {
        return SyncOperationHelper.executeCommand(writeBinding, this.namespace.getDatabaseName(), this.getCommandCreator(), this.transformer(writeBinding.getOperationContext().getTimeoutContext()));
    }

    @Override
    public void executeAsync(AsyncWriteBinding asyncWriteBinding, SingleResultCallback<MapReduceStatistics> singleResultCallback) {
        AsyncOperationHelper.executeCommandAsync(asyncWriteBinding, this.namespace.getDatabaseName(), this.getCommandCreator(), this.transformerAsync(asyncWriteBinding.getOperationContext().getTimeoutContext()), singleResultCallback);
    }

    public ReadOperation<BsonDocument> asExplainableOperation(ExplainVerbosity explainVerbosity) {
        return this.createExplainableOperation(explainVerbosity);
    }

    public AsyncReadOperation<BsonDocument> asExplainableOperationAsync(ExplainVerbosity explainVerbosity) {
        return this.createExplainableOperation(explainVerbosity);
    }

    private CommandReadOperation<BsonDocument> createExplainableOperation(ExplainVerbosity explainVerbosity) {
        return new CommandReadOperation<BsonDocument>(this.getNamespace().getDatabaseName(), (operationContext, serverDescription, connectionDescription) -> {
            BsonDocument bsonDocument = this.getCommandCreator().create(operationContext, serverDescription, connectionDescription);
            CommandHelper.applyMaxTimeMS(operationContext.getTimeoutContext(), bsonDocument);
            return ExplainHelper.asExplainCommand(bsonDocument, explainVerbosity);
        }, new BsonDocumentCodec());
    }

    private SyncOperationHelper.CommandWriteTransformer<BsonDocument, MapReduceStatistics> transformer(TimeoutContext timeoutContext) {
        return (bsonDocument, connection) -> {
            WriteConcernHelper.throwOnWriteConcernError(bsonDocument, connection.getDescription().getServerAddress(), connection.getDescription().getMaxWireVersion(), timeoutContext);
            return MapReduceHelper.createStatistics(bsonDocument);
        };
    }

    private AsyncOperationHelper.CommandWriteTransformerAsync<BsonDocument, MapReduceStatistics> transformerAsync(TimeoutContext timeoutContext) {
        return (bsonDocument, asyncConnection) -> {
            WriteConcernHelper.throwOnWriteConcernError(bsonDocument, asyncConnection.getDescription().getServerAddress(), asyncConnection.getDescription().getMaxWireVersion(), timeoutContext);
            return MapReduceHelper.createStatistics(bsonDocument);
        };
    }

    private CommandOperationHelper.CommandCreator getCommandCreator() {
        return (operationContext, serverDescription, connectionDescription) -> {
            BsonDocument bsonDocument = new BsonDocument(this.getAction(), new BsonString(this.getCollectionName()));
            if (this.getDatabaseName() != null) {
                bsonDocument.put("db", new BsonString(this.getDatabaseName()));
            }
            BsonDocument bsonDocument2 = new BsonDocument("mapReduce", new BsonString(this.namespace.getCollectionName())).append("map", this.getMapFunction()).append("reduce", this.getReduceFunction()).append("out", bsonDocument);
            DocumentHelper.putIfNotNull(bsonDocument2, "query", this.getFilter());
            DocumentHelper.putIfNotNull(bsonDocument2, "sort", this.getSort());
            DocumentHelper.putIfNotNull(bsonDocument2, "finalize", this.getFinalizeFunction());
            DocumentHelper.putIfNotNull(bsonDocument2, "scope", this.getScope());
            DocumentHelper.putIfTrue(bsonDocument2, "verbose", this.isVerbose());
            DocumentHelper.putIfNotZero(bsonDocument2, "limit", this.getLimit());
            DocumentHelper.putIfTrue(bsonDocument2, "jsMode", this.isJsMode());
            if (this.bypassDocumentValidation != null) {
                bsonDocument2.put("bypassDocumentValidation", BsonBoolean.valueOf(this.bypassDocumentValidation));
            }
            WriteConcernHelper.appendWriteConcernToCommand(this.writeConcern, bsonDocument2);
            if (this.collation != null) {
                bsonDocument2.put("collation", this.collation.asDocument());
            }
            return bsonDocument2;
        };
    }
}

