/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.operation;

import com.mongodb.ExplainVerbosity;
import com.mongodb.MongoNamespace;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.model.Collation;
import com.mongodb.internal.async.ErrorHandlingResultCallback;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.binding.AsyncReadBinding;
import com.mongodb.internal.binding.ReadBinding;
import com.mongodb.internal.connection.CommandHelper;
import com.mongodb.internal.operation.AsyncOperationHelper;
import com.mongodb.internal.operation.AsyncReadOperation;
import com.mongodb.internal.operation.AsyncSingleBatchCursor;
import com.mongodb.internal.operation.BsonDocumentWrapperHelper;
import com.mongodb.internal.operation.CommandOperationHelper;
import com.mongodb.internal.operation.CommandReadOperation;
import com.mongodb.internal.operation.CommandResultDocumentCodec;
import com.mongodb.internal.operation.DocumentHelper;
import com.mongodb.internal.operation.ExplainHelper;
import com.mongodb.internal.operation.MapReduceAsyncBatchCursor;
import com.mongodb.internal.operation.MapReduceBatchCursor;
import com.mongodb.internal.operation.MapReduceHelper;
import com.mongodb.internal.operation.MapReduceInlineResultsAsyncCursor;
import com.mongodb.internal.operation.MapReduceInlineResultsCursor;
import com.mongodb.internal.operation.OperationHelper;
import com.mongodb.internal.operation.OperationReadConcernHelper;
import com.mongodb.internal.operation.ReadOperation;
import com.mongodb.internal.operation.SingleBatchCursor;
import com.mongodb.internal.operation.SyncOperationHelper;
import com.mongodb.lang.Nullable;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonJavaScript;
import org.bson.BsonString;
import org.bson.codecs.BsonDocumentCodec;
import org.bson.codecs.Decoder;

public class MapReduceWithInlineResultsOperation<T>
implements AsyncReadOperation<MapReduceAsyncBatchCursor<T>>,
ReadOperation<MapReduceBatchCursor<T>> {
    private final MongoNamespace namespace;
    private final BsonJavaScript mapFunction;
    private final BsonJavaScript reduceFunction;
    private final Decoder<T> decoder;
    private BsonJavaScript finalizeFunction;
    private BsonDocument scope;
    private BsonDocument filter;
    private BsonDocument sort;
    private int limit;
    private boolean jsMode;
    private boolean verbose;
    private Collation collation;

    public MapReduceWithInlineResultsOperation(MongoNamespace mongoNamespace, BsonJavaScript bsonJavaScript, BsonJavaScript bsonJavaScript2, Decoder<T> decoder) {
        this.namespace = Assertions.notNull("namespace", mongoNamespace);
        this.mapFunction = Assertions.notNull("mapFunction", bsonJavaScript);
        this.reduceFunction = Assertions.notNull("reduceFunction", bsonJavaScript2);
        this.decoder = Assertions.notNull("decoder", decoder);
    }

    public MongoNamespace getNamespace() {
        return this.namespace;
    }

    public Decoder<T> getDecoder() {
        return this.decoder;
    }

    public BsonJavaScript getMapFunction() {
        return this.mapFunction;
    }

    public BsonJavaScript getReduceFunction() {
        return this.reduceFunction;
    }

    public BsonJavaScript getFinalizeFunction() {
        return this.finalizeFunction;
    }

    public MapReduceWithInlineResultsOperation<T> finalizeFunction(BsonJavaScript bsonJavaScript) {
        this.finalizeFunction = bsonJavaScript;
        return this;
    }

    public BsonDocument getScope() {
        return this.scope;
    }

    public MapReduceWithInlineResultsOperation<T> scope(@Nullable BsonDocument bsonDocument) {
        this.scope = bsonDocument;
        return this;
    }

    public BsonDocument getFilter() {
        return this.filter;
    }

    public MapReduceWithInlineResultsOperation<T> filter(@Nullable BsonDocument bsonDocument) {
        this.filter = bsonDocument;
        return this;
    }

    public BsonDocument getSort() {
        return this.sort;
    }

    public MapReduceWithInlineResultsOperation<T> sort(@Nullable BsonDocument bsonDocument) {
        this.sort = bsonDocument;
        return this;
    }

    public int getLimit() {
        return this.limit;
    }

    public MapReduceWithInlineResultsOperation<T> limit(int n) {
        this.limit = n;
        return this;
    }

    public boolean isJsMode() {
        return this.jsMode;
    }

    public MapReduceWithInlineResultsOperation<T> jsMode(boolean bl) {
        this.jsMode = bl;
        return this;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public MapReduceWithInlineResultsOperation<T> verbose(boolean bl) {
        this.verbose = bl;
        return this;
    }

    public Collation getCollation() {
        return this.collation;
    }

    public MapReduceWithInlineResultsOperation<T> collation(@Nullable Collation collation) {
        this.collation = collation;
        return this;
    }

    @Override
    public MapReduceBatchCursor<T> execute(ReadBinding readBinding) {
        return SyncOperationHelper.executeRetryableRead(readBinding, this.namespace.getDatabaseName(), this.getCommandCreator(), CommandResultDocumentCodec.create(this.decoder, "results"), this.transformer(), false);
    }

    @Override
    public void executeAsync(AsyncReadBinding asyncReadBinding, SingleResultCallback<MapReduceAsyncBatchCursor<T>> singleResultCallback) {
        SingleResultCallback<MapReduceAsyncBatchCursor<T>> singleResultCallback2 = ErrorHandlingResultCallback.errorHandlingCallback(singleResultCallback, OperationHelper.LOGGER);
        AsyncOperationHelper.executeRetryableReadAsync(asyncReadBinding, this.namespace.getDatabaseName(), this.getCommandCreator(), CommandResultDocumentCodec.create(this.decoder, "results"), this.asyncTransformer(), false, singleResultCallback2);
    }

    public ReadOperation<BsonDocument> asExplainableOperation(ExplainVerbosity explainVerbosity) {
        return this.createExplainableOperation(explainVerbosity);
    }

    public AsyncReadOperation<BsonDocument> asExplainableOperationAsync(ExplainVerbosity explainVerbosity) {
        return this.createExplainableOperation(explainVerbosity);
    }

    private CommandReadOperation<BsonDocument> createExplainableOperation(ExplainVerbosity explainVerbosity) {
        return new CommandReadOperation<BsonDocument>(this.namespace.getDatabaseName(), (operationContext, serverDescription, connectionDescription) -> {
            BsonDocument bsonDocument = this.getCommandCreator().create(operationContext, serverDescription, connectionDescription);
            CommandHelper.applyMaxTimeMS(operationContext.getTimeoutContext(), bsonDocument);
            return ExplainHelper.asExplainCommand(bsonDocument, explainVerbosity);
        }, new BsonDocumentCodec());
    }

    private SyncOperationHelper.CommandReadTransformer<BsonDocument, MapReduceBatchCursor<T>> transformer() {
        return (bsonDocument, connectionSource, connection) -> new MapReduceInlineResultsCursor(new SingleBatchCursor(BsonDocumentWrapperHelper.toList(bsonDocument, "results"), 0, connection.getDescription().getServerAddress()), MapReduceHelper.createStatistics(bsonDocument));
    }

    private AsyncOperationHelper.CommandReadTransformerAsync<BsonDocument, MapReduceAsyncBatchCursor<T>> asyncTransformer() {
        return (bsonDocument, asyncConnectionSource, asyncConnection) -> new MapReduceInlineResultsAsyncCursor(new AsyncSingleBatchCursor(BsonDocumentWrapperHelper.toList(bsonDocument, "results"), 0), MapReduceHelper.createStatistics(bsonDocument));
    }

    private CommandOperationHelper.CommandCreator getCommandCreator() {
        return (operationContext, serverDescription, connectionDescription) -> {
            BsonDocument bsonDocument = new BsonDocument("mapReduce", new BsonString(this.namespace.getCollectionName())).append("map", this.getMapFunction()).append("reduce", this.getReduceFunction()).append("out", new BsonDocument("inline", new BsonInt32(1)));
            DocumentHelper.putIfNotNull(bsonDocument, "query", this.getFilter());
            DocumentHelper.putIfNotNull(bsonDocument, "sort", this.getSort());
            DocumentHelper.putIfNotNull(bsonDocument, "finalize", this.getFinalizeFunction());
            DocumentHelper.putIfNotNull(bsonDocument, "scope", this.getScope());
            DocumentHelper.putIfTrue(bsonDocument, "verbose", this.isVerbose());
            OperationReadConcernHelper.appendReadConcernToCommand(operationContext.getSessionContext(), connectionDescription.getMaxWireVersion(), bsonDocument);
            DocumentHelper.putIfNotZero(bsonDocument, "limit", this.getLimit());
            DocumentHelper.putIfTrue(bsonDocument, "jsMode", this.isJsMode());
            if (this.collation != null) {
                bsonDocument.put("collation", this.collation.asDocument());
            }
            return bsonDocument;
        };
    }
}

