/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.operation;

import com.mongodb.MongoException;
import com.mongodb.MongoNamespace;
import com.mongodb.WriteConcern;
import com.mongodb.assertions.Assertions;
import com.mongodb.bulk.BulkWriteResult;
import com.mongodb.connection.ConnectionDescription;
import com.mongodb.internal.TimeoutContext;
import com.mongodb.internal.async.ErrorHandlingResultCallback;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.async.function.AsyncCallbackLoop;
import com.mongodb.internal.async.function.AsyncCallbackSupplier;
import com.mongodb.internal.async.function.LoopState;
import com.mongodb.internal.async.function.RetryState;
import com.mongodb.internal.async.function.RetryingAsyncCallbackSupplier;
import com.mongodb.internal.async.function.RetryingSyncSupplier;
import com.mongodb.internal.binding.AsyncWriteBinding;
import com.mongodb.internal.binding.WriteBinding;
import com.mongodb.internal.bulk.WriteRequest;
import com.mongodb.internal.connection.AsyncConnection;
import com.mongodb.internal.connection.Connection;
import com.mongodb.internal.connection.MongoWriteConcernWithResponseException;
import com.mongodb.internal.connection.OperationContext;
import com.mongodb.internal.connection.ProtocolHelper;
import com.mongodb.internal.operation.AsyncOperationHelper;
import com.mongodb.internal.operation.AsyncWriteOperation;
import com.mongodb.internal.operation.BulkWriteBatch;
import com.mongodb.internal.operation.CommandOperationHelper;
import com.mongodb.internal.operation.OperationHelper;
import com.mongodb.internal.operation.SyncOperationHelper;
import com.mongodb.internal.operation.WriteOperation;
import com.mongodb.internal.operation.retry.AttachmentKeys;
import com.mongodb.internal.session.SessionContext;
import com.mongodb.internal.validator.NoOpFieldNameValidator;
import com.mongodb.lang.Nullable;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.bson.BsonArray;
import org.bson.BsonDocument;
import org.bson.BsonString;
import org.bson.BsonValue;

public class MixedBulkWriteOperation
implements AsyncWriteOperation<BulkWriteResult>,
WriteOperation<BulkWriteResult> {
    private final MongoNamespace namespace;
    private final List<? extends WriteRequest> writeRequests;
    private final boolean ordered;
    private final boolean retryWrites;
    private final WriteConcern writeConcern;
    private Boolean bypassDocumentValidation;
    private BsonValue comment;
    private BsonDocument variables;

    public MixedBulkWriteOperation(MongoNamespace mongoNamespace, List<? extends WriteRequest> list, boolean bl, WriteConcern writeConcern, boolean bl2) {
        this.namespace = Assertions.notNull("namespace", mongoNamespace);
        this.writeRequests = Assertions.notNull("writes", list);
        this.ordered = bl;
        this.writeConcern = Assertions.notNull("writeConcern", writeConcern);
        this.retryWrites = bl2;
        Assertions.isTrueArgument("writes is not an empty list", !list.isEmpty());
    }

    public MongoNamespace getNamespace() {
        return this.namespace;
    }

    public WriteConcern getWriteConcern() {
        return this.writeConcern;
    }

    public boolean isOrdered() {
        return this.ordered;
    }

    public List<? extends WriteRequest> getWriteRequests() {
        return this.writeRequests;
    }

    public Boolean getBypassDocumentValidation() {
        return this.bypassDocumentValidation;
    }

    public MixedBulkWriteOperation bypassDocumentValidation(@Nullable Boolean bl) {
        this.bypassDocumentValidation = bl;
        return this;
    }

    public BsonValue getComment() {
        return this.comment;
    }

    public MixedBulkWriteOperation comment(@Nullable BsonValue bsonValue) {
        this.comment = bsonValue;
        return this;
    }

    public MixedBulkWriteOperation let(@Nullable BsonDocument bsonDocument) {
        this.variables = bsonDocument;
        return this;
    }

    public Boolean getRetryWrites() {
        return this.retryWrites;
    }

    private <R> Supplier<R> decorateWriteWithRetries(RetryState retryState, OperationContext operationContext, Supplier<R> supplier) {
        return new RetryingSyncSupplier<Object>(retryState, CommandOperationHelper.onRetryableWriteAttemptFailure(operationContext), this::shouldAttemptToRetryWrite, () -> {
            CommandOperationHelper.logRetryExecute(retryState, operationContext);
            return supplier.get();
        });
    }

    private <R> AsyncCallbackSupplier<R> decorateWriteWithRetries(RetryState retryState, OperationContext operationContext, AsyncCallbackSupplier<R> asyncCallbackSupplier) {
        return new RetryingAsyncCallbackSupplier(retryState, CommandOperationHelper.onRetryableWriteAttemptFailure(operationContext), this::shouldAttemptToRetryWrite, singleResultCallback -> {
            CommandOperationHelper.logRetryExecute(retryState, operationContext);
            asyncCallbackSupplier.get(singleResultCallback);
        });
    }

    private boolean shouldAttemptToRetryWrite(RetryState retryState, Throwable throwable) {
        BulkWriteTracker bulkWriteTracker = retryState.attachment(AttachmentKeys.bulkWriteTracker()).orElseThrow(Assertions::fail);
        if (bulkWriteTracker.lastAttempt()) {
            return false;
        }
        boolean bl = CommandOperationHelper.loggingShouldAttemptToRetryWriteAndAddRetryableLabel(retryState, throwable);
        if (bl) {
            bulkWriteTracker.advance();
        }
        return bl;
    }

    @Override
    public BulkWriteResult execute(WriteBinding writeBinding) {
        TimeoutContext timeoutContext = writeBinding.getOperationContext().getTimeoutContext();
        RetryState retryState = new RetryState(timeoutContext);
        BulkWriteTracker.attachNew(retryState, this.retryWrites, timeoutContext);
        Supplier<BulkWriteResult> supplier = this.decorateWriteWithRetries(retryState, writeBinding.getOperationContext(), () -> SyncOperationHelper.withSourceAndConnection(writeBinding::getWriteConnectionSource, true, (connectionSource, connection) -> {
            ConnectionDescription connectionDescription = connection.getDescription();
            retryState.attach(AttachmentKeys.maxWireVersion(), connectionDescription.getMaxWireVersion(), true);
            SessionContext sessionContext = writeBinding.getOperationContext().getSessionContext();
            WriteConcern writeConcern = CommandOperationHelper.validateAndGetEffectiveWriteConcern(this.writeConcern, sessionContext);
            if (!OperationHelper.isRetryableWrite(this.retryWrites, writeConcern, connectionDescription, sessionContext)) {
                this.handleMongoWriteConcernWithResponseException(retryState, true, timeoutContext);
            }
            OperationHelper.validateWriteRequests(connectionDescription, this.bypassDocumentValidation, this.writeRequests, writeConcern);
            if (!retryState.attachment(AttachmentKeys.bulkWriteTracker()).orElseThrow(Assertions::fail).batch().isPresent()) {
                BulkWriteTracker.attachNew(retryState, BulkWriteBatch.createBulkWriteBatch(this.namespace, connectionDescription, this.ordered, writeConcern, this.bypassDocumentValidation, this.retryWrites, this.writeRequests, writeBinding.getOperationContext(), this.comment, this.variables), timeoutContext);
            }
            return this.executeBulkWriteBatch(retryState, writeConcern, writeBinding, (Connection)connection);
        }));
        try {
            return supplier.get();
        }
        catch (MongoException mongoException) {
            throw CommandOperationHelper.transformWriteException(mongoException);
        }
    }

    @Override
    public void executeAsync(AsyncWriteBinding asyncWriteBinding, SingleResultCallback<BulkWriteResult> singleResultCallback) {
        TimeoutContext timeoutContext = asyncWriteBinding.getOperationContext().getTimeoutContext();
        RetryState retryState = new RetryState(timeoutContext);
        BulkWriteTracker.attachNew(retryState, this.retryWrites, timeoutContext);
        asyncWriteBinding.retain();
        AsyncCallbackSupplier<BulkWriteResult> asyncCallbackSupplier = this.decorateWriteWithRetries(retryState, asyncWriteBinding.getOperationContext(), (SingleResultCallback<R> singleResultCallback2) -> AsyncOperationHelper.withAsyncSourceAndConnection(asyncWriteBinding::getWriteConnectionSource, true, singleResultCallback2, (asyncConnectionSource, asyncConnection, singleResultCallback) -> {
            ConnectionDescription connectionDescription = asyncConnection.getDescription();
            retryState.attach(AttachmentKeys.maxWireVersion(), connectionDescription.getMaxWireVersion(), true);
            SessionContext sessionContext = asyncWriteBinding.getOperationContext().getSessionContext();
            WriteConcern writeConcern = CommandOperationHelper.validateAndGetEffectiveWriteConcern(this.writeConcern, sessionContext);
            if (!OperationHelper.isRetryableWrite(this.retryWrites, writeConcern, connectionDescription, sessionContext) && this.handleMongoWriteConcernWithResponseExceptionAsync(retryState, singleResultCallback, timeoutContext)) {
                return;
            }
            if (OperationHelper.validateWriteRequestsAndCompleteIfInvalid(connectionDescription, this.bypassDocumentValidation, this.writeRequests, writeConcern, singleResultCallback)) {
                return;
            }
            try {
                if (!retryState.attachment(AttachmentKeys.bulkWriteTracker()).orElseThrow(Assertions::fail).batch().isPresent()) {
                    BulkWriteTracker.attachNew(retryState, BulkWriteBatch.createBulkWriteBatch(this.namespace, connectionDescription, this.ordered, writeConcern, this.bypassDocumentValidation, this.retryWrites, this.writeRequests, asyncWriteBinding.getOperationContext(), this.comment, this.variables), timeoutContext);
                }
            }
            catch (Throwable throwable) {
                singleResultCallback.onResult(null, throwable);
                return;
            }
            this.executeBulkWriteBatchAsync(retryState, writeConcern, asyncWriteBinding, (AsyncConnection)asyncConnection, singleResultCallback);
        })).whenComplete(asyncWriteBinding::release);
        asyncCallbackSupplier.get(AsyncOperationHelper.exceptionTransformingCallback(ErrorHandlingResultCallback.errorHandlingCallback(singleResultCallback, OperationHelper.LOGGER)));
    }

    private BulkWriteResult executeBulkWriteBatch(RetryState retryState, WriteConcern writeConcern, WriteBinding writeBinding, Connection connection) {
        BulkWriteTracker bulkWriteTracker = retryState.attachment(AttachmentKeys.bulkWriteTracker()).orElseThrow(Assertions::fail);
        BulkWriteBatch bulkWriteBatch = bulkWriteTracker.batch().orElseThrow(Assertions::fail);
        int n = connection.getDescription().getMaxWireVersion();
        OperationContext operationContext = writeBinding.getOperationContext();
        TimeoutContext timeoutContext = operationContext.getTimeoutContext();
        while (bulkWriteBatch.shouldProcessBatch()) {
            try {
                MongoException mongoException;
                BsonDocument bsonDocument = this.executeCommand(writeConcern, operationContext, connection, bulkWriteBatch);
                if (bulkWriteBatch.getRetryWrites() && !operationContext.getSessionContext().hasActiveTransaction() && (mongoException = ProtocolHelper.createSpecialException(bsonDocument, connection.getDescription().getServerAddress(), "errMsg", timeoutContext)) != null) {
                    if (bulkWriteTracker.lastAttempt()) {
                        CommandOperationHelper.addRetryableWriteErrorLabel(mongoException, n);
                        this.addErrorLabelsToWriteConcern(bsonDocument.getDocument("writeConcernError"), mongoException.getErrorLabels());
                    } else if (CommandOperationHelper.loggingShouldAttemptToRetryWriteAndAddRetryableLabel(retryState, mongoException)) {
                        throw new MongoWriteConcernWithResponseException(mongoException, bsonDocument);
                    }
                }
                bulkWriteBatch.addResult(bsonDocument);
                bulkWriteTracker = BulkWriteTracker.attachNext(retryState, bulkWriteBatch, timeoutContext);
                bulkWriteBatch = bulkWriteTracker.batch().orElseThrow(Assertions::fail);
            }
            catch (MongoException mongoException) {
                if (!retryState.isFirstAttempt() && !(mongoException instanceof MongoWriteConcernWithResponseException)) {
                    CommandOperationHelper.addRetryableWriteErrorLabel(mongoException, n);
                }
                this.handleMongoWriteConcernWithResponseException(retryState, false, timeoutContext);
                throw mongoException;
            }
        }
        try {
            return bulkWriteBatch.getResult();
        }
        catch (MongoException mongoException) {
            retryState.markAsLastAttempt();
            throw mongoException;
        }
    }

    private void executeBulkWriteBatchAsync(RetryState retryState, WriteConcern writeConcern, AsyncWriteBinding asyncWriteBinding, AsyncConnection asyncConnection, SingleResultCallback<BulkWriteResult> singleResultCallback2) {
        LoopState loopState = new LoopState();
        AsyncCallbackLoop asyncCallbackLoop = new AsyncCallbackLoop(loopState, singleResultCallback -> {
            BulkWriteTracker bulkWriteTracker = retryState.attachment(AttachmentKeys.bulkWriteTracker()).orElseThrow(Assertions::fail);
            loopState.attach(AttachmentKeys.bulkWriteTracker(), bulkWriteTracker, true);
            BulkWriteBatch bulkWriteBatch = bulkWriteTracker.batch().orElseThrow(Assertions::fail);
            int n = asyncConnection.getDescription().getMaxWireVersion();
            if (loopState.breakAndCompleteIf(() -> !bulkWriteBatch.shouldProcessBatch(), singleResultCallback)) {
                return;
            }
            OperationContext operationContext = asyncWriteBinding.getOperationContext();
            TimeoutContext timeoutContext = operationContext.getTimeoutContext();
            this.executeCommandAsync(writeConcern, operationContext, asyncConnection, bulkWriteBatch, (bsonDocument, throwable) -> {
                if (throwable == null) {
                    MongoException mongoException;
                    if (bulkWriteBatch.getRetryWrites() && !operationContext.getSessionContext().hasActiveTransaction() && (mongoException = ProtocolHelper.createSpecialException(bsonDocument, asyncConnection.getDescription().getServerAddress(), "errMsg", asyncWriteBinding.getOperationContext().getTimeoutContext())) != null) {
                        if (bulkWriteTracker.lastAttempt()) {
                            CommandOperationHelper.addRetryableWriteErrorLabel(mongoException, n);
                            this.addErrorLabelsToWriteConcern(bsonDocument.getDocument("writeConcernError"), mongoException.getErrorLabels());
                        } else if (CommandOperationHelper.loggingShouldAttemptToRetryWriteAndAddRetryableLabel(retryState, mongoException)) {
                            singleResultCallback.onResult(null, new MongoWriteConcernWithResponseException(mongoException, bsonDocument));
                            return;
                        }
                    }
                    bulkWriteBatch.addResult((BsonDocument)bsonDocument);
                    BulkWriteTracker.attachNext(retryState, bulkWriteBatch, timeoutContext);
                    singleResultCallback.onResult(null, null);
                } else {
                    if (throwable instanceof MongoException) {
                        MongoException mongoException = (MongoException)throwable;
                        if (!retryState.isFirstAttempt() && !(mongoException instanceof MongoWriteConcernWithResponseException)) {
                            CommandOperationHelper.addRetryableWriteErrorLabel(mongoException, n);
                        }
                        if (this.handleMongoWriteConcernWithResponseExceptionAsync(retryState, null, timeoutContext)) {
                            return;
                        }
                    }
                    singleResultCallback.onResult(null, throwable);
                }
            });
        });
        asyncCallbackLoop.run((void_, throwable) -> {
            if (throwable != null) {
                singleResultCallback2.onResult(null, throwable);
            } else {
                BulkWriteResult bulkWriteResult;
                try {
                    bulkWriteResult = ((BulkWriteBatch)loopState.attachment(AttachmentKeys.bulkWriteTracker()).flatMap(BulkWriteTracker::batch).orElseThrow(Assertions::fail)).getResult();
                }
                catch (Throwable throwable2) {
                    if (throwable2 instanceof MongoException) {
                        retryState.markAsLastAttempt();
                    }
                    singleResultCallback2.onResult(null, throwable2);
                    return;
                }
                singleResultCallback2.onResult(bulkWriteResult, null);
            }
        });
    }

    private void handleMongoWriteConcernWithResponseException(RetryState retryState, boolean bl, TimeoutContext timeoutContext) {
        if (!retryState.isFirstAttempt()) {
            RuntimeException runtimeException = retryState.exception().orElse(null);
            boolean bl2 = runtimeException instanceof MongoWriteConcernWithResponseException;
            retryState.breakAndThrowIfRetryAnd(() -> bl && !bl2);
            if (bl2) {
                retryState.attachment(AttachmentKeys.bulkWriteTracker()).orElseThrow(Assertions::fail).batch().ifPresent(bulkWriteBatch -> {
                    bulkWriteBatch.addResult((BsonDocument)((MongoWriteConcernWithResponseException)runtimeException).getResponse());
                    BulkWriteTracker.attachNext(retryState, bulkWriteBatch, timeoutContext);
                });
            }
        }
    }

    private boolean handleMongoWriteConcernWithResponseExceptionAsync(RetryState retryState, @Nullable SingleResultCallback<BulkWriteResult> singleResultCallback, TimeoutContext timeoutContext) {
        if (!retryState.isFirstAttempt()) {
            RuntimeException runtimeException = retryState.exception().orElse(null);
            boolean bl = runtimeException instanceof MongoWriteConcernWithResponseException;
            if (singleResultCallback != null && retryState.breakAndCompleteIfRetryAnd(() -> !bl, singleResultCallback)) {
                return true;
            }
            if (bl) {
                retryState.attachment(AttachmentKeys.bulkWriteTracker()).orElseThrow(Assertions::fail).batch().ifPresent(bulkWriteBatch -> {
                    bulkWriteBatch.addResult((BsonDocument)((MongoWriteConcernWithResponseException)runtimeException).getResponse());
                    BulkWriteTracker.attachNext(retryState, bulkWriteBatch, timeoutContext);
                });
            }
        }
        return false;
    }

    @Nullable
    private BsonDocument executeCommand(WriteConcern writeConcern, OperationContext operationContext, Connection connection, BulkWriteBatch bulkWriteBatch) {
        return connection.command(this.namespace.getDatabaseName(), bulkWriteBatch.getCommand(), NoOpFieldNameValidator.INSTANCE, null, bulkWriteBatch.getDecoder(), operationContext, this.shouldExpectResponse(bulkWriteBatch, writeConcern), bulkWriteBatch.getPayload());
    }

    private void executeCommandAsync(WriteConcern writeConcern, OperationContext operationContext, AsyncConnection asyncConnection, BulkWriteBatch bulkWriteBatch, SingleResultCallback<BsonDocument> singleResultCallback) {
        asyncConnection.commandAsync(this.namespace.getDatabaseName(), bulkWriteBatch.getCommand(), NoOpFieldNameValidator.INSTANCE, null, bulkWriteBatch.getDecoder(), operationContext, this.shouldExpectResponse(bulkWriteBatch, writeConcern), bulkWriteBatch.getPayload(), singleResultCallback);
    }

    private boolean shouldExpectResponse(BulkWriteBatch bulkWriteBatch, WriteConcern writeConcern) {
        return writeConcern.isAcknowledged() || this.ordered && bulkWriteBatch.hasAnotherBatch();
    }

    private void addErrorLabelsToWriteConcern(BsonDocument bsonDocument, Set<String> set) {
        if (!bsonDocument.containsKey("errorLabels")) {
            bsonDocument.put("errorLabels", new BsonArray(set.stream().map(BsonString::new).collect(Collectors.toList())));
        }
    }

    public static final class BulkWriteTracker {
        private int attempt = 0;
        private final int attempts;
        private final boolean retryUntilTimeoutThrowsException;
        @Nullable
        private final BulkWriteBatch batch;

        static void attachNew(RetryState retryState, boolean bl, TimeoutContext timeoutContext) {
            retryState.attach(AttachmentKeys.bulkWriteTracker(), new BulkWriteTracker(bl, null, timeoutContext), false);
        }

        static void attachNew(RetryState retryState, BulkWriteBatch bulkWriteBatch, TimeoutContext timeoutContext) {
            BulkWriteTracker.attach(retryState, new BulkWriteTracker(bulkWriteBatch.getRetryWrites(), bulkWriteBatch, timeoutContext));
        }

        static BulkWriteTracker attachNext(RetryState retryState, BulkWriteBatch bulkWriteBatch, TimeoutContext timeoutContext) {
            BulkWriteBatch bulkWriteBatch2 = bulkWriteBatch.getNextBatch();
            BulkWriteTracker bulkWriteTracker = new BulkWriteTracker(bulkWriteBatch2.getRetryWrites(), bulkWriteBatch2, timeoutContext);
            BulkWriteTracker.attach(retryState, bulkWriteTracker);
            return bulkWriteTracker;
        }

        private static void attach(RetryState retryState, BulkWriteTracker bulkWriteTracker) {
            retryState.attach(AttachmentKeys.bulkWriteTracker(), bulkWriteTracker, false);
            BulkWriteBatch bulkWriteBatch = bulkWriteTracker.batch;
            if (bulkWriteBatch != null) {
                retryState.attach(AttachmentKeys.retryableCommandFlag(), bulkWriteBatch.getRetryWrites(), false).attach(AttachmentKeys.commandDescriptionSupplier(), () -> bulkWriteBatch.getPayload().getPayloadType().toString(), false);
            }
        }

        private BulkWriteTracker(boolean bl, @Nullable BulkWriteBatch bulkWriteBatch, TimeoutContext timeoutContext) {
            this.attempts = bl ? 2 : 1;
            this.batch = bulkWriteBatch;
            this.retryUntilTimeoutThrowsException = timeoutContext.hasTimeoutMS();
        }

        boolean lastAttempt() {
            if (this.retryUntilTimeoutThrowsException) {
                return false;
            }
            return this.attempt == this.attempts - 1;
        }

        void advance() {
            Assertions.assertTrue(!this.lastAttempt());
            ++this.attempt;
        }

        Optional<BulkWriteBatch> batch() {
            return Optional.ofNullable(this.batch);
        }
    }
}

