/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.operation;

import com.mongodb.ClientBulkWriteException;
import com.mongodb.MongoClientException;
import com.mongodb.MongoException;
import com.mongodb.WriteConcern;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.cursor.TimeoutMode;
import com.mongodb.client.model.Collation;
import com.mongodb.connection.ConnectionDescription;
import com.mongodb.connection.ServerDescription;
import com.mongodb.connection.ServerType;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.bulk.DeleteRequest;
import com.mongodb.internal.bulk.UpdateRequest;
import com.mongodb.internal.bulk.WriteRequest;
import com.mongodb.internal.connection.OperationContext;
import com.mongodb.internal.diagnostics.logging.Logger;
import com.mongodb.internal.diagnostics.logging.Loggers;
import com.mongodb.internal.operation.ServerVersionHelper;
import com.mongodb.internal.session.SessionContext;
import com.mongodb.lang.NonNull;
import com.mongodb.lang.Nullable;
import java.util.List;
import org.bson.BsonDocument;

public final class OperationHelper {
    public static final Logger LOGGER = Loggers.getLogger("operation");

    static void validateCollationAndWriteConcern(@Nullable Collation collation, WriteConcern writeConcern) {
        if (collation != null && !writeConcern.isAcknowledged()) {
            throw new MongoClientException("Specifying collation with an unacknowledged WriteConcern is not supported");
        }
    }

    private static void validateArrayFilters(WriteConcern writeConcern) {
        if (!writeConcern.isAcknowledged()) {
            throw new MongoClientException("Specifying array filters with an unacknowledged WriteConcern is not supported");
        }
    }

    private static void validateWriteRequestHint(ConnectionDescription connectionDescription, WriteConcern writeConcern, WriteRequest writeRequest) {
        if (!writeConcern.isAcknowledged()) {
            if (writeRequest instanceof UpdateRequest && ServerVersionHelper.serverIsLessThanVersionFourDotTwo(connectionDescription)) {
                throw new IllegalArgumentException(String.format("Hint not supported by wire version: %s", connectionDescription.getMaxWireVersion()));
            }
            if (writeRequest instanceof DeleteRequest && ServerVersionHelper.serverIsLessThanVersionFourDotFour(connectionDescription)) {
                throw new IllegalArgumentException(String.format("Hint not supported by wire version: %s", connectionDescription.getMaxWireVersion()));
            }
        }
    }

    static void validateHintForFindAndModify(ConnectionDescription connectionDescription, WriteConcern writeConcern) {
        if (ServerVersionHelper.serverIsLessThanVersionFourDotTwo(connectionDescription)) {
            throw new IllegalArgumentException(String.format("Hint not supported by wire version: %s", connectionDescription.getMaxWireVersion()));
        }
        if (!writeConcern.isAcknowledged() && ServerVersionHelper.serverIsLessThanVersionFourDotFour(connectionDescription)) {
            throw new IllegalArgumentException(String.format("Hint not supported by wire version: %s", connectionDescription.getMaxWireVersion()));
        }
    }

    private static void validateWriteRequestCollations(List<? extends WriteRequest> list, WriteConcern writeConcern) {
        Collation collation = null;
        for (WriteRequest writeRequest : list) {
            if (writeRequest instanceof UpdateRequest) {
                collation = ((UpdateRequest)writeRequest).getCollation();
            } else if (writeRequest instanceof DeleteRequest) {
                collation = ((DeleteRequest)writeRequest).getCollation();
            }
            if (collation == null) continue;
            break;
        }
        OperationHelper.validateCollationAndWriteConcern(collation, writeConcern);
    }

    private static void validateUpdateRequestArrayFilters(List<? extends WriteRequest> list, WriteConcern writeConcern) {
        for (WriteRequest writeRequest : list) {
            List<BsonDocument> list2 = null;
            if (writeRequest instanceof UpdateRequest) {
                list2 = ((UpdateRequest)writeRequest).getArrayFilters();
            }
            if (list2 == null) continue;
            OperationHelper.validateArrayFilters(writeConcern);
            break;
        }
    }

    private static void validateWriteRequestHints(ConnectionDescription connectionDescription, List<? extends WriteRequest> list, WriteConcern writeConcern) {
        for (WriteRequest writeRequest : list) {
            BsonDocument bsonDocument = null;
            String string = null;
            if (writeRequest instanceof UpdateRequest) {
                bsonDocument = ((UpdateRequest)writeRequest).getHint();
                string = ((UpdateRequest)writeRequest).getHintString();
            } else if (writeRequest instanceof DeleteRequest) {
                bsonDocument = ((DeleteRequest)writeRequest).getHint();
                string = ((DeleteRequest)writeRequest).getHintString();
            }
            if (bsonDocument == null && string == null) continue;
            OperationHelper.validateWriteRequestHint(connectionDescription, writeConcern, writeRequest);
            break;
        }
    }

    static void validateWriteRequests(ConnectionDescription connectionDescription, Boolean bl, List<? extends WriteRequest> list, WriteConcern writeConcern) {
        OperationHelper.checkBypassDocumentValidationIsSupported(bl, writeConcern);
        OperationHelper.validateWriteRequestCollations(list, writeConcern);
        OperationHelper.validateUpdateRequestArrayFilters(list, writeConcern);
        OperationHelper.validateWriteRequestHints(connectionDescription, list, writeConcern);
    }

    static <R> boolean validateWriteRequestsAndCompleteIfInvalid(ConnectionDescription connectionDescription, Boolean bl, List<? extends WriteRequest> list, WriteConcern writeConcern, SingleResultCallback<R> singleResultCallback) {
        try {
            OperationHelper.validateWriteRequests(connectionDescription, bl, list, writeConcern);
            return false;
        }
        catch (Throwable throwable) {
            singleResultCallback.onResult(null, throwable);
            return true;
        }
    }

    private static void checkBypassDocumentValidationIsSupported(@Nullable Boolean bl, WriteConcern writeConcern) {
        if (bl != null && !writeConcern.isAcknowledged()) {
            throw new MongoClientException("Specifying bypassDocumentValidation with an unacknowledged WriteConcern is not supported");
        }
    }

    static boolean isRetryableWrite(boolean bl, WriteConcern writeConcern, ConnectionDescription connectionDescription, SessionContext sessionContext) {
        if (!bl) {
            return false;
        }
        if (!writeConcern.isAcknowledged()) {
            LOGGER.debug("retryWrites set to true but the writeConcern is unacknowledged.");
            return false;
        }
        if (sessionContext.hasActiveTransaction()) {
            LOGGER.debug("retryWrites set to true but in an active transaction.");
            return false;
        }
        return OperationHelper.canRetryWrite(connectionDescription, sessionContext);
    }

    static boolean canRetryWrite(ConnectionDescription connectionDescription, SessionContext sessionContext) {
        if (connectionDescription.getLogicalSessionTimeoutMinutes() == null) {
            LOGGER.debug("retryWrites set to true but the server does not support sessions.");
            return false;
        }
        if (connectionDescription.getServerType().equals((Object)ServerType.STANDALONE)) {
            LOGGER.debug("retryWrites set to true but the server is a standalone server.");
            return false;
        }
        return true;
    }

    static boolean canRetryRead(ServerDescription serverDescription, OperationContext operationContext) {
        if (operationContext.getSessionContext().hasActiveTransaction()) {
            LOGGER.debug("retryReads set to true but in an active transaction.");
            return false;
        }
        return true;
    }

    static void setNonTailableCursorMaxTimeSupplier(TimeoutMode timeoutMode, OperationContext operationContext) {
        if (timeoutMode == TimeoutMode.ITERATION) {
            operationContext.getTimeoutContext().disableMaxTimeOverride();
        }
    }

    public static MongoException unwrap(MongoException mongoException) {
        MongoException mongoException2 = mongoException;
        if (mongoException instanceof ClientBulkWriteException) {
            MongoException mongoException3 = ((ClientBulkWriteException)mongoException).getCause();
            mongoException2 = mongoException3 == null ? mongoException : mongoException3;
        }
        return mongoException2;
    }

    private OperationHelper() {
    }

    public static final class ResourceSupplierInternalException
    extends RuntimeException {
        private static final long serialVersionUID = 0L;

        ResourceSupplierInternalException(Throwable throwable) {
            super(Assertions.assertNotNull(throwable));
        }

        @Override
        @NonNull
        public Throwable getCause() {
            return Assertions.assertNotNull(super.getCause());
        }
    }
}

