/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.operation;

import com.mongodb.assertions.Assertions;
import com.mongodb.internal.connection.ReadConcernHelper;
import com.mongodb.internal.session.SessionContext;
import org.bson.BsonDocument;

final class OperationReadConcernHelper {
    static void appendReadConcernToCommand(SessionContext sessionContext, int n, BsonDocument bsonDocument) {
        Assertions.notNull("commandDocument", bsonDocument);
        Assertions.notNull("sessionContext", sessionContext);
        if (sessionContext.hasActiveTransaction()) {
            return;
        }
        if (sessionContext.isSnapshot()) {
            return;
        }
        BsonDocument bsonDocument2 = ReadConcernHelper.getReadConcernDocument(sessionContext, n);
        if (!bsonDocument2.isEmpty()) {
            bsonDocument.append("readConcern", bsonDocument2);
        }
    }

    private OperationReadConcernHelper() {
    }
}

