/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.operation;

import com.mongodb.AutoEncryptionSettings;
import com.mongodb.MongoNamespace;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.cursor.TimeoutMode;
import com.mongodb.client.model.BulkWriteOptions;
import com.mongodb.client.model.ClusteredIndexOptions;
import com.mongodb.client.model.Collation;
import com.mongodb.client.model.CountOptions;
import com.mongodb.client.model.CreateCollectionOptions;
import com.mongodb.client.model.CreateIndexOptions;
import com.mongodb.client.model.CreateViewOptions;
import com.mongodb.client.model.DeleteManyModel;
import com.mongodb.client.model.DeleteOneModel;
import com.mongodb.client.model.DeleteOptions;
import com.mongodb.client.model.DropCollectionOptions;
import com.mongodb.client.model.DropIndexOptions;
import com.mongodb.client.model.EstimatedDocumentCountOptions;
import com.mongodb.client.model.FindOneAndDeleteOptions;
import com.mongodb.client.model.FindOneAndReplaceOptions;
import com.mongodb.client.model.FindOneAndUpdateOptions;
import com.mongodb.client.model.IndexModel;
import com.mongodb.client.model.IndexOptionDefaults;
import com.mongodb.client.model.InsertManyOptions;
import com.mongodb.client.model.InsertOneModel;
import com.mongodb.client.model.InsertOneOptions;
import com.mongodb.client.model.MapReduceAction;
import com.mongodb.client.model.RenameCollectionOptions;
import com.mongodb.client.model.ReplaceOneModel;
import com.mongodb.client.model.ReplaceOptions;
import com.mongodb.client.model.ReturnDocument;
import com.mongodb.client.model.SearchIndexModel;
import com.mongodb.client.model.SearchIndexType;
import com.mongodb.client.model.UpdateManyModel;
import com.mongodb.client.model.UpdateOneModel;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.model.ValidationOptions;
import com.mongodb.client.model.WriteModel;
import com.mongodb.client.model.bulk.ClientBulkWriteOptions;
import com.mongodb.client.model.bulk.ClientNamespacedWriteModel;
import com.mongodb.client.model.changestream.FullDocument;
import com.mongodb.client.model.changestream.FullDocumentBeforeChange;
import com.mongodb.internal.bulk.DeleteRequest;
import com.mongodb.internal.bulk.IndexRequest;
import com.mongodb.internal.bulk.InsertRequest;
import com.mongodb.internal.bulk.UpdateRequest;
import com.mongodb.internal.bulk.WriteRequest;
import com.mongodb.internal.client.model.AggregationLevel;
import com.mongodb.internal.client.model.FindOptions;
import com.mongodb.internal.client.model.changestream.ChangeStreamLevel;
import com.mongodb.internal.operation.AggregateOperation;
import com.mongodb.internal.operation.AggregateToCollectionOperation;
import com.mongodb.internal.operation.ChangeStreamOperation;
import com.mongodb.internal.operation.ClientBulkWriteOperation;
import com.mongodb.internal.operation.CommandReadOperation;
import com.mongodb.internal.operation.CountDocumentsOperation;
import com.mongodb.internal.operation.CreateCollectionOperation;
import com.mongodb.internal.operation.CreateIndexesOperation;
import com.mongodb.internal.operation.CreateSearchIndexesOperation;
import com.mongodb.internal.operation.CreateViewOperation;
import com.mongodb.internal.operation.DistinctOperation;
import com.mongodb.internal.operation.DropCollectionOperation;
import com.mongodb.internal.operation.DropDatabaseOperation;
import com.mongodb.internal.operation.DropIndexOperation;
import com.mongodb.internal.operation.DropSearchIndexOperation;
import com.mongodb.internal.operation.EstimatedDocumentCountOperation;
import com.mongodb.internal.operation.FindAndDeleteOperation;
import com.mongodb.internal.operation.FindAndReplaceOperation;
import com.mongodb.internal.operation.FindAndUpdateOperation;
import com.mongodb.internal.operation.FindOperation;
import com.mongodb.internal.operation.ListCollectionsOperation;
import com.mongodb.internal.operation.ListDatabasesOperation;
import com.mongodb.internal.operation.ListIndexesOperation;
import com.mongodb.internal.operation.ListSearchIndexesOperation;
import com.mongodb.internal.operation.MapReduceToCollectionOperation;
import com.mongodb.internal.operation.MapReduceWithInlineResultsOperation;
import com.mongodb.internal.operation.MixedBulkWriteOperation;
import com.mongodb.internal.operation.RenameCollectionOperation;
import com.mongodb.internal.operation.SearchIndexRequest;
import com.mongodb.internal.operation.UpdateSearchIndexesOperation;
import com.mongodb.lang.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.bson.BsonArray;
import org.bson.BsonDocument;
import org.bson.BsonDocumentWrapper;
import org.bson.BsonJavaScript;
import org.bson.BsonString;
import org.bson.BsonTimestamp;
import org.bson.BsonValue;
import org.bson.codecs.Codec;
import org.bson.codecs.CollectibleCodec;
import org.bson.codecs.Decoder;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;

final class Operations<TDocument> {
    private final MongoNamespace namespace;
    private final Class<TDocument> documentClass;
    private final ReadPreference readPreference;
    private final CodecRegistry codecRegistry;
    private final ReadConcern readConcern;
    private final WriteConcern writeConcern;
    private final boolean retryWrites;
    private final boolean retryReads;

    Operations(@Nullable MongoNamespace mongoNamespace, Class<TDocument> clazz, ReadPreference readPreference, CodecRegistry codecRegistry, ReadConcern readConcern, WriteConcern writeConcern, boolean bl, boolean bl2) {
        this.namespace = mongoNamespace;
        this.documentClass = clazz;
        this.readPreference = readPreference;
        this.codecRegistry = codecRegistry;
        this.readConcern = readConcern;
        this.writeConcern = writeConcern;
        this.retryWrites = bl;
        this.retryReads = bl2;
    }

    @Nullable
    MongoNamespace getNamespace() {
        return this.namespace;
    }

    Class<TDocument> getDocumentClass() {
        return this.documentClass;
    }

    ReadPreference getReadPreference() {
        return this.readPreference;
    }

    CodecRegistry getCodecRegistry() {
        return this.codecRegistry;
    }

    ReadConcern getReadConcern() {
        return this.readConcern;
    }

    WriteConcern getWriteConcern() {
        return this.writeConcern;
    }

    boolean isRetryWrites() {
        return this.retryWrites;
    }

    boolean isRetryReads() {
        return this.retryReads;
    }

    CountDocumentsOperation countDocuments(Bson bson, CountOptions countOptions) {
        CountDocumentsOperation countDocumentsOperation = new CountDocumentsOperation(Assertions.assertNotNull(this.namespace)).retryReads(this.retryReads).filter(this.toBsonDocument(bson)).skip(countOptions.getSkip()).limit(countOptions.getLimit()).collation(countOptions.getCollation()).comment(countOptions.getComment());
        if (countOptions.getHint() != null) {
            countDocumentsOperation.hint(this.toBsonDocument(countOptions.getHint()));
        } else if (countOptions.getHintString() != null) {
            countDocumentsOperation.hint(new BsonString(countOptions.getHintString()));
        }
        return countDocumentsOperation;
    }

    EstimatedDocumentCountOperation estimatedDocumentCount(EstimatedDocumentCountOptions estimatedDocumentCountOptions) {
        return new EstimatedDocumentCountOperation(Assertions.assertNotNull(this.namespace)).retryReads(this.retryReads).comment(estimatedDocumentCountOptions.getComment());
    }

    <TResult> FindOperation<TResult> findFirst(Bson bson, Class<TResult> clazz, FindOptions findOptions) {
        return this.createFindOperation(Assertions.assertNotNull(this.namespace), bson, clazz, findOptions).batchSize(0).limit(-1);
    }

    <TResult> FindOperation<TResult> find(Bson bson, Class<TResult> clazz, FindOptions findOptions) {
        return this.createFindOperation(Assertions.assertNotNull(this.namespace), bson, clazz, findOptions);
    }

    <TResult> FindOperation<TResult> find(MongoNamespace mongoNamespace, @Nullable Bson bson, Class<TResult> clazz, FindOptions findOptions) {
        return this.createFindOperation(mongoNamespace, bson, clazz, findOptions);
    }

    private <TResult> FindOperation<TResult> createFindOperation(MongoNamespace mongoNamespace, @Nullable Bson bson, Class<TResult> clazz, FindOptions findOptions) {
        FindOperation<TResult> findOperation = new FindOperation<TResult>(mongoNamespace, this.codecRegistry.get(clazz)).retryReads(this.retryReads).filter(bson == null ? new BsonDocument() : bson.toBsonDocument(this.documentClass, this.codecRegistry)).batchSize(findOptions.getBatchSize()).skip(findOptions.getSkip()).limit(findOptions.getLimit()).projection(this.toBsonDocument(findOptions.getProjection())).sort(this.toBsonDocument(findOptions.getSort())).cursorType(findOptions.getCursorType()).noCursorTimeout(findOptions.isNoCursorTimeout()).partial(findOptions.isPartial()).collation(findOptions.getCollation()).comment(findOptions.getComment()).let(this.toBsonDocument(findOptions.getLet())).min(this.toBsonDocument(findOptions.getMin())).max(this.toBsonDocument(findOptions.getMax())).returnKey(findOptions.isReturnKey()).showRecordId(findOptions.isShowRecordId()).allowDiskUse(findOptions.isAllowDiskUse()).timeoutMode(findOptions.getTimeoutMode());
        if (findOptions.getHint() != null) {
            findOperation.hint(this.toBsonDocument(findOptions.getHint()));
        } else if (findOptions.getHintString() != null) {
            findOperation.hint(new BsonString(findOptions.getHintString()));
        }
        return findOperation;
    }

    <TResult> DistinctOperation<TResult> distinct(String string, @Nullable Bson bson, Class<TResult> clazz, Collation collation, BsonValue bsonValue, @Nullable Bson bson2, @Nullable String string2) {
        DistinctOperation<TResult> distinctOperation = new DistinctOperation<TResult>(Assertions.assertNotNull(this.namespace), string, this.codecRegistry.get(clazz)).retryReads(this.retryReads).filter(bson == null ? null : bson.toBsonDocument(this.documentClass, this.codecRegistry)).collation(collation).comment(bsonValue);
        if (bson2 != null) {
            distinctOperation.hint(this.toBsonDocument(bson2));
        } else if (string2 != null) {
            distinctOperation.hint(new BsonString(string2));
        }
        return distinctOperation;
    }

    <TResult> AggregateOperation<TResult> aggregate(List<? extends Bson> list, Class<TResult> clazz, @Nullable TimeoutMode timeoutMode, @Nullable Integer n, Collation collation, @Nullable Bson bson, @Nullable String string, BsonValue bsonValue, Bson bson2, Boolean bl, AggregationLevel aggregationLevel) {
        return new AggregateOperation<TResult>(Assertions.assertNotNull(this.namespace), Assertions.assertNotNull(this.toBsonDocumentList(list)), this.codecRegistry.get(clazz), aggregationLevel).retryReads(this.retryReads).allowDiskUse(bl).batchSize(n).collation(collation).hint(bson != null ? this.toBsonDocument(bson) : (string != null ? new BsonString(string) : null)).comment(bsonValue).let(this.toBsonDocument(bson2)).timeoutMode(timeoutMode);
    }

    AggregateToCollectionOperation aggregateToCollection(List<? extends Bson> list, @Nullable TimeoutMode timeoutMode, Boolean bl, Boolean bl2, Collation collation, @Nullable Bson bson, @Nullable String string, BsonValue bsonValue, Bson bson2, AggregationLevel aggregationLevel) {
        return new AggregateToCollectionOperation(Assertions.assertNotNull(this.namespace), Assertions.assertNotNull(this.toBsonDocumentList(list)), this.readConcern, this.writeConcern, aggregationLevel).allowDiskUse(bl).bypassDocumentValidation(bl2).collation(collation).hint(bson != null ? this.toBsonDocument(bson) : (string != null ? new BsonString(string) : null)).comment(bsonValue).let(this.toBsonDocument(bson2)).timeoutMode(timeoutMode);
    }

    MapReduceToCollectionOperation mapReduceToCollection(String string, String string2, String string3, String string4, @Nullable String string5, Bson bson, int n, boolean bl, Bson bson2, Bson bson3, boolean bl2, MapReduceAction mapReduceAction, Boolean bl3, Collation collation) {
        MapReduceToCollectionOperation mapReduceToCollectionOperation = new MapReduceToCollectionOperation(Assertions.assertNotNull(this.namespace), new BsonJavaScript(string3), new BsonJavaScript(string4), string2, this.writeConcern).filter(this.toBsonDocument(bson)).limit(n).jsMode(bl).scope(this.toBsonDocument(bson2)).sort(this.toBsonDocument(bson3)).verbose(bl2).action(mapReduceAction.getValue()).databaseName(string).bypassDocumentValidation(bl3).collation(collation);
        if (string5 != null) {
            mapReduceToCollectionOperation.finalizeFunction(new BsonJavaScript(string5));
        }
        return mapReduceToCollectionOperation;
    }

    <TResult> MapReduceWithInlineResultsOperation<TResult> mapReduce(String string, String string2, @Nullable String string3, Class<TResult> clazz, Bson bson, int n, boolean bl, Bson bson2, Bson bson3, boolean bl2, Collation collation) {
        MapReduceWithInlineResultsOperation<TResult> mapReduceWithInlineResultsOperation = new MapReduceWithInlineResultsOperation<TResult>(Assertions.assertNotNull(this.namespace), new BsonJavaScript(string), new BsonJavaScript(string2), this.codecRegistry.get(clazz)).filter(this.toBsonDocument(bson)).limit(n).jsMode(bl).scope(this.toBsonDocument(bson2)).sort(this.toBsonDocument(bson3)).verbose(bl2).collation(collation);
        if (string3 != null) {
            mapReduceWithInlineResultsOperation.finalizeFunction(new BsonJavaScript(string3));
        }
        return mapReduceWithInlineResultsOperation;
    }

    FindAndDeleteOperation<TDocument> findOneAndDelete(Bson bson, FindOneAndDeleteOptions findOneAndDeleteOptions) {
        return ((FindAndDeleteOperation)((FindAndDeleteOperation)((FindAndDeleteOperation)((FindAndDeleteOperation)((FindAndDeleteOperation)((FindAndDeleteOperation)((FindAndDeleteOperation)new FindAndDeleteOperation<TDocument>(Assertions.assertNotNull(this.namespace), this.writeConcern, this.retryWrites, this.getCodec()).filter(this.toBsonDocument(bson))).projection(this.toBsonDocument(findOneAndDeleteOptions.getProjection()))).sort(this.toBsonDocument(findOneAndDeleteOptions.getSort()))).collation(findOneAndDeleteOptions.getCollation())).hint(this.toBsonDocument(findOneAndDeleteOptions.getHint()))).hintString(findOneAndDeleteOptions.getHintString())).comment(findOneAndDeleteOptions.getComment())).let(this.toBsonDocument(findOneAndDeleteOptions.getLet()));
    }

    FindAndReplaceOperation<TDocument> findOneAndReplace(Bson bson, TDocument TDocument, FindOneAndReplaceOptions findOneAndReplaceOptions) {
        return ((FindAndReplaceOperation)((FindAndReplaceOperation)((FindAndReplaceOperation)((FindAndReplaceOperation)((FindAndReplaceOperation)((FindAndReplaceOperation)((FindAndReplaceOperation)new FindAndReplaceOperation<TDocument>(Assertions.assertNotNull(this.namespace), this.writeConcern, this.retryWrites, this.getCodec(), this.documentToBsonDocument(TDocument)).filter(this.toBsonDocument(bson))).projection(this.toBsonDocument(findOneAndReplaceOptions.getProjection()))).sort(this.toBsonDocument(findOneAndReplaceOptions.getSort()))).returnOriginal(findOneAndReplaceOptions.getReturnDocument() == ReturnDocument.BEFORE).upsert(findOneAndReplaceOptions.isUpsert()).bypassDocumentValidation(findOneAndReplaceOptions.getBypassDocumentValidation()).collation(findOneAndReplaceOptions.getCollation())).hint(this.toBsonDocument(findOneAndReplaceOptions.getHint()))).hintString(findOneAndReplaceOptions.getHintString())).comment(findOneAndReplaceOptions.getComment())).let(this.toBsonDocument(findOneAndReplaceOptions.getLet()));
    }

    FindAndUpdateOperation<TDocument> findOneAndUpdate(Bson bson, Bson bson2, FindOneAndUpdateOptions findOneAndUpdateOptions) {
        return ((FindAndUpdateOperation)((FindAndUpdateOperation)((FindAndUpdateOperation)((FindAndUpdateOperation)((FindAndUpdateOperation)((FindAndUpdateOperation)((FindAndUpdateOperation)new FindAndUpdateOperation<TDocument>(Assertions.assertNotNull(this.namespace), this.writeConcern, this.retryWrites, this.getCodec(), Assertions.assertNotNull(this.toBsonDocument(bson2))).filter(this.toBsonDocument(bson))).projection(this.toBsonDocument(findOneAndUpdateOptions.getProjection()))).sort(this.toBsonDocument(findOneAndUpdateOptions.getSort()))).returnOriginal(findOneAndUpdateOptions.getReturnDocument() == ReturnDocument.BEFORE).upsert(findOneAndUpdateOptions.isUpsert()).bypassDocumentValidation(findOneAndUpdateOptions.getBypassDocumentValidation()).collation(findOneAndUpdateOptions.getCollation())).arrayFilters(this.toBsonDocumentList(findOneAndUpdateOptions.getArrayFilters())).hint(this.toBsonDocument(findOneAndUpdateOptions.getHint()))).hintString(findOneAndUpdateOptions.getHintString())).comment(findOneAndUpdateOptions.getComment())).let(this.toBsonDocument(findOneAndUpdateOptions.getLet()));
    }

    FindAndUpdateOperation<TDocument> findOneAndUpdate(Bson bson, List<? extends Bson> list, FindOneAndUpdateOptions findOneAndUpdateOptions) {
        return ((FindAndUpdateOperation)((FindAndUpdateOperation)((FindAndUpdateOperation)((FindAndUpdateOperation)((FindAndUpdateOperation)((FindAndUpdateOperation)((FindAndUpdateOperation)new FindAndUpdateOperation<TDocument>(Assertions.assertNotNull(this.namespace), this.writeConcern, this.retryWrites, this.getCodec(), Assertions.assertNotNull(this.toBsonDocumentList(list))).filter(this.toBsonDocument(bson))).projection(this.toBsonDocument(findOneAndUpdateOptions.getProjection()))).sort(this.toBsonDocument(findOneAndUpdateOptions.getSort()))).returnOriginal(findOneAndUpdateOptions.getReturnDocument() == ReturnDocument.BEFORE).upsert(findOneAndUpdateOptions.isUpsert()).bypassDocumentValidation(findOneAndUpdateOptions.getBypassDocumentValidation()).collation(findOneAndUpdateOptions.getCollation())).arrayFilters(this.toBsonDocumentList(findOneAndUpdateOptions.getArrayFilters())).hint(this.toBsonDocument(findOneAndUpdateOptions.getHint()))).hintString(findOneAndUpdateOptions.getHintString())).comment(findOneAndUpdateOptions.getComment())).let(this.toBsonDocument(findOneAndUpdateOptions.getLet()));
    }

    MixedBulkWriteOperation insertOne(TDocument TDocument, InsertOneOptions insertOneOptions) {
        return this.bulkWrite(Collections.singletonList(new InsertOneModel<TDocument>(TDocument)), new BulkWriteOptions().bypassDocumentValidation(insertOneOptions.getBypassDocumentValidation()).comment(insertOneOptions.getComment()));
    }

    MixedBulkWriteOperation replaceOne(Bson bson, TDocument TDocument, ReplaceOptions replaceOptions) {
        return this.bulkWrite(Collections.singletonList(new ReplaceOneModel<TDocument>(bson, TDocument, replaceOptions)), new BulkWriteOptions().bypassDocumentValidation(replaceOptions.getBypassDocumentValidation()).comment(replaceOptions.getComment()).let(replaceOptions.getLet()));
    }

    MixedBulkWriteOperation deleteOne(Bson bson, DeleteOptions deleteOptions) {
        return this.bulkWrite(Collections.singletonList(new DeleteOneModel(bson, deleteOptions)), new BulkWriteOptions().comment(deleteOptions.getComment()).let(deleteOptions.getLet()));
    }

    MixedBulkWriteOperation deleteMany(Bson bson, DeleteOptions deleteOptions) {
        return this.bulkWrite(Collections.singletonList(new DeleteManyModel(bson, deleteOptions)), new BulkWriteOptions().comment(deleteOptions.getComment()).let(deleteOptions.getLet()));
    }

    MixedBulkWriteOperation updateOne(Bson bson, Bson bson2, UpdateOptions updateOptions) {
        return this.bulkWrite(Collections.singletonList(new UpdateOneModel(bson, bson2, updateOptions)), new BulkWriteOptions().bypassDocumentValidation(updateOptions.getBypassDocumentValidation()).comment(updateOptions.getComment()).let(updateOptions.getLet()));
    }

    MixedBulkWriteOperation updateOne(Bson bson, List<? extends Bson> list, UpdateOptions updateOptions) {
        return this.bulkWrite(Collections.singletonList(new UpdateOneModel(bson, list, updateOptions)), new BulkWriteOptions().bypassDocumentValidation(updateOptions.getBypassDocumentValidation()).comment(updateOptions.getComment()).let(updateOptions.getLet()));
    }

    MixedBulkWriteOperation updateMany(Bson bson, Bson bson2, UpdateOptions updateOptions) {
        return this.bulkWrite(Collections.singletonList(new UpdateManyModel(bson, bson2, updateOptions)), new BulkWriteOptions().bypassDocumentValidation(updateOptions.getBypassDocumentValidation()).comment(updateOptions.getComment()).let(updateOptions.getLet()));
    }

    MixedBulkWriteOperation updateMany(Bson bson, List<? extends Bson> list, UpdateOptions updateOptions) {
        return this.bulkWrite(Collections.singletonList(new UpdateManyModel(bson, list, updateOptions)), new BulkWriteOptions().bypassDocumentValidation(updateOptions.getBypassDocumentValidation()).comment(updateOptions.getComment()).let(updateOptions.getLet()));
    }

    MixedBulkWriteOperation insertMany(List<? extends TDocument> list, InsertManyOptions insertManyOptions) {
        Assertions.notNull("documents", list);
        ArrayList<InsertRequest> arrayList = new ArrayList<InsertRequest>(list.size());
        for (TDocument TDocument : list) {
            if (TDocument == null) {
                throw new IllegalArgumentException("documents can not contain a null value");
            }
            if (this.getCodec() instanceof CollectibleCodec) {
                TDocument = ((CollectibleCodec)this.getCodec()).generateIdIfAbsentFromDocument(TDocument);
            }
            arrayList.add(new InsertRequest(this.documentToBsonDocument(TDocument)));
        }
        return new MixedBulkWriteOperation(Assertions.assertNotNull(this.namespace), arrayList, insertManyOptions.isOrdered(), this.writeConcern, this.retryWrites).bypassDocumentValidation(insertManyOptions.getBypassDocumentValidation()).comment(insertManyOptions.getComment());
    }

    MixedBulkWriteOperation bulkWrite(List<? extends WriteModel<? extends TDocument>> list, BulkWriteOptions bulkWriteOptions) {
        Assertions.notNull("requests", list);
        ArrayList<InsertRequest> arrayList = new ArrayList<InsertRequest>(list.size());
        for (WriteModel<TDocument> writeModel : list) {
            BsonValue bsonValue;
            WriteRequest writeRequest;
            Object object;
            if (writeModel == null) {
                throw new IllegalArgumentException("requests can not contain a null value");
            }
            if (writeModel instanceof InsertOneModel) {
                object = ((InsertOneModel)writeModel).getDocument();
                if (this.getCodec() instanceof CollectibleCodec) {
                    object = ((CollectibleCodec)this.getCodec()).generateIdIfAbsentFromDocument(object);
                }
                writeRequest = new InsertRequest(this.documentToBsonDocument(object));
            } else if (writeModel instanceof ReplaceOneModel) {
                object = (ReplaceOneModel)writeModel;
                writeRequest = new UpdateRequest(Assertions.assertNotNull(this.toBsonDocument(((ReplaceOneModel)object).getFilter())), this.documentToBsonDocument(((ReplaceOneModel)object).getReplacement()), WriteRequest.Type.REPLACE).upsert(((ReplaceOneModel)object).getReplaceOptions().isUpsert()).collation(((ReplaceOneModel)object).getReplaceOptions().getCollation()).hint(this.toBsonDocument(((ReplaceOneModel)object).getReplaceOptions().getHint())).hintString(((ReplaceOneModel)object).getReplaceOptions().getHintString()).sort(this.toBsonDocument(((ReplaceOneModel)object).getReplaceOptions().getSort()));
            } else if (writeModel instanceof UpdateOneModel) {
                object = (UpdateOneModel)writeModel;
                bsonValue = ((UpdateOneModel)object).getUpdate() != null ? this.toBsonDocument(((UpdateOneModel)object).getUpdate()) : new BsonArray(this.toBsonDocumentList(((UpdateOneModel)object).getUpdatePipeline()));
                writeRequest = new UpdateRequest(Assertions.assertNotNull(this.toBsonDocument(((UpdateOneModel)object).getFilter())), bsonValue, WriteRequest.Type.UPDATE).multi(false).upsert(((UpdateOneModel)object).getOptions().isUpsert()).collation(((UpdateOneModel)object).getOptions().getCollation()).arrayFilters(this.toBsonDocumentList(((UpdateOneModel)object).getOptions().getArrayFilters())).hint(this.toBsonDocument(((UpdateOneModel)object).getOptions().getHint())).hintString(((UpdateOneModel)object).getOptions().getHintString()).sort(this.toBsonDocument(((UpdateOneModel)object).getOptions().getSort()));
            } else if (writeModel instanceof UpdateManyModel) {
                object = (UpdateManyModel)writeModel;
                bsonValue = ((UpdateManyModel)object).getUpdate() != null ? this.toBsonDocument(((UpdateManyModel)object).getUpdate()) : new BsonArray(this.toBsonDocumentList(((UpdateManyModel)object).getUpdatePipeline()));
                writeRequest = new UpdateRequest(Assertions.assertNotNull(this.toBsonDocument(((UpdateManyModel)object).getFilter())), bsonValue, WriteRequest.Type.UPDATE).multi(true).upsert(((UpdateManyModel)object).getOptions().isUpsert()).collation(((UpdateManyModel)object).getOptions().getCollation()).arrayFilters(this.toBsonDocumentList(((UpdateManyModel)object).getOptions().getArrayFilters())).hint(this.toBsonDocument(((UpdateManyModel)object).getOptions().getHint())).hintString(((UpdateManyModel)object).getOptions().getHintString());
            } else if (writeModel instanceof DeleteOneModel) {
                object = (DeleteOneModel)writeModel;
                writeRequest = new DeleteRequest(Assertions.assertNotNull(this.toBsonDocument(((DeleteOneModel)object).getFilter()))).multi(false).collation(((DeleteOneModel)object).getOptions().getCollation()).hint(this.toBsonDocument(((DeleteOneModel)object).getOptions().getHint())).hintString(((DeleteOneModel)object).getOptions().getHintString());
            } else if (writeModel instanceof DeleteManyModel) {
                object = (DeleteManyModel)writeModel;
                writeRequest = new DeleteRequest(Assertions.assertNotNull(this.toBsonDocument(((DeleteManyModel)object).getFilter()))).multi(true).collation(((DeleteManyModel)object).getOptions().getCollation()).hint(this.toBsonDocument(((DeleteManyModel)object).getOptions().getHint())).hintString(((DeleteManyModel)object).getOptions().getHintString());
            } else {
                throw new UnsupportedOperationException(String.format("WriteModel of type %s is not supported", writeModel.getClass()));
            }
            arrayList.add((InsertRequest)writeRequest);
        }
        return new MixedBulkWriteOperation(Assertions.assertNotNull(this.namespace), arrayList, bulkWriteOptions.isOrdered(), this.writeConcern, this.retryWrites).bypassDocumentValidation(bulkWriteOptions.getBypassDocumentValidation()).comment(bulkWriteOptions.getComment()).let(this.toBsonDocument(bulkWriteOptions.getLet()));
    }

    <TResult> CommandReadOperation<TResult> commandRead(Bson bson, Class<TResult> clazz) {
        Assertions.notNull("command", bson);
        Assertions.notNull("resultClass", clazz);
        return new CommandReadOperation<TResult>(Assertions.assertNotNull(this.namespace).getDatabaseName(), Assertions.assertNotNull(this.toBsonDocument(bson)), this.codecRegistry.get(clazz));
    }

    DropDatabaseOperation dropDatabase() {
        return new DropDatabaseOperation(Assertions.assertNotNull(this.namespace).getDatabaseName(), this.getWriteConcern());
    }

    CreateCollectionOperation createCollection(String string, CreateCollectionOptions createCollectionOptions, @Nullable AutoEncryptionSettings autoEncryptionSettings) {
        Bson bson;
        Object object;
        CreateCollectionOperation createCollectionOperation = new CreateCollectionOperation(Assertions.assertNotNull(this.namespace).getDatabaseName(), string, this.writeConcern).collation(createCollectionOptions.getCollation()).capped(createCollectionOptions.isCapped()).sizeInBytes(createCollectionOptions.getSizeInBytes()).maxDocuments(createCollectionOptions.getMaxDocuments()).storageEngineOptions(this.toBsonDocument(createCollectionOptions.getStorageEngineOptions())).expireAfter(createCollectionOptions.getExpireAfter(TimeUnit.SECONDS)).timeSeriesOptions(createCollectionOptions.getTimeSeriesOptions()).changeStreamPreAndPostImagesOptions(createCollectionOptions.getChangeStreamPreAndPostImagesOptions());
        ClusteredIndexOptions clusteredIndexOptions = createCollectionOptions.getClusteredIndexOptions();
        if (clusteredIndexOptions != null) {
            createCollectionOperation.clusteredIndexKey(this.toBsonDocument(clusteredIndexOptions.getKey()));
            createCollectionOperation.clusteredIndexUnique(clusteredIndexOptions.isUnique());
            createCollectionOperation.clusteredIndexName(clusteredIndexOptions.getName());
        }
        Bson bson2 = createCollectionOptions.getEncryptedFields();
        createCollectionOperation.encryptedFields(this.toBsonDocument(bson2));
        if (bson2 == null && autoEncryptionSettings != null && (object = autoEncryptionSettings.getEncryptedFieldsMap()) != null) {
            createCollectionOperation.encryptedFields(object.getOrDefault(this.namespace.getDatabaseName() + "." + string, null));
        }
        if ((bson = ((IndexOptionDefaults)(object = createCollectionOptions.getIndexOptionDefaults())).getStorageEngine()) != null) {
            createCollectionOperation.indexOptionDefaults(new BsonDocument("storageEngine", this.toBsonDocument(bson)));
        }
        ValidationOptions validationOptions = createCollectionOptions.getValidationOptions();
        Bson bson3 = validationOptions.getValidator();
        createCollectionOperation.validator(this.toBsonDocument(bson3));
        createCollectionOperation.validationLevel(validationOptions.getValidationLevel());
        createCollectionOperation.validationAction(validationOptions.getValidationAction());
        return createCollectionOperation;
    }

    DropCollectionOperation dropCollection(DropCollectionOptions dropCollectionOptions, @Nullable AutoEncryptionSettings autoEncryptionSettings) {
        Map<String, BsonDocument> map;
        DropCollectionOperation dropCollectionOperation = new DropCollectionOperation(Assertions.assertNotNull(this.namespace), this.writeConcern);
        Bson bson = dropCollectionOptions.getEncryptedFields();
        if (bson != null) {
            dropCollectionOperation.encryptedFields(Assertions.assertNotNull(this.toBsonDocument(bson)));
        } else if (autoEncryptionSettings != null && (map = autoEncryptionSettings.getEncryptedFieldsMap()) != null) {
            dropCollectionOperation.encryptedFields(map.getOrDefault(this.namespace.getFullName(), null));
            dropCollectionOperation.autoEncryptedFields(true);
        }
        return dropCollectionOperation;
    }

    RenameCollectionOperation renameCollection(MongoNamespace mongoNamespace, RenameCollectionOptions renameCollectionOptions) {
        return new RenameCollectionOperation(Assertions.assertNotNull(this.namespace), mongoNamespace, this.writeConcern).dropTarget(renameCollectionOptions.isDropTarget());
    }

    CreateViewOperation createView(String string, String string2, List<? extends Bson> list, CreateViewOptions createViewOptions) {
        Assertions.notNull("options", createViewOptions);
        Assertions.notNull("pipeline", list);
        return new CreateViewOperation(Assertions.assertNotNull(this.namespace).getDatabaseName(), string, string2, Assertions.assertNotNull(this.toBsonDocumentList(list)), this.writeConcern).collation(createViewOptions.getCollation());
    }

    CreateIndexesOperation createIndexes(List<IndexModel> list, CreateIndexOptions createIndexOptions) {
        Assertions.notNull("indexes", list);
        Assertions.notNull("createIndexOptions", createIndexOptions);
        ArrayList<IndexRequest> arrayList = new ArrayList<IndexRequest>(list.size());
        for (IndexModel indexModel : list) {
            if (indexModel == null) {
                throw new IllegalArgumentException("indexes can not contain a null value");
            }
            arrayList.add(new IndexRequest(Assertions.assertNotNull(this.toBsonDocument(indexModel.getKeys()))).name(indexModel.getOptions().getName()).background(indexModel.getOptions().isBackground()).unique(indexModel.getOptions().isUnique()).sparse(indexModel.getOptions().isSparse()).expireAfter(indexModel.getOptions().getExpireAfter(TimeUnit.SECONDS), TimeUnit.SECONDS).version(indexModel.getOptions().getVersion()).weights(this.toBsonDocument(indexModel.getOptions().getWeights())).defaultLanguage(indexModel.getOptions().getDefaultLanguage()).languageOverride(indexModel.getOptions().getLanguageOverride()).textVersion(indexModel.getOptions().getTextVersion()).sphereVersion(indexModel.getOptions().getSphereVersion()).bits(indexModel.getOptions().getBits()).min(indexModel.getOptions().getMin()).max(indexModel.getOptions().getMax()).storageEngine(this.toBsonDocument(indexModel.getOptions().getStorageEngine())).partialFilterExpression(this.toBsonDocument(indexModel.getOptions().getPartialFilterExpression())).collation(indexModel.getOptions().getCollation()).wildcardProjection(this.toBsonDocument(indexModel.getOptions().getWildcardProjection())).hidden(indexModel.getOptions().isHidden()));
        }
        return new CreateIndexesOperation(Assertions.assertNotNull(this.namespace), arrayList, this.writeConcern).commitQuorum(createIndexOptions.getCommitQuorum());
    }

    CreateSearchIndexesOperation createSearchIndexes(List<SearchIndexModel> list) {
        List<SearchIndexRequest> list2 = list.stream().map(this::createSearchIndexRequest).collect(Collectors.toList());
        return new CreateSearchIndexesOperation(Assertions.assertNotNull(this.namespace), list2);
    }

    UpdateSearchIndexesOperation updateSearchIndex(String string, Bson bson) {
        BsonDocument bsonDocument = Assertions.assertNotNull(this.toBsonDocument(bson));
        SearchIndexRequest searchIndexRequest = new SearchIndexRequest(bsonDocument, string);
        return new UpdateSearchIndexesOperation(Assertions.assertNotNull(this.namespace), searchIndexRequest);
    }

    DropSearchIndexOperation dropSearchIndex(String string) {
        return new DropSearchIndexOperation(Assertions.assertNotNull(this.namespace), string);
    }

    <TResult> ListSearchIndexesOperation<TResult> listSearchIndexes(Class<TResult> clazz, @Nullable String string, @Nullable Integer n, @Nullable Collation collation, @Nullable BsonValue bsonValue, @Nullable Boolean bl) {
        return new ListSearchIndexesOperation<TResult>(Assertions.assertNotNull(this.namespace), this.codecRegistry.get(clazz), string, n, collation, bsonValue, bl, this.retryReads);
    }

    DropIndexOperation dropIndex(String string, DropIndexOptions dropIndexOptions) {
        return new DropIndexOperation(Assertions.assertNotNull(this.namespace), string, this.writeConcern);
    }

    DropIndexOperation dropIndex(Bson bson, DropIndexOptions dropIndexOptions) {
        return new DropIndexOperation(Assertions.assertNotNull(this.namespace), bson.toBsonDocument(BsonDocument.class, this.codecRegistry), this.writeConcern);
    }

    <TResult> ListCollectionsOperation<TResult> listCollections(String string, Class<TResult> clazz, Bson bson, boolean bl, boolean bl2, @Nullable Integer n, BsonValue bsonValue, @Nullable TimeoutMode timeoutMode) {
        return new ListCollectionsOperation<TResult>(string, this.codecRegistry.get(clazz)).retryReads(this.retryReads).filter(this.toBsonDocument(bson)).nameOnly(bl).authorizedCollections(bl2).batchSize(n == null ? 0 : n).comment(bsonValue).timeoutMode(timeoutMode);
    }

    <TResult> ListDatabasesOperation<TResult> listDatabases(Class<TResult> clazz, Bson bson, Boolean bl, Boolean bl2, BsonValue bsonValue) {
        return new ListDatabasesOperation<TResult>(this.codecRegistry.get(clazz)).retryReads(this.retryReads).filter(this.toBsonDocument(bson)).nameOnly(bl).authorizedDatabasesOnly(bl2).comment(bsonValue);
    }

    <TResult> ListIndexesOperation<TResult> listIndexes(Class<TResult> clazz, @Nullable Integer n, BsonValue bsonValue, @Nullable TimeoutMode timeoutMode) {
        return new ListIndexesOperation<TResult>(Assertions.assertNotNull(this.namespace), this.codecRegistry.get(clazz)).retryReads(this.retryReads).batchSize(n == null ? 0 : n).comment(bsonValue).timeoutMode(timeoutMode);
    }

    <TResult> ChangeStreamOperation<TResult> changeStream(FullDocument fullDocument, FullDocumentBeforeChange fullDocumentBeforeChange, List<? extends Bson> list, Decoder<TResult> decoder, ChangeStreamLevel changeStreamLevel, @Nullable Integer n, Collation collation, BsonValue bsonValue, BsonDocument bsonDocument, BsonTimestamp bsonTimestamp, BsonDocument bsonDocument2, boolean bl) {
        return new ChangeStreamOperation<TResult>(Assertions.assertNotNull(this.namespace), fullDocument, fullDocumentBeforeChange, Assertions.assertNotNull(this.toBsonDocumentList(list)), decoder, changeStreamLevel).batchSize(n).collation(collation).comment(bsonValue).resumeAfter(bsonDocument).startAtOperationTime(bsonTimestamp).startAfter(bsonDocument2).showExpandedEvents(bl).retryReads(this.retryReads);
    }

    ClientBulkWriteOperation clientBulkWriteOperation(List<? extends ClientNamespacedWriteModel> list, @Nullable ClientBulkWriteOptions clientBulkWriteOptions) {
        return new ClientBulkWriteOperation(list, clientBulkWriteOptions, this.writeConcern, this.retryWrites, this.codecRegistry);
    }

    private Codec<TDocument> getCodec() {
        return this.codecRegistry.get(this.documentClass);
    }

    private BsonDocument documentToBsonDocument(TDocument TDocument) {
        if (TDocument instanceof BsonDocument) {
            return (BsonDocument)TDocument;
        }
        return new BsonDocumentWrapper<TDocument>(TDocument, this.getCodec());
    }

    @Nullable
    private BsonDocument toBsonDocument(@Nullable Bson bson) {
        return bson == null ? null : bson.toBsonDocument(this.documentClass, this.codecRegistry);
    }

    @Nullable
    private List<BsonDocument> toBsonDocumentList(@Nullable List<? extends Bson> list) {
        if (list == null) {
            return null;
        }
        ArrayList<BsonDocument> arrayList = new ArrayList<BsonDocument>(list.size());
        for (Bson bson : list) {
            if (bson == null) {
                throw new IllegalArgumentException("All documents in the list must be non-null");
            }
            arrayList.add(this.toBsonDocument(bson));
        }
        return arrayList;
    }

    private SearchIndexRequest createSearchIndexRequest(SearchIndexModel searchIndexModel) {
        BsonDocument bsonDocument = Assertions.assertNotNull(this.toBsonDocument(searchIndexModel.getDefinition()));
        String string = searchIndexModel.getName();
        SearchIndexType searchIndexType = searchIndexModel.getType();
        return new SearchIndexRequest(bsonDocument, string, searchIndexType);
    }
}

