/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.operation;

import com.mongodb.MongoNamespace;
import com.mongodb.WriteConcern;
import com.mongodb.assertions.Assertions;
import com.mongodb.internal.async.ErrorHandlingResultCallback;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.binding.AsyncWriteBinding;
import com.mongodb.internal.binding.WriteBinding;
import com.mongodb.internal.operation.AsyncOperationHelper;
import com.mongodb.internal.operation.AsyncWriteOperation;
import com.mongodb.internal.operation.OperationHelper;
import com.mongodb.internal.operation.SyncOperationHelper;
import com.mongodb.internal.operation.WriteConcernHelper;
import com.mongodb.internal.operation.WriteOperation;
import com.mongodb.lang.Nullable;
import org.bson.BsonBoolean;
import org.bson.BsonDocument;
import org.bson.BsonString;

public class RenameCollectionOperation
implements AsyncWriteOperation<Void>,
WriteOperation<Void> {
    private final MongoNamespace originalNamespace;
    private final MongoNamespace newNamespace;
    private final WriteConcern writeConcern;
    private boolean dropTarget;

    public RenameCollectionOperation(MongoNamespace mongoNamespace, MongoNamespace mongoNamespace2, @Nullable WriteConcern writeConcern) {
        this.originalNamespace = Assertions.notNull("originalNamespace", mongoNamespace);
        this.newNamespace = Assertions.notNull("newNamespace", mongoNamespace2);
        this.writeConcern = writeConcern;
    }

    public WriteConcern getWriteConcern() {
        return this.writeConcern;
    }

    public boolean isDropTarget() {
        return this.dropTarget;
    }

    public RenameCollectionOperation dropTarget(boolean bl) {
        this.dropTarget = bl;
        return this;
    }

    @Override
    public Void execute(WriteBinding writeBinding) {
        return SyncOperationHelper.withConnection(writeBinding, connection -> SyncOperationHelper.executeCommand(writeBinding, "admin", this.getCommand(), connection, SyncOperationHelper.writeConcernErrorTransformer(writeBinding.getOperationContext().getTimeoutContext())));
    }

    @Override
    public void executeAsync(AsyncWriteBinding asyncWriteBinding, SingleResultCallback<Void> singleResultCallback) {
        AsyncOperationHelper.withAsyncConnection(asyncWriteBinding, (asyncConnection, throwable) -> {
            SingleResultCallback<Object> singleResultCallback2 = ErrorHandlingResultCallback.errorHandlingCallback(singleResultCallback, OperationHelper.LOGGER);
            if (throwable != null) {
                singleResultCallback2.onResult(null, throwable);
            } else {
                AsyncOperationHelper.executeCommandAsync(asyncWriteBinding, "admin", this.getCommand(), Assertions.assertNotNull(asyncConnection), AsyncOperationHelper.writeConcernErrorTransformerAsync(asyncWriteBinding.getOperationContext().getTimeoutContext()), AsyncOperationHelper.releasingCallback(singleResultCallback2, asyncConnection));
            }
        });
    }

    private BsonDocument getCommand() {
        BsonDocument bsonDocument = new BsonDocument("renameCollection", new BsonString(this.originalNamespace.getFullName())).append("to", new BsonString(this.newNamespace.getFullName())).append("dropTarget", BsonBoolean.valueOf(this.dropTarget));
        WriteConcernHelper.appendWriteConcernToCommand(this.writeConcern, bsonDocument);
        return bsonDocument;
    }
}

