/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.operation;

import com.mongodb.Function;
import com.mongodb.MongoException;
import com.mongodb.ReadPreference;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.cursor.TimeoutMode;
import com.mongodb.internal.TimeoutContext;
import com.mongodb.internal.async.function.RetryState;
import com.mongodb.internal.async.function.RetryingSyncSupplier;
import com.mongodb.internal.binding.ConnectionSource;
import com.mongodb.internal.binding.ReadBinding;
import com.mongodb.internal.binding.ReferenceCounted;
import com.mongodb.internal.binding.WriteBinding;
import com.mongodb.internal.connection.Connection;
import com.mongodb.internal.connection.OperationContext;
import com.mongodb.internal.operation.BatchCursor;
import com.mongodb.internal.operation.BsonDocumentWrapperHelper;
import com.mongodb.internal.operation.CommandBatchCursor;
import com.mongodb.internal.operation.CommandOperationHelper;
import com.mongodb.internal.operation.OperationHelper;
import com.mongodb.internal.operation.SingleBatchCursor;
import com.mongodb.internal.operation.WriteConcernHelper;
import com.mongodb.internal.operation.retry.AttachmentKeys;
import com.mongodb.internal.session.SessionContext;
import com.mongodb.internal.validator.NoOpFieldNameValidator;
import com.mongodb.lang.Nullable;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.bson.BsonDocument;
import org.bson.BsonValue;
import org.bson.FieldNameValidator;
import org.bson.codecs.BsonDocumentCodec;
import org.bson.codecs.Decoder;

final class SyncOperationHelper {
    private static final BsonDocumentCodec BSON_DOCUMENT_CODEC = new BsonDocumentCodec();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <T> T withReadConnectionSource(ReadBinding readBinding, CallableWithSource<T> callableWithSource) {
        ConnectionSource connectionSource = readBinding.getReadConnectionSource();
        try {
            T t = callableWithSource.call(connectionSource);
            return t;
        }
        finally {
            connectionSource.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <T> T withConnection(WriteBinding writeBinding, CallableWithConnection<T> callableWithConnection) {
        ConnectionSource connectionSource = writeBinding.getWriteConnectionSource();
        try {
            T t = SyncOperationHelper.withConnectionSource(connectionSource, callableWithConnection);
            return t;
        }
        finally {
            connectionSource.release();
        }
    }

    static <R> R withSourceAndConnection(Supplier<ConnectionSource> supplier, boolean bl, BiFunction<ConnectionSource, Connection, R> biFunction) throws OperationHelper.ResourceSupplierInternalException {
        return (R)SyncOperationHelper.withSuppliedResource(supplier, bl, connectionSource -> SyncOperationHelper.withSuppliedResource(connectionSource::getConnection, bl, connection -> biFunction.apply((ConnectionSource)connectionSource, (Connection)connection)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <R, T extends ReferenceCounted> R withSuppliedResource(Supplier<T> supplier, boolean bl, java.util.function.Function<T, R> function) throws OperationHelper.ResourceSupplierInternalException {
        ReferenceCounted referenceCounted = null;
        try {
            try {
                referenceCounted = (ReferenceCounted)supplier.get();
            }
            catch (Exception exception) {
                if (bl) {
                    throw new OperationHelper.ResourceSupplierInternalException(exception);
                }
                throw exception;
            }
            R r = function.apply(referenceCounted);
            return r;
        }
        finally {
            if (referenceCounted != null) {
                referenceCounted.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T withConnectionSource(ConnectionSource connectionSource, CallableWithConnection<T> callableWithConnection) {
        Connection connection = connectionSource.getConnection();
        try {
            T t = callableWithConnection.call(connection);
            return t;
        }
        finally {
            connection.release();
        }
    }

    static <D, T> T executeRetryableRead(ReadBinding readBinding, String string, CommandOperationHelper.CommandCreator commandCreator, Decoder<D> decoder, CommandReadTransformer<D, T> commandReadTransformer, boolean bl) {
        return SyncOperationHelper.executeRetryableRead(readBinding, readBinding::getReadConnectionSource, string, commandCreator, decoder, commandReadTransformer, bl);
    }

    static <D, T> T executeRetryableRead(ReadBinding readBinding, Supplier<ConnectionSource> supplier, String string, CommandOperationHelper.CommandCreator commandCreator, Decoder<D> decoder, CommandReadTransformer<D, T> commandReadTransformer, boolean bl) {
        RetryState retryState = CommandOperationHelper.initialRetryState(bl, readBinding.getOperationContext().getTimeoutContext());
        Supplier<Object> supplier2 = SyncOperationHelper.decorateReadWithRetries(retryState, readBinding.getOperationContext(), () -> SyncOperationHelper.withSourceAndConnection(supplier, false, (connectionSource, connection) -> {
            retryState.breakAndThrowIfRetryAnd(() -> !OperationHelper.canRetryRead(connectionSource.getServerDescription(), readBinding.getOperationContext()));
            return SyncOperationHelper.createReadCommandAndExecute(retryState, readBinding.getOperationContext(), connectionSource, string, commandCreator, decoder, commandReadTransformer, connection);
        }));
        return (T)supplier2.get();
    }

    static <T> T executeCommand(WriteBinding writeBinding, String string, CommandOperationHelper.CommandCreator commandCreator, CommandWriteTransformer<BsonDocument, T> commandWriteTransformer) {
        return (T)SyncOperationHelper.withSourceAndConnection(writeBinding::getWriteConnectionSource, false, (connectionSource, connection) -> commandWriteTransformer.apply(Assertions.assertNotNull(connection.command(string, commandCreator.create(writeBinding.getOperationContext(), connectionSource.getServerDescription(), connection.getDescription()), NoOpFieldNameValidator.INSTANCE, ReadPreference.primary(), BSON_DOCUMENT_CODEC, writeBinding.getOperationContext())), (Connection)connection));
    }

    static <D, T> T executeCommand(WriteBinding writeBinding, String string, BsonDocument bsonDocument, Decoder<D> decoder, CommandWriteTransformer<D, T> commandWriteTransformer) {
        return (T)SyncOperationHelper.withSourceAndConnection(writeBinding::getWriteConnectionSource, false, (connectionSource, connection) -> commandWriteTransformer.apply((Object)Assertions.assertNotNull(connection.command(string, bsonDocument, NoOpFieldNameValidator.INSTANCE, ReadPreference.primary(), decoder, writeBinding.getOperationContext())), (Connection)connection));
    }

    @Nullable
    static <T> T executeCommand(WriteBinding writeBinding, String string, BsonDocument bsonDocument, Connection connection, CommandWriteTransformer<BsonDocument, T> commandWriteTransformer) {
        Assertions.notNull("binding", writeBinding);
        return commandWriteTransformer.apply(Assertions.assertNotNull(connection.command(string, bsonDocument, NoOpFieldNameValidator.INSTANCE, ReadPreference.primary(), BSON_DOCUMENT_CODEC, writeBinding.getOperationContext())), connection);
    }

    static <T, R> R executeRetryableWrite(WriteBinding writeBinding, String string, @Nullable ReadPreference readPreference, FieldNameValidator fieldNameValidator, Decoder<T> decoder, CommandOperationHelper.CommandCreator commandCreator, CommandWriteTransformer<T, R> commandWriteTransformer, Function<BsonDocument, BsonDocument> function) {
        RetryState retryState = CommandOperationHelper.initialRetryState(true, writeBinding.getOperationContext().getTimeoutContext());
        Supplier<Object> supplier = SyncOperationHelper.decorateWriteWithRetries(retryState, writeBinding.getOperationContext(), () -> {
            boolean bl = retryState.isFirstAttempt();
            SessionContext sessionContext = writeBinding.getOperationContext().getSessionContext();
            if (!bl && sessionContext.hasActiveTransaction()) {
                sessionContext.clearTransactionContext();
            }
            return SyncOperationHelper.withSourceAndConnection(writeBinding::getWriteConnectionSource, true, (connectionSource, connection) -> {
                int n = connection.getDescription().getMaxWireVersion();
                try {
                    retryState.breakAndThrowIfRetryAnd(() -> !OperationHelper.canRetryWrite(connection.getDescription(), sessionContext));
                    BsonDocument bsonDocument2 = retryState.attachment(AttachmentKeys.command()).map(bsonDocument -> {
                        Assertions.assertFalse(bl);
                        return (BsonDocument)function.apply((BsonDocument)bsonDocument);
                    }).orElseGet(() -> commandCreator.create(writeBinding.getOperationContext(), connectionSource.getServerDescription(), connection.getDescription()));
                    retryState.attach(AttachmentKeys.maxWireVersion(), n, true).attach(AttachmentKeys.retryableCommandFlag(), CommandOperationHelper.isRetryWritesEnabled(bsonDocument2), true).attach(AttachmentKeys.commandDescriptionSupplier(), bsonDocument2::getFirstKey, false).attach(AttachmentKeys.command(), bsonDocument2, false);
                    return commandWriteTransformer.apply(Assertions.assertNotNull(connection.command(string, bsonDocument2, fieldNameValidator, readPreference, decoder, writeBinding.getOperationContext())), (Connection)connection);
                }
                catch (MongoException mongoException) {
                    if (!bl) {
                        CommandOperationHelper.addRetryableWriteErrorLabel(mongoException, n);
                    }
                    throw mongoException;
                }
            });
        });
        try {
            return (R)supplier.get();
        }
        catch (MongoException mongoException) {
            throw CommandOperationHelper.transformWriteException(mongoException);
        }
    }

    @Nullable
    static <D, T> T createReadCommandAndExecute(RetryState retryState, OperationContext operationContext, ConnectionSource connectionSource, String string, CommandOperationHelper.CommandCreator commandCreator, Decoder<D> decoder, CommandReadTransformer<D, T> commandReadTransformer, Connection connection) {
        BsonDocument bsonDocument = commandCreator.create(operationContext, connectionSource.getServerDescription(), connection.getDescription());
        retryState.attach(AttachmentKeys.commandDescriptionSupplier(), bsonDocument::getFirstKey, false);
        return commandReadTransformer.apply(Assertions.assertNotNull(connection.command(string, bsonDocument, NoOpFieldNameValidator.INSTANCE, connectionSource.getReadPreference(), decoder, operationContext)), connectionSource, connection);
    }

    static <R> Supplier<R> decorateWriteWithRetries(RetryState retryState, OperationContext operationContext, Supplier<R> supplier) {
        return new RetryingSyncSupplier<Object>(retryState, CommandOperationHelper.onRetryableWriteAttemptFailure(operationContext), CommandOperationHelper::loggingShouldAttemptToRetryWriteAndAddRetryableLabel, () -> {
            CommandOperationHelper.logRetryExecute(retryState, operationContext);
            return supplier.get();
        });
    }

    static <R> Supplier<R> decorateReadWithRetries(RetryState retryState, OperationContext operationContext, Supplier<R> supplier) {
        return new RetryingSyncSupplier<Object>(retryState, CommandOperationHelper.onRetryableReadAttemptFailure(operationContext), CommandOperationHelper::shouldAttemptToRetryRead, () -> {
            CommandOperationHelper.logRetryExecute(retryState, operationContext);
            return supplier.get();
        });
    }

    static CommandWriteTransformer<BsonDocument, Void> writeConcernErrorTransformer(TimeoutContext timeoutContext) {
        return (bsonDocument, connection) -> {
            Assertions.assertNotNull(bsonDocument);
            WriteConcernHelper.throwOnWriteConcernError(bsonDocument, connection.getDescription().getServerAddress(), connection.getDescription().getMaxWireVersion(), timeoutContext);
            return null;
        };
    }

    static <T> CommandReadTransformer<BsonDocument, BatchCursor<T>> singleBatchCursorTransformer(String string) {
        return (bsonDocument, connectionSource, connection) -> new SingleBatchCursor(BsonDocumentWrapperHelper.toList(bsonDocument, string), 0, connection.getDescription().getServerAddress());
    }

    static <T> CommandBatchCursor<T> cursorDocumentToBatchCursor(TimeoutMode timeoutMode, BsonDocument bsonDocument, int n, Decoder<T> decoder, @Nullable BsonValue bsonValue, ConnectionSource connectionSource, Connection connection) {
        return new CommandBatchCursor<T>(timeoutMode, bsonDocument, n, 0L, decoder, bsonValue, connectionSource, connection);
    }

    private SyncOperationHelper() {
    }

    static interface CallableWithSource<T> {
        public T call(ConnectionSource var1);
    }

    static interface CallableWithConnection<T> {
        public T call(Connection var1);
    }

    static interface CommandReadTransformer<T, R> {
        @Nullable
        public R apply(T var1, ConnectionSource var2, Connection var3);
    }

    static interface CommandWriteTransformer<T, R> {
        @Nullable
        public R apply(T var1, Connection var2);
    }
}

