/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.operation;

import com.mongodb.Function;
import com.mongodb.WriteConcern;
import com.mongodb.assertions.Assertions;
import com.mongodb.internal.TimeoutContext;
import com.mongodb.internal.async.ErrorHandlingResultCallback;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.binding.AsyncWriteBinding;
import com.mongodb.internal.binding.WriteBinding;
import com.mongodb.internal.operation.AsyncOperationHelper;
import com.mongodb.internal.operation.AsyncWriteOperation;
import com.mongodb.internal.operation.CommandOperationHelper;
import com.mongodb.internal.operation.OperationHelper;
import com.mongodb.internal.operation.SyncOperationHelper;
import com.mongodb.internal.operation.WriteOperation;
import com.mongodb.internal.validator.NoOpFieldNameValidator;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.codecs.BsonDocumentCodec;

public abstract class TransactionOperation
implements WriteOperation<Void>,
AsyncWriteOperation<Void> {
    private final WriteConcern writeConcern;

    TransactionOperation(WriteConcern writeConcern) {
        this.writeConcern = Assertions.notNull("writeConcern", writeConcern);
    }

    public WriteConcern getWriteConcern() {
        return this.writeConcern;
    }

    @Override
    public Void execute(WriteBinding writeBinding) {
        Assertions.isTrue("in transaction", writeBinding.getOperationContext().getSessionContext().hasActiveTransaction());
        TimeoutContext timeoutContext = writeBinding.getOperationContext().getTimeoutContext();
        return SyncOperationHelper.executeRetryableWrite(writeBinding, "admin", null, NoOpFieldNameValidator.INSTANCE, new BsonDocumentCodec(), this.getCommandCreator(), SyncOperationHelper.writeConcernErrorTransformer(timeoutContext), this.getRetryCommandModifier(timeoutContext));
    }

    @Override
    public void executeAsync(AsyncWriteBinding asyncWriteBinding, SingleResultCallback<Void> singleResultCallback) {
        Assertions.isTrue("in transaction", asyncWriteBinding.getOperationContext().getSessionContext().hasActiveTransaction());
        TimeoutContext timeoutContext = asyncWriteBinding.getOperationContext().getTimeoutContext();
        AsyncOperationHelper.executeRetryableWriteAsync(asyncWriteBinding, "admin", null, NoOpFieldNameValidator.INSTANCE, new BsonDocumentCodec(), this.getCommandCreator(), AsyncOperationHelper.writeConcernErrorTransformerAsync(timeoutContext), this.getRetryCommandModifier(timeoutContext), ErrorHandlingResultCallback.errorHandlingCallback(singleResultCallback, OperationHelper.LOGGER));
    }

    CommandOperationHelper.CommandCreator getCommandCreator() {
        return (operationContext, serverDescription, connectionDescription) -> {
            BsonDocument bsonDocument = new BsonDocument(this.getCommandName(), new BsonInt32(1));
            if (!this.writeConcern.isServerDefault()) {
                bsonDocument.put("writeConcern", this.writeConcern.asDocument());
            }
            return bsonDocument;
        };
    }

    protected abstract String getCommandName();

    protected abstract Function<BsonDocument, BsonDocument> getRetryCommandModifier(TimeoutContext var1);
}

