/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.operation;

import com.mongodb.MongoException;
import com.mongodb.MongoWriteConcernException;
import com.mongodb.ServerAddress;
import com.mongodb.WriteConcern;
import com.mongodb.WriteConcernResult;
import com.mongodb.bulk.WriteConcernError;
import com.mongodb.internal.TimeoutContext;
import com.mongodb.internal.connection.ProtocolHelper;
import com.mongodb.internal.operation.CommandOperationHelper;
import com.mongodb.lang.Nullable;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.bson.BsonArray;
import org.bson.BsonDocument;
import org.bson.BsonString;

public final class WriteConcernHelper {
    public static void appendWriteConcernToCommand(WriteConcern writeConcern, BsonDocument bsonDocument) {
        if (writeConcern != null && !writeConcern.isServerDefault()) {
            bsonDocument.put("writeConcern", writeConcern.asDocument());
        }
    }

    @Nullable
    public static WriteConcern cloneWithoutTimeout(@Nullable WriteConcern writeConcern) {
        if (writeConcern == null || writeConcern.getWTimeout(TimeUnit.MILLISECONDS) == null) {
            return writeConcern;
        }
        Object object = writeConcern.getWObject();
        WriteConcern writeConcern2 = object == null ? WriteConcern.ACKNOWLEDGED : (object instanceof Integer ? new WriteConcern((Integer)object) : new WriteConcern((String)object));
        return writeConcern2.withJournal(writeConcern.getJournal());
    }

    public static void throwOnWriteConcernError(BsonDocument bsonDocument, ServerAddress serverAddress, int n, TimeoutContext timeoutContext) {
        if (WriteConcernHelper.hasWriteConcernError(bsonDocument)) {
            MongoException mongoException = ProtocolHelper.createSpecialException(bsonDocument, serverAddress, "errmsg", timeoutContext);
            if (mongoException == null) {
                mongoException = WriteConcernHelper.createWriteConcernException(bsonDocument, serverAddress);
            }
            CommandOperationHelper.addRetryableWriteErrorLabel(mongoException, n);
            throw mongoException;
        }
    }

    public static boolean hasWriteConcernError(BsonDocument bsonDocument) {
        return bsonDocument.containsKey("writeConcernError");
    }

    public static MongoWriteConcernException createWriteConcernException(BsonDocument bsonDocument, ServerAddress serverAddress) {
        return new MongoWriteConcernException(WriteConcernHelper.createWriteConcernError(bsonDocument.getDocument("writeConcernError")), WriteConcernResult.acknowledged(0, false, null), serverAddress, bsonDocument.getArray("errorLabels", new BsonArray()).stream().map(bsonValue -> bsonValue.asString().getValue()).collect(Collectors.toSet()));
    }

    public static WriteConcernError createWriteConcernError(BsonDocument bsonDocument) {
        return new WriteConcernError(bsonDocument.getNumber("code").intValue(), bsonDocument.getString("codeName", new BsonString("")).getValue(), bsonDocument.getString("errmsg").getValue(), bsonDocument.getDocument("errInfo", new BsonDocument()));
    }

    private WriteConcernHelper() {
    }
}

