/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.selector;

import com.mongodb.annotations.Immutable;
import com.mongodb.connection.ClusterDescription;
import com.mongodb.connection.ServerDescription;
import com.mongodb.selector.ServerSelector;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;

@Immutable
public final class AtMostTwoRandomServerSelector
implements ServerSelector {
    private static final int TWO = 2;
    private static final AtMostTwoRandomServerSelector INSTANCE = new AtMostTwoRandomServerSelector();

    private AtMostTwoRandomServerSelector() {
    }

    public static AtMostTwoRandomServerSelector instance() {
        return INSTANCE;
    }

    @Override
    public List<ServerDescription> select(ClusterDescription clusterDescription) {
        ArrayList<ServerDescription> arrayList = new ArrayList<ServerDescription>(clusterDescription.getServerDescriptions());
        ArrayList<ServerDescription> arrayList2 = new ArrayList<ServerDescription>();
        ThreadLocalRandom threadLocalRandom = ThreadLocalRandom.current();
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            Collections.swap(arrayList, i, threadLocalRandom.nextInt(i + 1));
            arrayList2.add((ServerDescription)arrayList.get(i));
            if (arrayList2.size() == 2) break;
        }
        return arrayList2;
    }
}

