/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.selector;

import com.mongodb.connection.ClusterConnectionMode;
import com.mongodb.connection.ClusterDescription;
import com.mongodb.connection.ServerDescription;
import com.mongodb.internal.connection.ClusterDescriptionHelper;
import com.mongodb.selector.ServerSelector;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class LatencyMinimizingServerSelector
implements ServerSelector {
    private final long acceptableLatencyDifferenceNanos;

    public LatencyMinimizingServerSelector(long l, TimeUnit timeUnit) {
        this.acceptableLatencyDifferenceNanos = TimeUnit.NANOSECONDS.convert(l, timeUnit);
    }

    public long getAcceptableLatencyDifference(TimeUnit timeUnit) {
        return timeUnit.convert(this.acceptableLatencyDifferenceNanos, TimeUnit.NANOSECONDS);
    }

    @Override
    public List<ServerDescription> select(ClusterDescription clusterDescription) {
        if (clusterDescription.getConnectionMode() != ClusterConnectionMode.MULTIPLE) {
            return ClusterDescriptionHelper.getAny(clusterDescription);
        }
        return this.getServersWithAcceptableLatencyDifference(ClusterDescriptionHelper.getAny(clusterDescription), this.getFastestRoundTripTimeNanos(clusterDescription.getServerDescriptions()));
    }

    public String toString() {
        return "LatencyMinimizingServerSelector{acceptableLatencyDifference=" + TimeUnit.MILLISECONDS.convert(this.acceptableLatencyDifferenceNanos, TimeUnit.NANOSECONDS) + " ms" + '}';
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        LatencyMinimizingServerSelector latencyMinimizingServerSelector = (LatencyMinimizingServerSelector)object;
        return this.acceptableLatencyDifferenceNanos == latencyMinimizingServerSelector.acceptableLatencyDifferenceNanos;
    }

    public int hashCode() {
        return (int)(this.acceptableLatencyDifferenceNanos ^ this.acceptableLatencyDifferenceNanos >>> 32);
    }

    private long getFastestRoundTripTimeNanos(List<ServerDescription> list) {
        long l = Long.MAX_VALUE;
        for (ServerDescription serverDescription : list) {
            if (!serverDescription.isOk() || serverDescription.getRoundTripTimeNanos() >= l) continue;
            l = serverDescription.getRoundTripTimeNanos();
        }
        return l;
    }

    private List<ServerDescription> getServersWithAcceptableLatencyDifference(List<ServerDescription> list, long l) {
        ArrayList<ServerDescription> arrayList = new ArrayList<ServerDescription>(list.size());
        for (ServerDescription serverDescription : list) {
            if (!serverDescription.isOk() || serverDescription.getRoundTripTimeNanos() - this.acceptableLatencyDifferenceNanos > l) continue;
            arrayList.add(serverDescription);
        }
        return arrayList;
    }
}

