/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.session;

import com.mongodb.ClientSessionOptions;
import com.mongodb.MongoClientException;
import com.mongodb.ServerAddress;
import com.mongodb.TransactionOptions;
import com.mongodb.WriteConcern;
import com.mongodb.assertions.Assertions;
import com.mongodb.internal.TimeoutContext;
import com.mongodb.internal.TimeoutSettings;
import com.mongodb.internal.binding.ReferenceCounted;
import com.mongodb.internal.session.ServerSessionPool;
import com.mongodb.lang.Nullable;
import com.mongodb.session.ClientSession;
import com.mongodb.session.ServerSession;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bson.BsonDocument;
import org.bson.BsonTimestamp;

public class BaseClientSessionImpl
implements ClientSession {
    private static final String CLUSTER_TIME_KEY = "clusterTime";
    private final ServerSessionPool serverSessionPool;
    private ServerSession serverSession;
    private final Object originator;
    private final ClientSessionOptions options;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private BsonDocument clusterTime;
    private BsonTimestamp operationTime;
    private BsonTimestamp snapshotTimestamp;
    private ServerAddress pinnedServerAddress;
    private BsonDocument recoveryToken;
    private ReferenceCounted transactionContext;
    @Nullable
    private TimeoutContext timeoutContext;

    protected static boolean hasTimeoutMS(@Nullable TimeoutContext timeoutContext) {
        return timeoutContext != null && timeoutContext.hasTimeoutMS();
    }

    protected static boolean hasWTimeoutMS(@Nullable WriteConcern writeConcern) {
        return writeConcern != null && writeConcern.getWTimeout(TimeUnit.MILLISECONDS) != null;
    }

    public BaseClientSessionImpl(ServerSessionPool serverSessionPool, Object object, ClientSessionOptions clientSessionOptions) {
        this.serverSessionPool = serverSessionPool;
        this.originator = object;
        this.options = clientSessionOptions;
        this.pinnedServerAddress = null;
    }

    @Override
    @Nullable
    public ServerAddress getPinnedServerAddress() {
        return this.pinnedServerAddress;
    }

    @Override
    public Object getTransactionContext() {
        return this.transactionContext;
    }

    @Override
    public void setTransactionContext(ServerAddress serverAddress, Object object) {
        Assertions.assertTrue(object instanceof ReferenceCounted);
        this.pinnedServerAddress = serverAddress;
        this.transactionContext = (ReferenceCounted)object;
        this.transactionContext.retain();
    }

    @Override
    public void clearTransactionContext() {
        this.pinnedServerAddress = null;
        if (this.transactionContext != null) {
            this.transactionContext.release();
            this.transactionContext = null;
        }
    }

    @Override
    public BsonDocument getRecoveryToken() {
        return this.recoveryToken;
    }

    @Override
    public void setRecoveryToken(BsonDocument bsonDocument) {
        this.recoveryToken = bsonDocument;
    }

    @Override
    public ClientSessionOptions getOptions() {
        return this.options;
    }

    @Override
    public boolean isCausallyConsistent() {
        Boolean bl = this.options.isCausallyConsistent();
        return bl == null || bl != false;
    }

    @Override
    public Object getOriginator() {
        return this.originator;
    }

    @Override
    public BsonDocument getClusterTime() {
        return this.clusterTime;
    }

    @Override
    public BsonTimestamp getOperationTime() {
        return this.operationTime;
    }

    @Override
    public ServerSession getServerSession() {
        Assertions.isTrue("open", !this.closed.get());
        if (this.serverSession == null) {
            this.serverSession = this.serverSessionPool.get();
        }
        return this.serverSession;
    }

    @Override
    public void advanceOperationTime(@Nullable BsonTimestamp bsonTimestamp) {
        Assertions.isTrue("open", !this.closed.get());
        this.operationTime = this.greaterOf(bsonTimestamp);
    }

    @Override
    public void advanceClusterTime(@Nullable BsonDocument bsonDocument) {
        Assertions.isTrue("open", !this.closed.get());
        this.clusterTime = this.greaterOf(bsonDocument);
    }

    @Override
    public void setSnapshotTimestamp(@Nullable BsonTimestamp bsonTimestamp) {
        Assertions.isTrue("open", !this.closed.get());
        if (bsonTimestamp != null) {
            if (this.snapshotTimestamp != null && !bsonTimestamp.equals(this.snapshotTimestamp)) {
                throw new MongoClientException("Snapshot timestamps should not change during the lifetime of the session.  Current timestamp is " + this.snapshotTimestamp + ", and attempting to set it to " + bsonTimestamp);
            }
            this.snapshotTimestamp = bsonTimestamp;
        }
    }

    @Override
    @Nullable
    public BsonTimestamp getSnapshotTimestamp() {
        Assertions.isTrue("open", !this.closed.get());
        return this.snapshotTimestamp;
    }

    private BsonDocument greaterOf(@Nullable BsonDocument bsonDocument) {
        if (bsonDocument == null) {
            return this.clusterTime;
        }
        if (this.clusterTime == null) {
            return bsonDocument;
        }
        return bsonDocument.getTimestamp(CLUSTER_TIME_KEY).compareTo(this.clusterTime.getTimestamp(CLUSTER_TIME_KEY)) > 0 ? bsonDocument : this.clusterTime;
    }

    private BsonTimestamp greaterOf(@Nullable BsonTimestamp bsonTimestamp) {
        if (bsonTimestamp == null) {
            return this.operationTime;
        }
        if (this.operationTime == null) {
            return bsonTimestamp;
        }
        return bsonTimestamp.compareTo(this.operationTime) > 0 ? bsonTimestamp : this.operationTime;
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            if (this.serverSession != null) {
                this.serverSessionPool.release(this.serverSession);
            }
            this.clearTransactionContext();
        }
    }

    @Override
    @Nullable
    public TimeoutContext getTimeoutContext() {
        return this.timeoutContext;
    }

    protected void setTimeoutContext(@Nullable TimeoutContext timeoutContext) {
        this.timeoutContext = timeoutContext;
    }

    protected void resetTimeout() {
        if (this.timeoutContext != null) {
            this.timeoutContext.resetTimeoutIfPresent();
        }
    }

    protected TimeoutSettings getTimeoutSettings(TransactionOptions transactionOptions, TimeoutSettings timeoutSettings) {
        Long l = transactionOptions.getTimeout(TimeUnit.MILLISECONDS);
        Long l2 = this.getOptions().getDefaultTimeout(TimeUnit.MILLISECONDS);
        Long l3 = timeoutSettings.getTimeoutMS();
        Long l4 = l != null ? l : (l2 != null ? l2 : l3);
        return timeoutSettings.withMaxCommitMS(transactionOptions.getMaxCommitTime(TimeUnit.MILLISECONDS)).withTimeout(l4, TimeUnit.MILLISECONDS);
    }

    protected static enum TransactionState {
        NONE,
        IN,
        COMMITTED,
        ABORTED;

    }
}

