/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.session;

import com.mongodb.MongoException;
import com.mongodb.ReadPreference;
import com.mongodb.ServerApi;
import com.mongodb.assertions.Assertions;
import com.mongodb.connection.ClusterDescription;
import com.mongodb.connection.ServerDescription;
import com.mongodb.internal.IgnorableRequestContext;
import com.mongodb.internal.TimeoutContext;
import com.mongodb.internal.TimeoutSettings;
import com.mongodb.internal.binding.ReferenceCounted;
import com.mongodb.internal.connection.Cluster;
import com.mongodb.internal.connection.NoOpSessionContext;
import com.mongodb.internal.connection.OperationContext;
import com.mongodb.internal.selector.ReadPreferenceServerSelector;
import com.mongodb.internal.validator.NoOpFieldNameValidator;
import com.mongodb.lang.Nullable;
import com.mongodb.selector.ServerSelector;
import com.mongodb.session.ServerSession;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import org.bson.BsonArray;
import org.bson.BsonBinary;
import org.bson.BsonDocument;
import org.bson.BsonDocumentWriter;
import org.bson.BsonWriter;
import org.bson.UuidRepresentation;
import org.bson.codecs.BsonDocumentCodec;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.UuidCodec;

public class ServerSessionPool {
    private final ConcurrentLinkedDeque<ServerSessionImpl> available = new ConcurrentLinkedDeque();
    private final Cluster cluster;
    private final Clock clock;
    private volatile boolean closed;
    private final OperationContext operationContext;
    private final LongAdder inUseCount = new LongAdder();

    public ServerSessionPool(Cluster cluster, TimeoutSettings timeoutSettings, @Nullable ServerApi serverApi) {
        this(cluster, new OperationContext(IgnorableRequestContext.INSTANCE, NoOpSessionContext.INSTANCE, new TimeoutContext(timeoutSettings.connectionOnly()), serverApi));
    }

    public ServerSessionPool(Cluster cluster, OperationContext operationContext) {
        this(cluster, operationContext, System::currentTimeMillis);
    }

    public ServerSessionPool(Cluster cluster, OperationContext operationContext, Clock clock) {
        this.cluster = cluster;
        this.operationContext = operationContext;
        this.clock = clock;
    }

    public ServerSession get() {
        Assertions.isTrue("server session pool is open", !this.closed);
        ServerSessionImpl serverSessionImpl = this.available.pollLast();
        while (serverSessionImpl != null && this.shouldPrune(serverSessionImpl)) {
            serverSessionImpl.close();
            serverSessionImpl = this.available.pollLast();
        }
        if (serverSessionImpl == null) {
            serverSessionImpl = new ServerSessionImpl();
        }
        this.inUseCount.increment();
        return serverSessionImpl;
    }

    public void release(ServerSession serverSession) {
        this.inUseCount.decrement();
        ServerSessionImpl serverSessionImpl = (ServerSessionImpl)serverSession;
        if (serverSessionImpl.isMarkedDirty()) {
            serverSessionImpl.close();
        } else {
            this.available.addLast(serverSessionImpl);
        }
    }

    public long getInUseCount() {
        return this.inUseCount.sum();
    }

    public void close() {
        this.closed = true;
        this.endClosedSessions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void endClosedSessions() {
        List<BsonDocument> list = this.drainPool();
        if (list.isEmpty()) {
            return;
        }
        final ReadPreference readPreference = ReadPreference.primaryPreferred();
        final List<ServerDescription> list2 = new ReadPreferenceServerSelector(readPreference).select(this.cluster.getCurrentDescription());
        if (list2.isEmpty()) {
            return;
        }
        ReferenceCounted referenceCounted = null;
        try {
            referenceCounted = this.cluster.selectServer(new ServerSelector(){

                @Override
                public List<ServerDescription> select(ClusterDescription clusterDescription) {
                    for (ServerDescription serverDescription : clusterDescription.getServerDescriptions()) {
                        if (!serverDescription.getAddress().equals(((ServerDescription)list2.get(0)).getAddress())) continue;
                        return Collections.singletonList(serverDescription);
                    }
                    return Collections.emptyList();
                }

                public String toString() {
                    return "ReadPreferenceServerSelector{readPreference=" + readPreference + '}';
                }
            }, this.operationContext).getServer().getConnection(this.operationContext);
            referenceCounted.command("admin", new BsonDocument("endSessions", new BsonArray(list)), NoOpFieldNameValidator.INSTANCE, ReadPreference.primaryPreferred(), new BsonDocumentCodec(), this.operationContext);
        }
        catch (MongoException mongoException) {
        }
        finally {
            if (referenceCounted != null) {
                referenceCounted.release();
            }
        }
    }

    private List<BsonDocument> drainPool() {
        ArrayList<BsonDocument> arrayList = new ArrayList<BsonDocument>(this.available.size());
        ServerSessionImpl serverSessionImpl = this.available.pollFirst();
        while (serverSessionImpl != null) {
            arrayList.add(serverSessionImpl.getIdentifier());
            serverSessionImpl = this.available.pollFirst();
        }
        return arrayList;
    }

    private boolean shouldPrune(ServerSessionImpl serverSessionImpl) {
        long l;
        Integer n = this.cluster.getCurrentDescription().getLogicalSessionTimeoutMinutes();
        if (n == null) {
            return false;
        }
        long l2 = this.clock.millis();
        long l3 = l2 - serverSessionImpl.getLastUsedAtMillis();
        return l3 > (l = TimeUnit.MINUTES.toMillis(n - 1));
    }

    private BsonBinary createNewServerSessionIdentifier() {
        UuidCodec uuidCodec = new UuidCodec(UuidRepresentation.STANDARD);
        BsonDocument bsonDocument = new BsonDocument();
        BsonDocumentWriter bsonDocumentWriter = new BsonDocumentWriter(bsonDocument);
        bsonDocumentWriter.writeStartDocument();
        bsonDocumentWriter.writeName("id");
        uuidCodec.encode((BsonWriter)bsonDocumentWriter, UUID.randomUUID(), EncoderContext.builder().build());
        bsonDocumentWriter.writeEndDocument();
        return bsonDocument.getBinary("id");
    }

    static interface Clock {
        public long millis();
    }

    final class ServerSessionImpl
    implements ServerSession {
        private final BsonDocument identifier;
        private long transactionNumber = 0L;
        private volatile long lastUsedAtMillis = ServerSessionPool.access$000(ServerSessionPool.this).millis();
        private volatile boolean closed;
        private volatile boolean dirty = false;

        ServerSessionImpl() {
            this.identifier = new BsonDocument("id", ServerSessionPool.this.createNewServerSessionIdentifier());
        }

        void close() {
            this.closed = true;
        }

        long getLastUsedAtMillis() {
            return this.lastUsedAtMillis;
        }

        @Override
        public long getTransactionNumber() {
            return this.transactionNumber;
        }

        @Override
        public BsonDocument getIdentifier() {
            this.lastUsedAtMillis = ServerSessionPool.this.clock.millis();
            return this.identifier;
        }

        @Override
        public long advanceTransactionNumber() {
            ++this.transactionNumber;
            return this.transactionNumber;
        }

        @Override
        public boolean isClosed() {
            return this.closed;
        }

        @Override
        public void markDirty() {
            this.dirty = true;
        }

        @Override
        public boolean isMarkedDirty() {
            return this.dirty;
        }
    }
}

