/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.thread;

import com.mongodb.MongoInterruptedException;
import com.mongodb.lang.Nullable;
import java.io.InterruptedIOException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.channels.ClosedByInterruptException;
import java.util.Optional;

public final class InterruptionUtil {
    public static MongoInterruptedException interruptAndCreateMongoInterruptedException(@Nullable String string, @Nullable InterruptedException interruptedException) {
        Thread.currentThread().interrupt();
        return new MongoInterruptedException(string, interruptedException);
    }

    public static Optional<MongoInterruptedException> translateInterruptedException(@Nullable Throwable throwable, @Nullable String string) {
        if (throwable instanceof InterruptedException) {
            return Optional.of(InterruptionUtil.interruptAndCreateMongoInterruptedException(string, (InterruptedException)throwable));
        }
        if (throwable instanceof InterruptedIOException && !(throwable instanceof SocketTimeoutException) || throwable instanceof ClosedByInterruptException || throwable instanceof SocketException && Thread.currentThread().isInterrupted()) {
            return Optional.of(new MongoInterruptedException(string, (Exception)throwable));
        }
        return Optional.empty();
    }

    private InterruptionUtil() {
    }
}

