/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.time;

import com.mongodb.annotations.Immutable;
import com.mongodb.assertions.Assertions;
import com.mongodb.internal.function.CheckedFunction;
import com.mongodb.internal.function.CheckedSupplier;
import com.mongodb.internal.time.StartTime;
import com.mongodb.internal.time.Timeout;
import com.mongodb.lang.Nullable;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

@Immutable
class TimePoint
implements Comparable<TimePoint>,
StartTime,
Timeout {
    @Nullable
    private final Long nanos;

    TimePoint(@Nullable Long l) {
        this.nanos = l;
    }

    static TimePoint at(@Nullable Long l) {
        return new TimePoint(l);
    }

    long currentNanos() {
        return System.nanoTime();
    }

    static TimePoint now() {
        return TimePoint.at(System.nanoTime());
    }

    static TimePoint infinite() {
        return TimePoint.at(null);
    }

    @Override
    public Timeout shortenBy(long l, TimeUnit timeUnit) {
        if (this.isInfinite()) {
            return this;
        }
        long l2 = TimeUnit.NANOSECONDS.convert(l, timeUnit);
        return TimePoint.at(Assertions.assertNotNull(this.nanos) - l2);
    }

    @Override
    public <T, E extends Exception> T checkedCall(TimeUnit timeUnit, CheckedSupplier<T, E> checkedSupplier, CheckedFunction<Long, T, E> checkedFunction, CheckedSupplier<T, E> checkedSupplier2) throws E {
        if (this.isInfinite()) {
            return checkedSupplier.get();
        }
        long l = this.remaining(timeUnit);
        if (l <= 0L) {
            return checkedSupplier2.get();
        }
        return checkedFunction.apply(l);
    }

    private boolean isInfinite() {
        return this.nanos == null;
    }

    @Override
    public Timeout asTimeout() {
        return this;
    }

    private long remaining(TimeUnit timeUnit) {
        if (this.isInfinite()) {
            throw new AssertionError((Object)"Infinite TimePoints have infinite remaining time");
        }
        long l = Assertions.assertNotNull(this.nanos) - this.currentNanos();
        return (l = timeUnit.convert(l, TimeUnit.NANOSECONDS)) <= 0L ? 0L : l;
    }

    @Override
    public Duration elapsed() {
        if (this.isInfinite()) {
            throw new AssertionError((Object)"No time can elapse since an infinite TimePoint");
        }
        return Duration.ofNanos(this.currentNanos() - Assertions.assertNotNull(this.nanos));
    }

    Duration durationSince(TimePoint timePoint) {
        if (this.isInfinite()) {
            throw new AssertionError((Object)"this timepoint is infinite, with no duration since");
        }
        if (timePoint.isInfinite()) {
            throw new AssertionError((Object)"the other timepoint is infinite, with no duration until");
        }
        return Duration.ofNanos(this.nanos - Assertions.assertNotNull(timePoint.nanos));
    }

    @Override
    public TimePoint timeoutAfterOrInfiniteIfNegative(long l, TimeUnit timeUnit) {
        if (l < 0L) {
            return TimePoint.infinite();
        }
        return this.add(Duration.ofNanos(TimeUnit.NANOSECONDS.convert(l, timeUnit)));
    }

    TimePoint add(Duration duration) {
        if (this.isInfinite()) {
            throw new AssertionError((Object)"No time can be added to an infinite TimePoint");
        }
        long l = duration.toNanos();
        return TimePoint.at(Assertions.assertNotNull(this.nanos) + l);
    }

    @Override
    public int compareTo(TimePoint timePoint) {
        if (Objects.equals(this.nanos, timePoint.nanos)) {
            return 0;
        }
        if (this.isInfinite()) {
            return 1;
        }
        if (timePoint.isInfinite()) {
            return -1;
        }
        return Long.signum(this.nanos - Assertions.assertNotNull(timePoint.nanos));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        TimePoint timePoint = (TimePoint)object;
        return Objects.equals(this.nanos, timePoint.nanos);
    }

    public int hashCode() {
        return Objects.hash(this.nanos);
    }

    public String toString() {
        String string = this.isInfinite() ? "infinite" : "" + this.remaining(TimeUnit.MILLISECONDS);
        return "TimePoint{nanos=" + this.nanos + ", remainingMs=" + string + '}';
    }
}

