/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.time;

import com.mongodb.assertions.Assertions;
import com.mongodb.internal.function.CheckedConsumer;
import com.mongodb.internal.function.CheckedFunction;
import com.mongodb.internal.function.CheckedRunnable;
import com.mongodb.internal.function.CheckedSupplier;
import com.mongodb.internal.thread.InterruptionUtil;
import com.mongodb.internal.time.TimePoint;
import com.mongodb.lang.NonNull;
import com.mongodb.lang.Nullable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.function.LongConsumer;
import java.util.function.LongFunction;
import java.util.function.Supplier;

public interface Timeout {
    public static Timeout earliest(Timeout ... timeoutArray) {
        List<Timeout> list = Arrays.asList(timeoutArray);
        list.forEach(timeout -> {
            if (!(timeout instanceof TimePoint)) {
                throw new AssertionError((Object)"Only TimePoints may be compared");
            }
        });
        return Collections.min(list, (timeout, timeout2) -> {
            TimePoint timePoint = (TimePoint)timeout;
            TimePoint timePoint2 = (TimePoint)timeout2;
            return timePoint.compareTo(timePoint2);
        });
    }

    public static Timeout infinite() {
        return TimePoint.infinite();
    }

    public static Timeout nullAsInfinite(@Nullable Timeout timeout) {
        return timeout == null ? Timeout.infinite() : timeout;
    }

    @NonNull
    public static Timeout expiresIn(long l, TimeUnit timeUnit, ZeroSemantics zeroSemantics) {
        if (l < 0L) {
            throw new AssertionError((Object)"Timeouts must not be in the past");
        }
        if (l == 0L) {
            switch (zeroSemantics) {
                case ZERO_DURATION_MEANS_INFINITE: {
                    return Timeout.infinite();
                }
                case ZERO_DURATION_MEANS_EXPIRED: {
                    return TimePoint.now();
                }
            }
            throw Assertions.fail("Unknown enum value");
        }
        return TimePoint.now().timeoutAfterOrInfiniteIfNegative(l, timeUnit);
    }

    public Timeout shortenBy(long var1, TimeUnit var3);

    default public void awaitOn(Condition condition, Supplier<String> supplier) {
        try {
            this.checkedRun(TimeUnit.NANOSECONDS, () -> condition.await(), l -> condition.awaitNanos((long)l), () -> condition.awaitNanos(0L));
        }
        catch (InterruptedException interruptedException) {
            throw InterruptionUtil.interruptAndCreateMongoInterruptedException("Interrupted while " + supplier.get(), interruptedException);
        }
    }

    default public void awaitOn(CountDownLatch countDownLatch, Supplier<String> supplier) {
        try {
            this.checkedRun(TimeUnit.NANOSECONDS, () -> countDownLatch.await(), l -> countDownLatch.await((long)l, TimeUnit.NANOSECONDS), () -> countDownLatch.await(0L, TimeUnit.NANOSECONDS));
        }
        catch (InterruptedException interruptedException) {
            throw InterruptionUtil.interruptAndCreateMongoInterruptedException("Interrupted while " + supplier.get(), interruptedException);
        }
    }

    default public <T> T call(TimeUnit timeUnit, Supplier<T> supplier, LongFunction<T> longFunction, Supplier<T> supplier2) {
        return (T)this.checkedCall(timeUnit, supplier::get, longFunction::apply, supplier2::get);
    }

    public <T, E extends Exception> T checkedCall(TimeUnit var1, CheckedSupplier<T, E> var2, CheckedFunction<Long, T, E> var3, CheckedSupplier<T, E> var4) throws E;

    default public void run(TimeUnit timeUnit, Runnable runnable, LongConsumer longConsumer, Runnable runnable2) {
        this.call(timeUnit, () -> {
            runnable.run();
            return null;
        }, l -> {
            longConsumer.accept(l);
            return null;
        }, () -> {
            runnable2.run();
            return null;
        });
    }

    default public <E extends Exception> void checkedRun(TimeUnit timeUnit, CheckedRunnable<E> checkedRunnable, CheckedConsumer<Long, E> checkedConsumer, CheckedRunnable<E> checkedRunnable2) throws E {
        this.checkedCall(timeUnit, () -> {
            checkedRunnable.run();
            return null;
        }, l -> {
            checkedConsumer.accept((Long)l);
            return null;
        }, () -> {
            checkedRunnable2.run();
            return null;
        });
    }

    default public void onExpired(Runnable runnable) {
        Timeout.onExistsAndExpired(this, runnable);
    }

    public static void onExistsAndExpired(@Nullable Timeout timeout, Runnable runnable) {
        if (timeout == null) {
            return;
        }
        timeout.run(TimeUnit.NANOSECONDS, () -> {}, l -> {}, () -> runnable.run());
    }

    public static enum ZeroSemantics {
        ZERO_DURATION_MEANS_EXPIRED,
        ZERO_DURATION_MEANS_INFINITE;

    }
}

