/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.validator;

import com.mongodb.assertions.Assertions;
import com.mongodb.internal.validator.NoOpFieldNameValidator;
import java.util.Arrays;
import java.util.List;
import org.bson.FieldNameValidator;

public final class ReplacingDocumentFieldNameValidator
implements FieldNameValidator {
    public static final ReplacingDocumentFieldNameValidator INSTANCE = new ReplacingDocumentFieldNameValidator();
    private static final List<String> EXCEPTIONS = Arrays.asList("$db", "$ref", "$id");

    private ReplacingDocumentFieldNameValidator() {
    }

    @Override
    public boolean validate(String string) {
        return !string.startsWith("$") || EXCEPTIONS.contains(string);
    }

    @Override
    public String getValidationErrorMessage(String string) {
        Assertions.assertFalse(this.validate(string));
        return String.format("Field names in a replacement document can not start with '$' but '%s' does", string);
    }

    @Override
    public FieldNameValidator getValidatorForField(String string) {
        return NoOpFieldNameValidator.INSTANCE;
    }
}

