/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.validator;

import com.mongodb.assertions.Assertions;
import com.mongodb.internal.validator.NoOpFieldNameValidator;
import org.bson.FieldNameValidator;

public final class UpdateFieldNameValidator
implements FieldNameValidator {
    private boolean encounteredField = false;

    @Override
    public boolean validate(String string) {
        this.encounteredField = true;
        return string.startsWith("$");
    }

    @Override
    public String getValidationErrorMessage(String string) {
        Assertions.assertFalse(string.startsWith("$"));
        return String.format("All update operators must start with '$', but '%s' does not", string);
    }

    @Override
    public FieldNameValidator getValidatorForField(String string) {
        return NoOpFieldNameValidator.INSTANCE;
    }

    @Override
    public void start() {
        this.reset();
    }

    @Override
    public void end() {
        if (!this.encounteredField) {
            throw new IllegalArgumentException("Invalid BSON document for an update. The document may not be empty.");
        }
    }

    public UpdateFieldNameValidator reset() {
        this.encounteredField = false;
        return this;
    }
}

