/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.management;

import com.mongodb.connection.ConnectionId;
import com.mongodb.connection.ServerId;
import com.mongodb.event.ConnectionCheckedInEvent;
import com.mongodb.event.ConnectionCheckedOutEvent;
import com.mongodb.event.ConnectionClosedEvent;
import com.mongodb.event.ConnectionCreatedEvent;
import com.mongodb.event.ConnectionPoolClosedEvent;
import com.mongodb.event.ConnectionPoolCreatedEvent;
import com.mongodb.event.ConnectionPoolListener;
import com.mongodb.lang.Nullable;
import com.mongodb.management.ConnectionPoolStatistics;
import com.mongodb.management.ConnectionPoolStatisticsMBean;
import com.mongodb.management.MBeanServerFactory;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.management.ObjectName;

public class JMXConnectionPoolListener
implements ConnectionPoolListener {
    private final ConcurrentMap<ServerId, ConnectionPoolStatistics> map = new ConcurrentHashMap<ServerId, ConnectionPoolStatistics>();

    @Override
    public void connectionPoolCreated(ConnectionPoolCreatedEvent connectionPoolCreatedEvent) {
        ConnectionPoolStatistics connectionPoolStatistics = new ConnectionPoolStatistics(connectionPoolCreatedEvent);
        this.map.put(connectionPoolCreatedEvent.getServerId(), connectionPoolStatistics);
        MBeanServerFactory.getMBeanServer().registerMBean(connectionPoolStatistics, this.getMBeanObjectName(connectionPoolCreatedEvent.getServerId()));
    }

    @Override
    public void connectionPoolClosed(ConnectionPoolClosedEvent connectionPoolClosedEvent) {
        this.map.remove(connectionPoolClosedEvent.getServerId());
        MBeanServerFactory.getMBeanServer().unregisterMBean(this.getMBeanObjectName(connectionPoolClosedEvent.getServerId()));
    }

    @Override
    public void connectionCheckedOut(ConnectionCheckedOutEvent connectionCheckedOutEvent) {
        ConnectionPoolStatistics connectionPoolStatistics = this.getStatistics(connectionCheckedOutEvent.getConnectionId());
        if (connectionPoolStatistics != null) {
            connectionPoolStatistics.connectionCheckedOut(connectionCheckedOutEvent);
        }
    }

    @Override
    public void connectionCheckedIn(ConnectionCheckedInEvent connectionCheckedInEvent) {
        ConnectionPoolStatistics connectionPoolStatistics = this.getStatistics(connectionCheckedInEvent.getConnectionId());
        if (connectionPoolStatistics != null) {
            connectionPoolStatistics.connectionCheckedIn(connectionCheckedInEvent);
        }
    }

    @Override
    public void connectionCreated(ConnectionCreatedEvent connectionCreatedEvent) {
        ConnectionPoolStatistics connectionPoolStatistics = this.getStatistics(connectionCreatedEvent.getConnectionId());
        if (connectionPoolStatistics != null) {
            connectionPoolStatistics.connectionCreated(connectionCreatedEvent);
        }
    }

    @Override
    public void connectionClosed(ConnectionClosedEvent connectionClosedEvent) {
        ConnectionPoolStatistics connectionPoolStatistics = this.getStatistics(connectionClosedEvent.getConnectionId());
        if (connectionPoolStatistics != null) {
            connectionPoolStatistics.connectionClosed(connectionClosedEvent);
        }
    }

    String getMBeanObjectName(ServerId serverId) {
        String string = String.format("org.mongodb.driver:type=ConnectionPool,clusterId=%s,host=%s,port=%s", this.ensureValidValue(serverId.getClusterId().getValue()), this.ensureValidValue(serverId.getAddress().getHost()), serverId.getAddress().getPort());
        String string2 = serverId.getClusterId().getDescription();
        if (string2 != null) {
            string = String.format("%s,description=%s", string, this.ensureValidValue(string2));
        }
        return string;
    }

    @Nullable
    ConnectionPoolStatisticsMBean getMBean(ServerId serverId) {
        return this.getStatistics(serverId);
    }

    @Nullable
    private ConnectionPoolStatistics getStatistics(ConnectionId connectionId) {
        return this.getStatistics(connectionId.getServerId());
    }

    @Nullable
    private ConnectionPoolStatistics getStatistics(ServerId serverId) {
        return (ConnectionPoolStatistics)this.map.get(serverId);
    }

    private String ensureValidValue(String string) {
        if (this.containsQuotableCharacter(string)) {
            return ObjectName.quote(string);
        }
        return string;
    }

    private boolean containsQuotableCharacter(@Nullable String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        List<String> list = Arrays.asList(",", ":", "?", "*", "=", "\"", "\\", "\n");
        for (String string2 : list) {
            if (!string.contains(string2)) continue;
            return true;
        }
        return false;
    }
}

