/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.management;

import com.mongodb.internal.diagnostics.logging.Logger;
import com.mongodb.internal.diagnostics.logging.Loggers;
import com.mongodb.management.MBeanServer;
import java.lang.management.ManagementFactory;
import javax.management.ObjectName;

class JMXMBeanServer
implements MBeanServer {
    private static final Logger LOGGER = Loggers.getLogger("management");
    private final javax.management.MBeanServer server = ManagementFactory.getPlatformMBeanServer();

    JMXMBeanServer() {
    }

    @Override
    public void registerMBean(Object object, String string) {
        try {
            this.server.registerMBean(object, new ObjectName(string));
        }
        catch (Exception exception) {
            LOGGER.warn("Unable to register MBean " + string, exception);
        }
    }

    @Override
    public void unregisterMBean(String string) {
        try {
            ObjectName objectName = new ObjectName(string);
            if (this.server.isRegistered(objectName)) {
                this.server.unregisterMBean(objectName);
            }
        }
        catch (Exception exception) {
            LOGGER.warn("Unable to unregister MBean " + string, exception);
        }
    }
}

