/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.selector;

import com.mongodb.assertions.Assertions;
import com.mongodb.connection.ClusterDescription;
import com.mongodb.connection.ServerDescription;
import com.mongodb.selector.ServerSelector;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class CompositeServerSelector
implements ServerSelector {
    private final List<ServerSelector> serverSelectors;

    public CompositeServerSelector(List<? extends ServerSelector> list) {
        Assertions.notNull("serverSelectors", list);
        if (list.isEmpty()) {
            throw new IllegalArgumentException("Server selectors can not be an empty list");
        }
        ArrayList<ServerSelector> arrayList = new ArrayList<ServerSelector>();
        for (ServerSelector serverSelector : list) {
            if (serverSelector == null) {
                throw new IllegalArgumentException("Can not have a null server selector in the list of composed selectors");
            }
            if (serverSelector instanceof CompositeServerSelector) {
                arrayList.addAll(((CompositeServerSelector)serverSelector).serverSelectors);
                continue;
            }
            arrayList.add(serverSelector);
        }
        this.serverSelectors = Collections.unmodifiableList(arrayList);
    }

    public List<ServerSelector> getServerSelectors() {
        return this.serverSelectors;
    }

    @Override
    public List<ServerDescription> select(ClusterDescription clusterDescription) {
        ClusterDescription clusterDescription2 = clusterDescription;
        List<ServerDescription> list = null;
        for (ServerSelector serverSelector : this.serverSelectors) {
            list = serverSelector.select(clusterDescription2);
            clusterDescription2 = new ClusterDescription(clusterDescription.getConnectionMode(), clusterDescription.getType(), list, clusterDescription.getClusterSettings(), clusterDescription.getServerSettings());
        }
        return Assertions.assertNotNull(list);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        CompositeServerSelector compositeServerSelector = (CompositeServerSelector)object;
        if (this.serverSelectors.size() != compositeServerSelector.serverSelectors.size()) {
            return false;
        }
        return this.serverSelectors.equals(compositeServerSelector.serverSelectors);
    }

    public int hashCode() {
        return this.serverSelectors != null ? this.serverSelectors.hashCode() : 0;
    }

    public String toString() {
        return "CompositeServerSelector{serverSelectors=" + this.serverSelectors + '}';
    }
}

