/*
 * Decompiled with CFR 0.152.
 */
package com.zaxxer.hikari.hibernate;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import com.zaxxer.hikari.hibernate.HikariConfigurationUtil;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import javax.sql.DataSource;
import org.hibernate.HibernateException;
import org.hibernate.Version;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.service.UnknownUnwrapTypeException;
import org.hibernate.service.spi.Configurable;
import org.hibernate.service.spi.Stoppable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HikariConnectionProvider
implements ConnectionProvider,
Configurable,
Stoppable {
    private static final long serialVersionUID = -9131625057941275711L;
    private static final Logger LOGGER = LoggerFactory.getLogger(HikariConnectionProvider.class);
    private HikariConfig hcfg = null;
    private HikariDataSource hds = null;

    public HikariConnectionProvider() {
        if (Version.getVersionString().substring(0, 5).compareTo("4.3.6") >= 1) {
            LOGGER.warn("com.zaxxer.hikari.hibernate.HikariConnectionProvider has been deprecated for versions of Hibernate 4.3.6 and newer.  Please switch to org.hibernate.hikaricp.internal.HikariCPConnectionProvider.");
        }
    }

    public void configure(Map map) throws HibernateException {
        try {
            LOGGER.debug("Configuring HikariCP");
            this.hcfg = HikariConfigurationUtil.loadConfiguration(map);
            this.hds = new HikariDataSource(this.hcfg);
        }
        catch (Exception exception) {
            throw new HibernateException((Throwable)exception);
        }
        LOGGER.debug("HikariCP Configured");
    }

    public Connection getConnection() throws SQLException {
        Connection connection = null;
        if (this.hds != null) {
            connection = this.hds.getConnection();
        }
        return connection;
    }

    public void closeConnection(Connection connection) throws SQLException {
        connection.close();
    }

    public boolean supportsAggressiveRelease() {
        return false;
    }

    public boolean isUnwrappableAs(Class clazz) {
        return ConnectionProvider.class.equals((Object)clazz) || HikariConnectionProvider.class.isAssignableFrom(clazz);
    }

    public <T> T unwrap(Class<T> clazz) {
        if (ConnectionProvider.class.equals(clazz) || HikariConnectionProvider.class.isAssignableFrom(clazz)) {
            return (T)this;
        }
        if (DataSource.class.isAssignableFrom(clazz)) {
            return (T)this.hds;
        }
        throw new UnknownUnwrapTypeException(clazz);
    }

    public void stop() {
        this.hds.close();
    }
}

