/*
 * Decompiled with CFR 0.152.
 */
package com.zaxxer.hikari.metrics.dropwizard;

import com.zaxxer.hikari.metrics.IMetricsTracker;
import com.zaxxer.hikari.metrics.PoolStats;
import io.dropwizard.metrics5.Gauge;
import io.dropwizard.metrics5.Histogram;
import io.dropwizard.metrics5.Meter;
import io.dropwizard.metrics5.Metric;
import io.dropwizard.metrics5.MetricRegistry;
import io.dropwizard.metrics5.Timer;
import java.util.concurrent.TimeUnit;

public class Dropwizard5MetricsTracker
implements IMetricsTracker {
    private final String poolName;
    private final Timer connectionObtainTimer;
    private final Histogram connectionUsage;
    private final Histogram connectionCreation;
    private final Meter connectionTimeoutMeter;
    private final MetricRegistry registry;

    Dropwizard5MetricsTracker(String string, PoolStats poolStats, MetricRegistry metricRegistry) {
        this.poolName = string;
        this.registry = metricRegistry;
        this.connectionObtainTimer = metricRegistry.timer(MetricRegistry.name((String)string, (String[])new String[]{"pool", "Wait"}));
        this.connectionUsage = metricRegistry.histogram(MetricRegistry.name((String)string, (String[])new String[]{"pool", "Usage"}));
        this.connectionCreation = metricRegistry.histogram(MetricRegistry.name((String)string, (String[])new String[]{"pool", "ConnectionCreation"}));
        this.connectionTimeoutMeter = metricRegistry.meter(MetricRegistry.name((String)string, (String[])new String[]{"pool", "ConnectionTimeoutRate"}));
        metricRegistry.register(MetricRegistry.name((String)string, (String[])new String[]{"pool", "TotalConnections"}), (Metric)((Gauge)poolStats::getTotalConnections));
        metricRegistry.register(MetricRegistry.name((String)string, (String[])new String[]{"pool", "IdleConnections"}), (Metric)((Gauge)poolStats::getIdleConnections));
        metricRegistry.register(MetricRegistry.name((String)string, (String[])new String[]{"pool", "ActiveConnections"}), (Metric)((Gauge)poolStats::getActiveConnections));
        metricRegistry.register(MetricRegistry.name((String)string, (String[])new String[]{"pool", "PendingConnections"}), (Metric)((Gauge)poolStats::getPendingThreads));
        metricRegistry.register(MetricRegistry.name((String)string, (String[])new String[]{"pool", "MaxConnections"}), (Metric)((Gauge)poolStats::getMaxConnections));
        metricRegistry.register(MetricRegistry.name((String)string, (String[])new String[]{"pool", "MinConnections"}), (Metric)((Gauge)poolStats::getMinConnections));
    }

    @Override
    public void close() {
        this.registry.remove(MetricRegistry.name((String)this.poolName, (String[])new String[]{"pool", "Wait"}));
        this.registry.remove(MetricRegistry.name((String)this.poolName, (String[])new String[]{"pool", "Usage"}));
        this.registry.remove(MetricRegistry.name((String)this.poolName, (String[])new String[]{"pool", "ConnectionCreation"}));
        this.registry.remove(MetricRegistry.name((String)this.poolName, (String[])new String[]{"pool", "ConnectionTimeoutRate"}));
        this.registry.remove(MetricRegistry.name((String)this.poolName, (String[])new String[]{"pool", "TotalConnections"}));
        this.registry.remove(MetricRegistry.name((String)this.poolName, (String[])new String[]{"pool", "IdleConnections"}));
        this.registry.remove(MetricRegistry.name((String)this.poolName, (String[])new String[]{"pool", "ActiveConnections"}));
        this.registry.remove(MetricRegistry.name((String)this.poolName, (String[])new String[]{"pool", "PendingConnections"}));
        this.registry.remove(MetricRegistry.name((String)this.poolName, (String[])new String[]{"pool", "MaxConnections"}));
        this.registry.remove(MetricRegistry.name((String)this.poolName, (String[])new String[]{"pool", "MinConnections"}));
    }

    @Override
    public void recordConnectionAcquiredNanos(long l) {
        this.connectionObtainTimer.update(l, TimeUnit.NANOSECONDS);
    }

    @Override
    public void recordConnectionUsageMillis(long l) {
        this.connectionUsage.update(l);
    }

    @Override
    public void recordConnectionTimeout() {
        this.connectionTimeoutMeter.mark();
    }

    @Override
    public void recordConnectionCreatedMillis(long l) {
        this.connectionCreation.update(l);
    }

    public Timer getConnectionAcquisitionTimer() {
        return this.connectionObtainTimer;
    }

    public Histogram getConnectionDurationHistogram() {
        return this.connectionUsage;
    }

    public Histogram getConnectionCreationHistogram() {
        return this.connectionCreation;
    }
}

