/*
 * Decompiled with CFR 0.152.
 */
package com.zaxxer.hikari.pool;

import com.zaxxer.hikari.pool.ProxyConnection;
import com.zaxxer.hikari.pool.ProxyStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public abstract class ProxyResultSet
implements ResultSet {
    protected final ProxyConnection connection;
    protected final ProxyStatement statement;
    final ResultSet delegate;

    protected ProxyResultSet(ProxyConnection proxyConnection, ProxyStatement proxyStatement, ResultSet resultSet) {
        this.connection = proxyConnection;
        this.statement = proxyStatement;
        this.delegate = resultSet;
    }

    final SQLException checkException(SQLException sQLException) {
        return this.connection.checkException(sQLException);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "@" + System.identityHashCode(this) + " wrapping " + this.delegate;
    }

    @Override
    public final Statement getStatement() throws SQLException {
        return this.statement;
    }

    @Override
    public void updateRow() throws SQLException {
        this.connection.markCommitStateDirty();
        this.delegate.updateRow();
    }

    @Override
    public void insertRow() throws SQLException {
        this.connection.markCommitStateDirty();
        this.delegate.insertRow();
    }

    @Override
    public void deleteRow() throws SQLException {
        this.connection.markCommitStateDirty();
        this.delegate.deleteRow();
    }

    @Override
    public final boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return clazz.isInstance(this.delegate) || this.delegate != null && this.delegate.isWrapperFor(clazz);
    }

    @Override
    public final <T> T unwrap(Class<T> clazz) throws SQLException {
        if (clazz.isInstance(this.delegate)) {
            return (T)this.delegate;
        }
        if (this.delegate != null) {
            return this.delegate.unwrap(clazz);
        }
        throw new SQLException("Wrapped ResultSet is not an instance of " + clazz);
    }
}

