/*
 * Decompiled with CFR 0.152.
 */
package com.zaxxer.hikari.util;

import java.util.concurrent.TimeUnit;

public interface ClockSource {
    public static final ClockSource CLOCK = Factory.create();
    public static final TimeUnit[] TIMEUNITS_DESCENDING = new TimeUnit[]{TimeUnit.DAYS, TimeUnit.HOURS, TimeUnit.MINUTES, TimeUnit.SECONDS, TimeUnit.MILLISECONDS, TimeUnit.MICROSECONDS, TimeUnit.NANOSECONDS};
    public static final String[] TIMEUNIT_DISPLAY_VALUES = new String[]{"ns", "\u00b5s", "ms", "s", "m", "h", "d"};

    public static long currentTime() {
        return CLOCK.currentTime0();
    }

    public long currentTime0();

    public static long toMillis(long l) {
        return CLOCK.toMillis0(l);
    }

    public long toMillis0(long var1);

    public static long toNanos(long l) {
        return CLOCK.toNanos0(l);
    }

    public long toNanos0(long var1);

    public static long elapsedMillis(long l) {
        return CLOCK.elapsedMillis0(l);
    }

    public long elapsedMillis0(long var1);

    public static long elapsedMillis(long l, long l2) {
        return CLOCK.elapsedMillis0(l, l2);
    }

    public long elapsedMillis0(long var1, long var3);

    public static long elapsedNanos(long l) {
        return CLOCK.elapsedNanos0(l);
    }

    public long elapsedNanos0(long var1);

    public static long elapsedNanos(long l, long l2) {
        return CLOCK.elapsedNanos0(l, l2);
    }

    public long elapsedNanos0(long var1, long var3);

    public static long plusMillis(long l, long l2) {
        return CLOCK.plusMillis0(l, l2);
    }

    public long plusMillis0(long var1, long var3);

    public static TimeUnit getSourceTimeUnit() {
        return CLOCK.getSourceTimeUnit0();
    }

    public TimeUnit getSourceTimeUnit0();

    public static String elapsedDisplayString(long l, long l2) {
        return CLOCK.elapsedDisplayString0(l, l2);
    }

    default public String elapsedDisplayString0(long l, long l2) {
        long l3 = this.elapsedNanos0(l, l2);
        StringBuilder stringBuilder = new StringBuilder(l3 < 0L ? "-" : "");
        l3 = Math.abs(l3);
        for (TimeUnit timeUnit : TIMEUNITS_DESCENDING) {
            long l4 = timeUnit.convert(l3, TimeUnit.NANOSECONDS);
            if (l4 <= 0L) continue;
            stringBuilder.append(l4).append(TIMEUNIT_DISPLAY_VALUES[timeUnit.ordinal()]);
            l3 -= TimeUnit.NANOSECONDS.convert(l4, timeUnit);
        }
        return stringBuilder.toString();
    }

    public static class NanosecondClockSource
    implements ClockSource {
        @Override
        public long currentTime0() {
            return System.nanoTime();
        }

        @Override
        public long toMillis0(long l) {
            return TimeUnit.NANOSECONDS.toMillis(l);
        }

        @Override
        public long toNanos0(long l) {
            return l;
        }

        @Override
        public long elapsedMillis0(long l) {
            return TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - l);
        }

        @Override
        public long elapsedMillis0(long l, long l2) {
            return TimeUnit.NANOSECONDS.toMillis(l2 - l);
        }

        @Override
        public long elapsedNanos0(long l) {
            return System.nanoTime() - l;
        }

        @Override
        public long elapsedNanos0(long l, long l2) {
            return l2 - l;
        }

        @Override
        public long plusMillis0(long l, long l2) {
            return l + TimeUnit.MILLISECONDS.toNanos(l2);
        }

        @Override
        public TimeUnit getSourceTimeUnit0() {
            return TimeUnit.NANOSECONDS;
        }
    }

    public static final class MillisecondClockSource
    implements ClockSource {
        @Override
        public long currentTime0() {
            return System.currentTimeMillis();
        }

        @Override
        public long elapsedMillis0(long l) {
            return System.currentTimeMillis() - l;
        }

        @Override
        public long elapsedMillis0(long l, long l2) {
            return l2 - l;
        }

        @Override
        public long elapsedNanos0(long l) {
            return TimeUnit.MILLISECONDS.toNanos(System.currentTimeMillis() - l);
        }

        @Override
        public long elapsedNanos0(long l, long l2) {
            return TimeUnit.MILLISECONDS.toNanos(l2 - l);
        }

        @Override
        public long toMillis0(long l) {
            return l;
        }

        @Override
        public long toNanos0(long l) {
            return TimeUnit.MILLISECONDS.toNanos(l);
        }

        @Override
        public long plusMillis0(long l, long l2) {
            return l + l2;
        }

        @Override
        public TimeUnit getSourceTimeUnit0() {
            return TimeUnit.MILLISECONDS;
        }
    }

    public static class Factory {
        private static ClockSource create() {
            String string = System.getProperty("os.name");
            if ("Mac OS X".equals(string)) {
                return new MillisecondClockSource();
            }
            return new NanosecondClockSource();
        }
    }
}

