/*
 * Decompiled with CFR 0.152.
 */
package com.zaxxer.hikari.util;

import com.zaxxer.hikari.pool.ProxyCallableStatement;
import com.zaxxer.hikari.pool.ProxyConnection;
import com.zaxxer.hikari.pool.ProxyDatabaseMetaData;
import com.zaxxer.hikari.pool.ProxyPreparedStatement;
import com.zaxxer.hikari.pool.ProxyResultSet;
import com.zaxxer.hikari.pool.ProxyStatement;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.lang.reflect.Array;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import javassist.CannotCompileException;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javassist.LoaderClassPath;
import javassist.Modifier;
import javassist.NotFoundException;

public final class JavassistProxyFactory {
    private static ClassPool classPool;
    private static String genDirectory;

    public static void main(String ... stringArray) throws Exception {
        Object object;
        classPool = new ClassPool();
        classPool.importPackage("java.sql");
        classPool.appendClassPath((ClassPath)new LoaderClassPath(JavassistProxyFactory.class.getClassLoader()));
        if (stringArray.length > 0) {
            object = stringArray[0];
            if (!((String)object).endsWith(File.separator)) {
                object = (String)object + File.separator;
            }
            genDirectory = (String)object + genDirectory;
        }
        System.out.println("Generating following classes to " + genDirectory);
        object = "{ try { return delegate.method($$); } catch (SQLException e) { throw checkException(e); } }";
        JavassistProxyFactory.generateProxyClass(Connection.class, ProxyConnection.class.getName(), (String)object);
        JavassistProxyFactory.generateProxyClass(Statement.class, ProxyStatement.class.getName(), (String)object);
        JavassistProxyFactory.generateProxyClass(ResultSet.class, ProxyResultSet.class.getName(), (String)object);
        JavassistProxyFactory.generateProxyClass(DatabaseMetaData.class, ProxyDatabaseMetaData.class.getName(), (String)object);
        object = "{ try { return ((cast) delegate).method($$); } catch (SQLException e) { throw checkException(e); } }";
        JavassistProxyFactory.generateProxyClass(PreparedStatement.class, ProxyPreparedStatement.class.getName(), (String)object);
        JavassistProxyFactory.generateProxyClass(CallableStatement.class, ProxyCallableStatement.class.getName(), (String)object);
        JavassistProxyFactory.modifyProxyFactory();
    }

    private static void modifyProxyFactory() throws NotFoundException, CannotCompileException, IOException {
        System.out.println("Generating method bodies for com.zaxxer.hikari.proxy.ProxyFactory");
        String string = ProxyConnection.class.getPackage().getName();
        CtClass ctClass = classPool.getCtClass("com.zaxxer.hikari.pool.ProxyFactory");
        block16: for (CtMethod ctMethod : ctClass.getMethods()) {
            switch (ctMethod.getName()) {
                case "getProxyConnection": {
                    ctMethod.setBody("{return new " + string + ".HikariProxyConnection($$);}");
                    continue block16;
                }
                case "getProxyStatement": {
                    ctMethod.setBody("{return new " + string + ".HikariProxyStatement($$);}");
                    continue block16;
                }
                case "getProxyPreparedStatement": {
                    ctMethod.setBody("{return new " + string + ".HikariProxyPreparedStatement($$);}");
                    continue block16;
                }
                case "getProxyCallableStatement": {
                    ctMethod.setBody("{return new " + string + ".HikariProxyCallableStatement($$);}");
                    continue block16;
                }
                case "getProxyResultSet": {
                    ctMethod.setBody("{return new " + string + ".HikariProxyResultSet($$);}");
                    continue block16;
                }
                case "getProxyDatabaseMetaData": {
                    ctMethod.setBody("{return new " + string + ".HikariProxyDatabaseMetaData($$);}");
                    continue block16;
                }
            }
        }
        ctClass.writeFile(genDirectory);
    }

    private static <T> void generateProxyClass(Class<T> clazz, String string, String string2) throws Exception {
        String string3 = string.replaceAll("(.+)\\.(\\w+)", "$1.Hikari$2");
        CtClass ctClass = classPool.getCtClass(string);
        CtClass ctClass2 = classPool.makeClass(string3, ctClass);
        ctClass2.setModifiers(Modifier.setPublic((int)16));
        System.out.println("Generating " + string3);
        HashSet<CallSite> hashSet = new HashSet<CallSite>();
        for (CtMethod ctMethod : ctClass.getMethods()) {
            if ((ctMethod.getModifiers() & 0x10) != 16) continue;
            hashSet.add((CallSite)((Object)(ctMethod.getName() + ctMethod.getSignature())));
        }
        HashSet hashSet2 = new HashSet();
        for (Class<?> clazz2 : JavassistProxyFactory.getAllInterfaces(clazz)) {
            CtMethod ctMethod;
            ctMethod = classPool.getCtClass(clazz2.getName());
            ctClass2.addInterface((CtClass)ctMethod);
            for (CtMethod ctMethod2 : ctMethod.getDeclaredMethods()) {
                String string4 = ctMethod2.getName() + ctMethod2.getSignature();
                if (hashSet.contains(string4) || hashSet2.contains(string4)) continue;
                hashSet2.add(string4);
                CtMethod ctMethod3 = CtNewMethod.copy((CtMethod)ctMethod2, (CtClass)ctClass2, null);
                String string5 = string2;
                CtMethod ctMethod4 = ctClass.getMethod(ctMethod2.getName(), ctMethod2.getSignature());
                if ((ctMethod4.getModifiers() & 0x400) != 1024 && !JavassistProxyFactory.isDefaultMethod(clazz2, ctMethod2)) {
                    string5 = string5.replace("((cast) ", "");
                    string5 = string5.replace("delegate", "super");
                    string5 = string5.replace("super)", "super");
                }
                string5 = string5.replace("cast", clazz.getName());
                string5 = JavassistProxyFactory.isThrowsSqlException(ctMethod2) ? string5.replace("method", ctMethod3.getName()) : "{ return ((cast) delegate).method($$); }".replace("method", ctMethod3.getName()).replace("cast", clazz.getName());
                if (ctMethod3.getReturnType() == CtClass.voidType) {
                    string5 = string5.replace("return", "");
                }
                ctMethod3.setBody(string5);
                ctClass2.addMethod(ctMethod3);
            }
        }
        ctClass2.getClassFile().setMajorVersion(52);
        ctClass2.writeFile(genDirectory);
    }

    private static boolean isThrowsSqlException(CtMethod ctMethod) {
        try {
            for (CtClass ctClass : ctMethod.getExceptionTypes()) {
                if (!ctClass.getSimpleName().equals("SQLException")) continue;
                return true;
            }
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        return false;
    }

    private static boolean isDefaultMethod(Class<?> clazz, CtMethod ctMethod) throws Exception {
        ArrayList arrayList = new ArrayList();
        for (CtClass ctClass : ctMethod.getParameterTypes()) {
            arrayList.add(JavassistProxyFactory.toJavaClass(ctClass));
        }
        return clazz.getDeclaredMethod(ctMethod.getName(), arrayList.toArray(new Class[0])).toString().contains("default ");
    }

    private static Set<Class<?>> getAllInterfaces(Class<?> clazz) {
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        for (Class<?> clazz2 : clazz.getInterfaces()) {
            if (clazz2.getInterfaces().length > 0) {
                linkedHashSet.addAll(JavassistProxyFactory.getAllInterfaces(clazz2));
            }
            linkedHashSet.add(clazz2);
        }
        if (clazz.getSuperclass() != null) {
            linkedHashSet.addAll(JavassistProxyFactory.getAllInterfaces(clazz.getSuperclass()));
        }
        if (clazz.isInterface()) {
            linkedHashSet.add(clazz);
        }
        return linkedHashSet;
    }

    private static Class<?> toJavaClass(CtClass ctClass) throws Exception {
        if (ctClass.getName().endsWith("[]")) {
            return Array.newInstance(JavassistProxyFactory.toJavaClass(ctClass.getName().replace("[]", "")), 0).getClass();
        }
        return JavassistProxyFactory.toJavaClass(ctClass.getName());
    }

    private static Class<?> toJavaClass(String string) throws Exception {
        switch (string) {
            case "int": {
                return Integer.TYPE;
            }
            case "long": {
                return Long.TYPE;
            }
            case "short": {
                return Short.TYPE;
            }
            case "byte": {
                return Byte.TYPE;
            }
            case "float": {
                return Float.TYPE;
            }
            case "double": {
                return Double.TYPE;
            }
            case "boolean": {
                return Boolean.TYPE;
            }
            case "char": {
                return Character.TYPE;
            }
            case "void": {
                return Void.TYPE;
            }
        }
        return Class.forName(string);
    }

    static {
        genDirectory = "target" + File.separator + "classes";
    }
}

