/*
 * Decompiled with CFR 0.152.
 */
package com.zaxxer.hikari.util;

import com.zaxxer.hikari.HikariConfig;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PropertyElf {
    private static final char ESCAPE_CHAR = '\\';
    private static final char SEPARATOR_CHAR = ',';
    private static final Pattern DURATION_PATTERN = Pattern.compile("^(?<number>\\d+)(?<unit>ms|s|m|h|d)$");

    private PropertyElf() {
    }

    public static void setTargetFromProperties(Object object, Properties properties) {
        if (object == null || properties == null) {
            return;
        }
        List<Method> list = Arrays.asList(object.getClass().getMethods());
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(object2, object3) -> {
            String string = object2.toString();
            if (object instanceof HikariConfig && string.startsWith("dataSource.")) {
                ((HikariConfig)object).addDataSourceProperty(string.substring("dataSource.".length()), object3);
            } else {
                PropertyElf.setProperty(object, string, object3, list);
            }
        }));
    }

    public static Set<String> getPropertyNames(Class<?> clazz) {
        HashSet<String> hashSet = new HashSet<String>();
        for (Method method : clazz.getMethods()) {
            String string = PropertyElf.propertyNameFromGetterName(method.getName());
            try {
                if (method.getParameterTypes().length != 0 || string == null) continue;
                clazz.getMethod("set" + PropertyElf.capitalizedPropertyName(string), method.getReturnType());
                hashSet.add(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return hashSet;
    }

    public static Object getProperty(String string, Object object) {
        try {
            String string2 = "get" + PropertyElf.capitalizedPropertyName(string);
            Method method = object.getClass().getMethod(string2, new Class[0]);
            return method.invoke(object, new Object[0]);
        }
        catch (Exception exception) {
            try {
                String string3 = "is" + PropertyElf.capitalizedPropertyName(string);
                Method method = object.getClass().getMethod(string3, new Class[0]);
                return method.invoke(object, new Object[0]);
            }
            catch (Exception exception2) {
                return null;
            }
        }
    }

    public static Properties copyProperties(Properties properties) {
        Properties properties2 = new Properties();
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(object, object2) -> properties2.setProperty(object.toString(), object2.toString())));
        return properties2;
    }

    private static String propertyNameFromGetterName(String string) {
        String string2 = null;
        if (string.startsWith("get") && string.length() > 3) {
            string2 = string.substring(3);
        } else if (string.startsWith("is") && string.length() > 2) {
            string2 = string.substring(2);
        }
        if (string2 != null) {
            return Character.toLowerCase(string2.charAt(0)) + string2.substring(1);
        }
        return null;
    }

    private static void setProperty(Object object, String string, Object object2, List<Method> list) {
        Object object3;
        Logger logger = LoggerFactory.getLogger(PropertyElf.class);
        String string2 = "set" + string.substring(0, 1).toUpperCase(Locale.ENGLISH) + string.substring(1);
        Method method2 = list.stream().filter(method -> method.getName().equals(string2) && method.getParameterCount() == 1).findFirst().orElse(null);
        if (method2 == null) {
            object3 = "set" + string.toUpperCase(Locale.ENGLISH);
            method2 = list.stream().filter(arg_0 -> PropertyElf.lambda$setProperty$3((String)object3, arg_0)).findFirst().orElse(null);
        }
        if (method2 == null) {
            logger.error("Property {} does not exist on target {}", (Object)string, (Object)object.getClass());
            throw new RuntimeException(String.format("Property %s does not exist on target %s", string, object.getClass()));
        }
        try {
            object3 = method2.getParameterTypes()[0];
            String string3 = object2.toString();
            if (object3 == Integer.TYPE) {
                method2.invoke(object, Integer.parseInt(object2.toString()));
            } else if (object3 == Long.TYPE) {
                method2.invoke(object, PropertyElf.parseDuration(string3).map(Duration::toMillis).orElseGet(() -> Long.parseLong(string3)));
            } else if (object3 == Short.TYPE) {
                method2.invoke(object, Short.parseShort(string3));
            } else if (object3 == Boolean.TYPE || object3 == Boolean.class) {
                method2.invoke(object, Boolean.parseBoolean(string3));
            } else if (((Class)object3).isArray() && Character.TYPE.isAssignableFrom(((Class)object3).getComponentType())) {
                method2.invoke(object, new Object[]{string3.toCharArray()});
            } else if (((Class)object3).isArray() && Integer.TYPE.isAssignableFrom(((Class)object3).getComponentType())) {
                method2.invoke(object, new Object[]{PropertyElf.parseIntArray(string3)});
            } else if (((Class)object3).isArray() && String.class.isAssignableFrom(((Class)object3).getComponentType())) {
                method2.invoke(object, new Object[]{PropertyElf.parseStringArray(string3)});
            } else if (object3 == String.class) {
                method2.invoke(object, string3);
            } else {
                try {
                    logger.debug("Try to create a new instance of \"{}\"", object2);
                    method2.invoke(object, Class.forName(object2.toString()).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                }
                catch (ClassNotFoundException | InstantiationException reflectiveOperationException) {
                    logger.debug("Class \"{}\" not found or could not instantiate it (Default constructor)", object2);
                    method2.invoke(object, object2);
                }
            }
        }
        catch (Exception exception) {
            logger.error("Failed to set property {} on target {}", string, object.getClass(), exception);
            throw new RuntimeException(exception);
        }
    }

    private static String capitalizedPropertyName(String string) {
        return string.substring(0, 1).toUpperCase(Locale.ENGLISH) + string.substring(1);
    }

    private static int[] parseIntArray(String string) {
        if (string == null || string.isEmpty()) {
            return new int[0];
        }
        String[] stringArray = string.split(",");
        int[] nArray = new int[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            nArray[i] = Integer.parseInt(stringArray[i]);
        }
        return nArray;
    }

    private static String[] parseStringArray(String string) {
        if (string == null || string.isEmpty()) {
            return new String[0];
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder();
        for (char c : string.toCharArray()) {
            if (bl) {
                stringBuilder.append(c);
                bl = false;
                continue;
            }
            if (c == '\\') {
                bl = true;
                continue;
            }
            if (c == ',') {
                arrayList.add(stringBuilder.toString());
                stringBuilder.setLength(0);
                continue;
            }
            stringBuilder.append(c);
        }
        if (bl) {
            throw new IllegalArgumentException(String.format("Unterminated escape sequence in property value: %s", string));
        }
        arrayList.add(stringBuilder.toString());
        return arrayList.toArray(new String[0]);
    }

    private static Optional<Duration> parseDuration(String string) {
        Matcher matcher = DURATION_PATTERN.matcher(string);
        if (matcher.matches()) {
            String string2;
            long l = Long.parseLong(matcher.group("number"));
            switch (string2 = matcher.group("unit")) {
                case "ms": {
                    return Optional.of(Duration.ofMillis(l));
                }
                case "s": {
                    return Optional.of(Duration.ofSeconds(l));
                }
                case "m": {
                    return Optional.of(Duration.ofMinutes(l));
                }
                case "h": {
                    return Optional.of(Duration.ofHours(l));
                }
                case "d": {
                    return Optional.of(Duration.ofDays(l));
                }
            }
            throw new IllegalStateException(String.format("Could not match unit, got %s (from given value %s)", string2, string));
        }
        return Optional.empty();
    }

    private static /* synthetic */ boolean lambda$setProperty$3(String string, Method method) {
        return method.getName().equals(string) && method.getParameterCount() == 1;
    }
}

