/*
 * Decompiled with CFR 0.152.
 */
package com.zaxxer.hikari.util;

import com.zaxxer.hikari.util.IsolationLevel;
import java.lang.reflect.Constructor;
import java.util.Locale;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;

public final class UtilityElf {
    private static final Pattern PASSWORD_MASKING_PATTERN = Pattern.compile("([?&;][^&#;=]*[pP]assword=)[^&#;]*");

    private UtilityElf() {
    }

    public static String maskPasswordInJdbcUrl(String string) {
        return PASSWORD_MASKING_PATTERN.matcher(string).replaceAll("$1<masked>");
    }

    public static String getNullIfEmpty(String string) {
        return string == null ? null : (string.trim().isEmpty() ? null : string.trim());
    }

    public static void quietlySleep(long l) {
        try {
            Thread.sleep(l);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    public static boolean safeIsAssignableFrom(Object object, String string) {
        try {
            Class<?> clazz = Class.forName(string);
            return clazz.isAssignableFrom(object.getClass());
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    public static <T> T createInstance(String string, Class<T> clazz, Object ... objectArray) {
        if (string == null) {
            return null;
        }
        try {
            Class<?> clazz2 = UtilityElf.class.getClassLoader().loadClass(string);
            int n = objectArray.length;
            if (n == 0) {
                return clazz.cast(clazz2.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
            Class[] classArray = new Class[n];
            for (int i = 0; i < n; ++i) {
                classArray[i] = objectArray[i].getClass();
            }
            Constructor<?> constructor = clazz2.getConstructor(classArray);
            return clazz.cast(constructor.newInstance(objectArray));
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static ThreadPoolExecutor createThreadPoolExecutor(int n, String string, ThreadFactory threadFactory, RejectedExecutionHandler rejectedExecutionHandler) {
        return UtilityElf.createThreadPoolExecutor(new LinkedBlockingQueue<Runnable>(n), string, threadFactory, rejectedExecutionHandler);
    }

    public static ThreadPoolExecutor createThreadPoolExecutor(BlockingQueue<Runnable> blockingQueue, String string, ThreadFactory threadFactory, RejectedExecutionHandler rejectedExecutionHandler) {
        if (threadFactory == null) {
            threadFactory = new DefaultThreadFactory(string);
        }
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(1, 1, 5L, TimeUnit.SECONDS, blockingQueue, threadFactory, rejectedExecutionHandler);
        threadPoolExecutor.allowCoreThreadTimeOut(true);
        return threadPoolExecutor;
    }

    public static int getTransactionIsolation(String string) {
        if (string != null) {
            try {
                String string2 = string.toUpperCase(Locale.ENGLISH);
                return IsolationLevel.valueOf(string2).getLevelId();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                try {
                    int n = Integer.parseInt(string);
                    for (IsolationLevel isolationLevel : IsolationLevel.values()) {
                        if (isolationLevel.getLevelId() != n) continue;
                        return isolationLevel.getLevelId();
                    }
                    throw new IllegalArgumentException("Invalid transaction isolation value: " + string);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException("Invalid transaction isolation value: " + string, numberFormatException);
                }
            }
        }
        return -1;
    }

    public static final class DefaultThreadFactory
    implements ThreadFactory {
        private final String threadName;
        private final boolean daemon;

        public DefaultThreadFactory(String string) {
            this.threadName = string;
            this.daemon = true;
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(runnable, this.threadName);
            thread.setDaemon(this.daemon);
            return thread;
        }
    }

    public static class CustomDiscardPolicy
    implements RejectedExecutionHandler {
        @Override
        public void rejectedExecution(Runnable runnable, ThreadPoolExecutor threadPoolExecutor) {
        }
    }
}

