/*
 * Decompiled with CFR 0.152.
 */
package org.bson;

import java.io.Closeable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.bson.BsonArray;
import org.bson.BsonBinary;
import org.bson.BsonContextType;
import org.bson.BsonDbPointer;
import org.bson.BsonDocument;
import org.bson.BsonElement;
import org.bson.BsonInvalidOperationException;
import org.bson.BsonJavaScriptWithScope;
import org.bson.BsonReader;
import org.bson.BsonRegularExpression;
import org.bson.BsonSerializationException;
import org.bson.BsonTimestamp;
import org.bson.BsonType;
import org.bson.BsonValue;
import org.bson.BsonWriter;
import org.bson.BsonWriterSettings;
import org.bson.FieldNameValidator;
import org.bson.NoOpFieldNameValidator;
import org.bson.StringUtils;
import org.bson.assertions.Assertions;
import org.bson.types.Decimal128;
import org.bson.types.ObjectId;

public abstract class AbstractBsonWriter
implements BsonWriter,
Closeable {
    private final BsonWriterSettings settings;
    private final Stack<FieldNameValidator> fieldNameValidatorStack = new Stack();
    private State state;
    private Context context;
    private int serializationDepth;
    private boolean closed;

    protected AbstractBsonWriter(BsonWriterSettings bsonWriterSettings) {
        this(bsonWriterSettings, NoOpFieldNameValidator.INSTANCE);
    }

    protected AbstractBsonWriter(BsonWriterSettings bsonWriterSettings, FieldNameValidator fieldNameValidator) {
        if (fieldNameValidator == null) {
            throw new IllegalArgumentException("Validator can not be null");
        }
        this.settings = bsonWriterSettings;
        this.fieldNameValidatorStack.push(fieldNameValidator);
        this.state = State.INITIAL;
    }

    protected String getName() {
        return this.context.name;
    }

    protected boolean isClosed() {
        return this.closed;
    }

    protected void setState(State state) {
        this.state = state;
    }

    protected State getState() {
        return this.state;
    }

    protected Context getContext() {
        return this.context;
    }

    protected void setContext(Context context) {
        this.context = context;
    }

    protected abstract void doWriteStartDocument();

    protected abstract void doWriteEndDocument();

    protected abstract void doWriteStartArray();

    protected abstract void doWriteEndArray();

    protected abstract void doWriteBinaryData(BsonBinary var1);

    protected abstract void doWriteBoolean(boolean var1);

    protected abstract void doWriteDateTime(long var1);

    protected abstract void doWriteDBPointer(BsonDbPointer var1);

    protected abstract void doWriteDouble(double var1);

    protected abstract void doWriteInt32(int var1);

    protected abstract void doWriteInt64(long var1);

    protected abstract void doWriteDecimal128(Decimal128 var1);

    protected abstract void doWriteJavaScript(String var1);

    protected abstract void doWriteJavaScriptWithScope(String var1);

    protected abstract void doWriteMaxKey();

    protected abstract void doWriteMinKey();

    protected abstract void doWriteNull();

    protected abstract void doWriteObjectId(ObjectId var1);

    protected abstract void doWriteRegularExpression(BsonRegularExpression var1);

    protected abstract void doWriteString(String var1);

    protected abstract void doWriteSymbol(String var1);

    protected abstract void doWriteTimestamp(BsonTimestamp var1);

    protected abstract void doWriteUndefined();

    @Override
    public void writeStartDocument(String string) {
        this.writeName(string);
        this.writeStartDocument();
    }

    @Override
    public void writeStartDocument() {
        this.checkPreconditions("writeStartDocument", State.INITIAL, State.VALUE, State.SCOPE_DOCUMENT, State.DONE);
        if (this.context != null && this.context.name != null) {
            FieldNameValidator fieldNameValidator = this.fieldNameValidatorStack.peek().getValidatorForField(this.getName());
            this.fieldNameValidatorStack.push(fieldNameValidator);
            fieldNameValidator.start();
        }
        ++this.serializationDepth;
        if (this.serializationDepth > this.settings.getMaxSerializationDepth()) {
            throw new BsonSerializationException("Maximum serialization depth exceeded (does the object being serialized have a circular reference?).");
        }
        this.doWriteStartDocument();
        this.setState(State.NAME);
    }

    @Override
    public void writeEndDocument() {
        this.checkPreconditions("writeEndDocument", State.NAME);
        BsonContextType bsonContextType = this.getContext().getContextType();
        if (bsonContextType != BsonContextType.DOCUMENT && bsonContextType != BsonContextType.SCOPE_DOCUMENT) {
            this.throwInvalidContextType("WriteEndDocument", bsonContextType, BsonContextType.DOCUMENT, BsonContextType.SCOPE_DOCUMENT);
        }
        if (this.context.getParentContext() != null && this.context.getParentContext().name != null) {
            this.fieldNameValidatorStack.pop().end();
        }
        --this.serializationDepth;
        this.doWriteEndDocument();
        if (this.getContext() == null || this.getContext().getContextType() == BsonContextType.TOP_LEVEL) {
            this.setState(State.DONE);
        } else {
            this.setState(this.getNextState());
        }
    }

    @Override
    public void writeStartArray(String string) {
        this.writeName(string);
        this.writeStartArray();
    }

    @Override
    public void writeStartArray() {
        this.checkPreconditions("writeStartArray", State.VALUE);
        if (this.context != null && this.context.name != null) {
            this.fieldNameValidatorStack.push(this.fieldNameValidatorStack.peek().getValidatorForField(this.getName()));
        }
        ++this.serializationDepth;
        if (this.serializationDepth > this.settings.getMaxSerializationDepth()) {
            throw new BsonSerializationException("Maximum serialization depth exceeded (does the object being serialized have a circular reference?).");
        }
        this.doWriteStartArray();
        this.setState(State.VALUE);
    }

    @Override
    public void writeEndArray() {
        this.checkPreconditions("writeEndArray", State.VALUE);
        if (this.getContext().getContextType() != BsonContextType.ARRAY) {
            this.throwInvalidContextType("WriteEndArray", this.getContext().getContextType(), BsonContextType.ARRAY);
        }
        if (this.context.getParentContext() != null && this.context.getParentContext().name != null) {
            this.fieldNameValidatorStack.pop();
        }
        --this.serializationDepth;
        this.doWriteEndArray();
        this.setState(this.getNextState());
    }

    @Override
    public void writeBinaryData(String string, BsonBinary bsonBinary) {
        Assertions.notNull("name", string);
        Assertions.notNull("value", bsonBinary);
        this.writeName(string);
        this.writeBinaryData(bsonBinary);
    }

    @Override
    public void writeBinaryData(BsonBinary bsonBinary) {
        Assertions.notNull("value", bsonBinary);
        this.checkPreconditions("writeBinaryData", State.VALUE, State.INITIAL);
        this.doWriteBinaryData(bsonBinary);
        this.setState(this.getNextState());
    }

    @Override
    public void writeBoolean(String string, boolean bl) {
        this.writeName(string);
        this.writeBoolean(bl);
    }

    @Override
    public void writeBoolean(boolean bl) {
        this.checkPreconditions("writeBoolean", State.VALUE, State.INITIAL);
        this.doWriteBoolean(bl);
        this.setState(this.getNextState());
    }

    @Override
    public void writeDateTime(String string, long l) {
        this.writeName(string);
        this.writeDateTime(l);
    }

    @Override
    public void writeDateTime(long l) {
        this.checkPreconditions("writeDateTime", State.VALUE, State.INITIAL);
        this.doWriteDateTime(l);
        this.setState(this.getNextState());
    }

    @Override
    public void writeDBPointer(String string, BsonDbPointer bsonDbPointer) {
        Assertions.notNull("name", string);
        Assertions.notNull("value", bsonDbPointer);
        this.writeName(string);
        this.writeDBPointer(bsonDbPointer);
    }

    @Override
    public void writeDBPointer(BsonDbPointer bsonDbPointer) {
        Assertions.notNull("value", bsonDbPointer);
        this.checkPreconditions("writeDBPointer", State.VALUE, State.INITIAL);
        this.doWriteDBPointer(bsonDbPointer);
        this.setState(this.getNextState());
    }

    @Override
    public void writeDouble(String string, double d) {
        this.writeName(string);
        this.writeDouble(d);
    }

    @Override
    public void writeDouble(double d) {
        this.checkPreconditions("writeDBPointer", State.VALUE, State.INITIAL);
        this.doWriteDouble(d);
        this.setState(this.getNextState());
    }

    @Override
    public void writeInt32(String string, int n) {
        this.writeName(string);
        this.writeInt32(n);
    }

    @Override
    public void writeInt32(int n) {
        this.checkPreconditions("writeInt32", State.VALUE);
        this.doWriteInt32(n);
        this.setState(this.getNextState());
    }

    @Override
    public void writeInt64(String string, long l) {
        this.writeName(string);
        this.writeInt64(l);
    }

    @Override
    public void writeInt64(long l) {
        this.checkPreconditions("writeInt64", State.VALUE);
        this.doWriteInt64(l);
        this.setState(this.getNextState());
    }

    @Override
    public void writeDecimal128(Decimal128 decimal128) {
        Assertions.notNull("value", decimal128);
        this.checkPreconditions("writeInt64", State.VALUE);
        this.doWriteDecimal128(decimal128);
        this.setState(this.getNextState());
    }

    @Override
    public void writeDecimal128(String string, Decimal128 decimal128) {
        Assertions.notNull("name", string);
        Assertions.notNull("value", decimal128);
        this.writeName(string);
        this.writeDecimal128(decimal128);
    }

    @Override
    public void writeJavaScript(String string, String string2) {
        Assertions.notNull("name", string);
        Assertions.notNull("value", string2);
        this.writeName(string);
        this.writeJavaScript(string2);
    }

    @Override
    public void writeJavaScript(String string) {
        Assertions.notNull("value", string);
        this.checkPreconditions("writeJavaScript", State.VALUE);
        this.doWriteJavaScript(string);
        this.setState(this.getNextState());
    }

    @Override
    public void writeJavaScriptWithScope(String string, String string2) {
        Assertions.notNull("name", string);
        Assertions.notNull("value", string2);
        this.writeName(string);
        this.writeJavaScriptWithScope(string2);
    }

    @Override
    public void writeJavaScriptWithScope(String string) {
        Assertions.notNull("value", string);
        this.checkPreconditions("writeJavaScriptWithScope", State.VALUE);
        this.doWriteJavaScriptWithScope(string);
        this.setState(State.SCOPE_DOCUMENT);
    }

    @Override
    public void writeMaxKey(String string) {
        this.writeName(string);
        this.writeMaxKey();
    }

    @Override
    public void writeMaxKey() {
        this.checkPreconditions("writeMaxKey", State.VALUE);
        this.doWriteMaxKey();
        this.setState(this.getNextState());
    }

    @Override
    public void writeMinKey(String string) {
        this.writeName(string);
        this.writeMinKey();
    }

    @Override
    public void writeMinKey() {
        this.checkPreconditions("writeMinKey", State.VALUE);
        this.doWriteMinKey();
        this.setState(this.getNextState());
    }

    @Override
    public void writeName(String string) {
        FieldNameValidator fieldNameValidator;
        Assertions.notNull("name", string);
        if (this.state != State.NAME) {
            this.throwInvalidState("WriteName", State.NAME);
        }
        if (!(fieldNameValidator = this.fieldNameValidatorStack.peek()).validate(string)) {
            throw new IllegalArgumentException(fieldNameValidator.getValidationErrorMessage(string));
        }
        this.doWriteName(string);
        this.context.name = string;
        this.state = State.VALUE;
    }

    protected void doWriteName(String string) {
    }

    @Override
    public void writeNull(String string) {
        this.writeName(string);
        this.writeNull();
    }

    @Override
    public void writeNull() {
        this.checkPreconditions("writeNull", State.VALUE);
        this.doWriteNull();
        this.setState(this.getNextState());
    }

    @Override
    public void writeObjectId(String string, ObjectId objectId) {
        Assertions.notNull("name", string);
        Assertions.notNull("value", objectId);
        this.writeName(string);
        this.writeObjectId(objectId);
    }

    @Override
    public void writeObjectId(ObjectId objectId) {
        Assertions.notNull("value", objectId);
        this.checkPreconditions("writeObjectId", State.VALUE);
        this.doWriteObjectId(objectId);
        this.setState(this.getNextState());
    }

    @Override
    public void writeRegularExpression(String string, BsonRegularExpression bsonRegularExpression) {
        Assertions.notNull("name", string);
        Assertions.notNull("value", bsonRegularExpression);
        this.writeName(string);
        this.writeRegularExpression(bsonRegularExpression);
    }

    @Override
    public void writeRegularExpression(BsonRegularExpression bsonRegularExpression) {
        Assertions.notNull("value", bsonRegularExpression);
        this.checkPreconditions("writeRegularExpression", State.VALUE);
        this.doWriteRegularExpression(bsonRegularExpression);
        this.setState(this.getNextState());
    }

    @Override
    public void writeString(String string, String string2) {
        Assertions.notNull("name", string);
        Assertions.notNull("value", string2);
        this.writeName(string);
        this.writeString(string2);
    }

    @Override
    public void writeString(String string) {
        Assertions.notNull("value", string);
        this.checkPreconditions("writeString", State.VALUE);
        this.doWriteString(string);
        this.setState(this.getNextState());
    }

    @Override
    public void writeSymbol(String string, String string2) {
        Assertions.notNull("name", string);
        Assertions.notNull("value", string2);
        this.writeName(string);
        this.writeSymbol(string2);
    }

    @Override
    public void writeSymbol(String string) {
        Assertions.notNull("value", string);
        this.checkPreconditions("writeSymbol", State.VALUE);
        this.doWriteSymbol(string);
        this.setState(this.getNextState());
    }

    @Override
    public void writeTimestamp(String string, BsonTimestamp bsonTimestamp) {
        Assertions.notNull("name", string);
        Assertions.notNull("value", bsonTimestamp);
        this.writeName(string);
        this.writeTimestamp(bsonTimestamp);
    }

    @Override
    public void writeTimestamp(BsonTimestamp bsonTimestamp) {
        Assertions.notNull("value", bsonTimestamp);
        this.checkPreconditions("writeTimestamp", State.VALUE);
        this.doWriteTimestamp(bsonTimestamp);
        this.setState(this.getNextState());
    }

    @Override
    public void writeUndefined(String string) {
        this.writeName(string);
        this.writeUndefined();
    }

    @Override
    public void writeUndefined() {
        this.checkPreconditions("writeUndefined", State.VALUE);
        this.doWriteUndefined();
        this.setState(this.getNextState());
    }

    protected State getNextState() {
        if (this.getContext().getContextType() == BsonContextType.ARRAY) {
            return State.VALUE;
        }
        return State.NAME;
    }

    protected boolean checkState(State[] stateArray) {
        for (State state : stateArray) {
            if (state != this.getState()) continue;
            return true;
        }
        return false;
    }

    protected void checkPreconditions(String string, State ... stateArray) {
        if (this.isClosed()) {
            throw new IllegalStateException("BsonWriter is closed");
        }
        if (!this.checkState(stateArray)) {
            this.throwInvalidState(string, stateArray);
        }
    }

    protected void throwInvalidContextType(String string, BsonContextType bsonContextType, BsonContextType ... bsonContextTypeArray) {
        String string2 = StringUtils.join(" or ", bsonContextTypeArray);
        throw new BsonInvalidOperationException(String.format("%s can only be called when ContextType is %s, not when ContextType is %s.", new Object[]{string, string2, bsonContextType}));
    }

    protected void throwInvalidState(String string, State ... stateArray) {
        if (!(this.state != State.INITIAL && this.state != State.SCOPE_DOCUMENT && this.state != State.DONE || string.startsWith("end") || string.equals("writeName"))) {
            String string2 = string.substring(5);
            if (string2.startsWith("start")) {
                string2 = string2.substring(5);
            }
            String string3 = "A";
            if (Arrays.asList(Character.valueOf('A'), Character.valueOf('E'), Character.valueOf('I'), Character.valueOf('O'), Character.valueOf('U')).contains(Character.valueOf(string2.charAt(0)))) {
                string3 = "An";
            }
            throw new BsonInvalidOperationException(String.format("%s %s value cannot be written to the root level of a BSON document.", string3, string2));
        }
        String string4 = StringUtils.join(" or ", stateArray);
        throw new BsonInvalidOperationException(String.format("%s can only be called when State is %s, not when State is %s", new Object[]{string, string4, this.state}));
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
        this.closed = true;
    }

    @Override
    public void pipe(BsonReader bsonReader) {
        Assertions.notNull("reader", bsonReader);
        this.pipeDocument(bsonReader, null);
    }

    public void pipe(BsonReader bsonReader, List<BsonElement> list) {
        Assertions.notNull("reader", bsonReader);
        Assertions.notNull("extraElements", list);
        this.pipeDocument(bsonReader, list);
    }

    protected void pipeExtraElements(List<BsonElement> list) {
        Assertions.notNull("extraElements", list);
        for (BsonElement bsonElement : list) {
            this.writeName(bsonElement.getName());
            this.pipeValue(bsonElement.getValue());
        }
    }

    protected boolean abortPipe() {
        return false;
    }

    private void pipeDocument(BsonReader bsonReader, List<BsonElement> list) {
        bsonReader.readStartDocument();
        this.writeStartDocument();
        while (bsonReader.readBsonType() != BsonType.END_OF_DOCUMENT) {
            this.writeName(bsonReader.readName());
            this.pipeValue(bsonReader);
            if (!this.abortPipe()) continue;
            return;
        }
        bsonReader.readEndDocument();
        if (list != null) {
            this.pipeExtraElements(list);
        }
        this.writeEndDocument();
    }

    private void pipeJavascriptWithScope(BsonReader bsonReader) {
        this.writeJavaScriptWithScope(bsonReader.readJavaScriptWithScope());
        this.pipeDocument(bsonReader, null);
    }

    private void pipeValue(BsonReader bsonReader) {
        switch (bsonReader.getCurrentBsonType()) {
            case DOCUMENT: {
                this.pipeDocument(bsonReader, null);
                break;
            }
            case ARRAY: {
                this.pipeArray(bsonReader);
                break;
            }
            case DOUBLE: {
                this.writeDouble(bsonReader.readDouble());
                break;
            }
            case STRING: {
                this.writeString(bsonReader.readString());
                break;
            }
            case BINARY: {
                this.writeBinaryData(bsonReader.readBinaryData());
                break;
            }
            case UNDEFINED: {
                bsonReader.readUndefined();
                this.writeUndefined();
                break;
            }
            case OBJECT_ID: {
                this.writeObjectId(bsonReader.readObjectId());
                break;
            }
            case BOOLEAN: {
                this.writeBoolean(bsonReader.readBoolean());
                break;
            }
            case DATE_TIME: {
                this.writeDateTime(bsonReader.readDateTime());
                break;
            }
            case NULL: {
                bsonReader.readNull();
                this.writeNull();
                break;
            }
            case REGULAR_EXPRESSION: {
                this.writeRegularExpression(bsonReader.readRegularExpression());
                break;
            }
            case JAVASCRIPT: {
                this.writeJavaScript(bsonReader.readJavaScript());
                break;
            }
            case SYMBOL: {
                this.writeSymbol(bsonReader.readSymbol());
                break;
            }
            case JAVASCRIPT_WITH_SCOPE: {
                this.pipeJavascriptWithScope(bsonReader);
                break;
            }
            case INT32: {
                this.writeInt32(bsonReader.readInt32());
                break;
            }
            case TIMESTAMP: {
                this.writeTimestamp(bsonReader.readTimestamp());
                break;
            }
            case INT64: {
                this.writeInt64(bsonReader.readInt64());
                break;
            }
            case DECIMAL128: {
                this.writeDecimal128(bsonReader.readDecimal128());
                break;
            }
            case MIN_KEY: {
                bsonReader.readMinKey();
                this.writeMinKey();
                break;
            }
            case DB_POINTER: {
                this.writeDBPointer(bsonReader.readDBPointer());
                break;
            }
            case MAX_KEY: {
                bsonReader.readMaxKey();
                this.writeMaxKey();
                break;
            }
            default: {
                throw new IllegalArgumentException("unhandled BSON type: " + (Object)((Object)bsonReader.getCurrentBsonType()));
            }
        }
    }

    private void pipeDocument(BsonDocument bsonDocument) {
        this.writeStartDocument();
        for (Map.Entry<String, BsonValue> entry : bsonDocument.entrySet()) {
            this.writeName(entry.getKey());
            this.pipeValue(entry.getValue());
        }
        this.writeEndDocument();
    }

    private void pipeArray(BsonReader bsonReader) {
        bsonReader.readStartArray();
        this.writeStartArray();
        while (bsonReader.readBsonType() != BsonType.END_OF_DOCUMENT) {
            this.pipeValue(bsonReader);
            if (!this.abortPipe()) continue;
            return;
        }
        bsonReader.readEndArray();
        this.writeEndArray();
    }

    private void pipeArray(BsonArray bsonArray) {
        this.writeStartArray();
        for (BsonValue bsonValue : bsonArray) {
            this.pipeValue(bsonValue);
        }
        this.writeEndArray();
    }

    private void pipeJavascriptWithScope(BsonJavaScriptWithScope bsonJavaScriptWithScope) {
        this.writeJavaScriptWithScope(bsonJavaScriptWithScope.getCode());
        this.pipeDocument(bsonJavaScriptWithScope.getScope());
    }

    private void pipeValue(BsonValue bsonValue) {
        switch (bsonValue.getBsonType()) {
            case DOCUMENT: {
                this.pipeDocument(bsonValue.asDocument());
                break;
            }
            case ARRAY: {
                this.pipeArray(bsonValue.asArray());
                break;
            }
            case DOUBLE: {
                this.writeDouble(bsonValue.asDouble().getValue());
                break;
            }
            case STRING: {
                this.writeString(bsonValue.asString().getValue());
                break;
            }
            case BINARY: {
                this.writeBinaryData(bsonValue.asBinary());
                break;
            }
            case UNDEFINED: {
                this.writeUndefined();
                break;
            }
            case OBJECT_ID: {
                this.writeObjectId(bsonValue.asObjectId().getValue());
                break;
            }
            case BOOLEAN: {
                this.writeBoolean(bsonValue.asBoolean().getValue());
                break;
            }
            case DATE_TIME: {
                this.writeDateTime(bsonValue.asDateTime().getValue());
                break;
            }
            case NULL: {
                this.writeNull();
                break;
            }
            case REGULAR_EXPRESSION: {
                this.writeRegularExpression(bsonValue.asRegularExpression());
                break;
            }
            case JAVASCRIPT: {
                this.writeJavaScript(bsonValue.asJavaScript().getCode());
                break;
            }
            case SYMBOL: {
                this.writeSymbol(bsonValue.asSymbol().getSymbol());
                break;
            }
            case JAVASCRIPT_WITH_SCOPE: {
                this.pipeJavascriptWithScope(bsonValue.asJavaScriptWithScope());
                break;
            }
            case INT32: {
                this.writeInt32(bsonValue.asInt32().getValue());
                break;
            }
            case TIMESTAMP: {
                this.writeTimestamp(bsonValue.asTimestamp());
                break;
            }
            case INT64: {
                this.writeInt64(bsonValue.asInt64().getValue());
                break;
            }
            case DECIMAL128: {
                this.writeDecimal128(bsonValue.asDecimal128().getValue());
                break;
            }
            case MIN_KEY: {
                this.writeMinKey();
                break;
            }
            case DB_POINTER: {
                this.writeDBPointer(bsonValue.asDBPointer());
                break;
            }
            case MAX_KEY: {
                this.writeMaxKey();
                break;
            }
            default: {
                throw new IllegalArgumentException("unhandled BSON type: " + (Object)((Object)bsonValue.getBsonType()));
            }
        }
    }

    public static enum State {
        INITIAL,
        NAME,
        VALUE,
        SCOPE_DOCUMENT,
        DONE,
        CLOSED;

    }

    public class Context {
        private final Context parentContext;
        private final BsonContextType contextType;
        private String name;

        public Context(Context context) {
            this.parentContext = context.parentContext;
            this.contextType = context.contextType;
        }

        public Context(Context context, BsonContextType bsonContextType) {
            this.parentContext = context;
            this.contextType = bsonContextType;
        }

        public Context getParentContext() {
            return this.parentContext;
        }

        public BsonContextType getContextType() {
            return this.contextType;
        }

        public Context copy() {
            return new Context(this);
        }
    }

    protected class Mark {
        private final Context markedContext;
        private final State markedState;
        private final String currentName;
        private final int serializationDepth;

        protected Mark() {
            this.markedContext = AbstractBsonWriter.this.context.copy();
            this.markedState = AbstractBsonWriter.this.state;
            this.currentName = AbstractBsonWriter.this.context.name;
            this.serializationDepth = AbstractBsonWriter.this.serializationDepth;
        }

        protected void reset() {
            AbstractBsonWriter.this.setContext(this.markedContext);
            AbstractBsonWriter.this.setState(this.markedState);
            AbstractBsonWriter.this.context.name = this.currentName;
            AbstractBsonWriter.this.serializationDepth = this.serializationDepth;
        }
    }
}

