/*
 * Decompiled with CFR 0.152.
 */
package org.bson;

class BSON {
    static final byte B_GENERAL = 0;
    static final byte B_BINARY = 2;
    private static final int FLAG_GLOBAL = 256;
    private static final int[] FLAG_LOOKUP = new int[65535];

    BSON() {
    }

    static int regexFlags(String string) {
        int n = 0;
        if (string == null) {
            return n;
        }
        for (char c : string.toLowerCase().toCharArray()) {
            n |= BSON.regexFlag(c);
        }
        return n;
    }

    private static int regexFlag(char c) {
        int n = FLAG_LOOKUP[c];
        if (n == 0) {
            throw new IllegalArgumentException(String.format("Unrecognized flag [%c]", Character.valueOf(c)));
        }
        return n;
    }

    static String regexFlags(int n) {
        int n2 = n;
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < FLAG_LOOKUP.length; ++i) {
            if ((n2 & FLAG_LOOKUP[i]) <= 0) continue;
            stringBuilder.append((char)i);
            n2 -= FLAG_LOOKUP[i];
        }
        if (n2 > 0) {
            throw new IllegalArgumentException("Some flags could not be recognized.");
        }
        return stringBuilder.toString();
    }

    static {
        BSON.FLAG_LOOKUP[103] = 256;
        BSON.FLAG_LOOKUP[105] = 2;
        BSON.FLAG_LOOKUP[109] = 8;
        BSON.FLAG_LOOKUP[115] = 32;
        BSON.FLAG_LOOKUP[99] = 128;
        BSON.FLAG_LOOKUP[120] = 4;
        BSON.FLAG_LOOKUP[100] = 1;
        BSON.FLAG_LOOKUP[116] = 16;
        BSON.FLAG_LOOKUP[117] = 64;
    }
}

