/*
 * Decompiled with CFR 0.152.
 */
package org.bson;

import java.util.UUID;
import org.bson.AbstractBsonWriter;
import org.bson.BSONCallback;
import org.bson.BasicBSONDecoder;
import org.bson.BsonBinary;
import org.bson.BsonBinarySubType;
import org.bson.BsonContextType;
import org.bson.BsonDbPointer;
import org.bson.BsonRegularExpression;
import org.bson.BsonTimestamp;
import org.bson.BsonWriterSettings;
import org.bson.UuidRepresentation;
import org.bson.internal.UuidHelper;
import org.bson.types.Decimal128;
import org.bson.types.ObjectId;

class BSONCallbackAdapter
extends AbstractBsonWriter {
    private BSONCallback bsonCallback;

    protected BSONCallbackAdapter(BsonWriterSettings bsonWriterSettings, BSONCallback bSONCallback) {
        super(bsonWriterSettings);
        this.bsonCallback = bSONCallback;
    }

    @Override
    public void doWriteStartDocument() {
        BsonContextType bsonContextType;
        BsonContextType bsonContextType2 = bsonContextType = this.getState() == AbstractBsonWriter.State.SCOPE_DOCUMENT ? BsonContextType.SCOPE_DOCUMENT : BsonContextType.DOCUMENT;
        if (this.getContext() == null || bsonContextType == BsonContextType.SCOPE_DOCUMENT) {
            this.bsonCallback.objectStart();
        } else {
            this.bsonCallback.objectStart(this.getName());
        }
        this.setContext(new Context(this.getContext(), bsonContextType));
    }

    @Override
    protected void doWriteEndDocument() {
        BsonContextType bsonContextType = this.getContext().getContextType();
        this.setContext(this.getContext().getParentContext());
        this.bsonCallback.objectDone();
        if (bsonContextType == BsonContextType.SCOPE_DOCUMENT) {
            Object object = this.bsonCallback.get();
            this.bsonCallback = this.getContext().callback;
            this.bsonCallback.gotCodeWScope(this.getContext().name, this.getContext().code, object);
        }
    }

    @Override
    public void doWriteStartArray() {
        this.bsonCallback.arrayStart(this.getName());
        this.setContext(new Context(this.getContext(), BsonContextType.ARRAY));
    }

    @Override
    protected void doWriteEndArray() {
        this.setContext(this.getContext().getParentContext());
        this.bsonCallback.arrayDone();
    }

    @Override
    protected void doWriteBinaryData(BsonBinary bsonBinary) {
        if (BsonBinarySubType.isUuid(bsonBinary.getType())) {
            this.doWriteUuid(bsonBinary);
        } else {
            this.bsonCallback.gotBinary(this.getName(), bsonBinary.getType(), bsonBinary.getData());
        }
    }

    private void doWriteUuid(BsonBinary bsonBinary) {
        UuidRepresentation uuidRepresentation = BasicBSONDecoder.getDefaultUuidRepresentation();
        if (bsonBinary.getType() == uuidRepresentation.getSubtype().getValue()) {
            UUID uUID = UuidHelper.decodeBinaryToUuid(bsonBinary.getData(), bsonBinary.getType(), uuidRepresentation);
            this.bsonCallback.gotUUID(this.getName(), uUID.getMostSignificantBits(), uUID.getLeastSignificantBits());
        } else {
            this.bsonCallback.gotBinary(this.getName(), bsonBinary.getType(), bsonBinary.getData());
        }
    }

    @Override
    public void doWriteBoolean(boolean bl) {
        this.bsonCallback.gotBoolean(this.getName(), bl);
        this.setState(this.getNextState());
    }

    @Override
    protected void doWriteDateTime(long l) {
        this.bsonCallback.gotDate(this.getName(), l);
    }

    @Override
    protected void doWriteDBPointer(BsonDbPointer bsonDbPointer) {
        this.bsonCallback.gotDBRef(this.getName(), bsonDbPointer.getNamespace(), bsonDbPointer.getId());
    }

    @Override
    protected void doWriteDouble(double d) {
        this.bsonCallback.gotDouble(this.getName(), d);
    }

    @Override
    protected void doWriteInt32(int n) {
        this.bsonCallback.gotInt(this.getName(), n);
    }

    @Override
    protected void doWriteInt64(long l) {
        this.bsonCallback.gotLong(this.getName(), l);
    }

    @Override
    protected void doWriteDecimal128(Decimal128 decimal128) {
        this.bsonCallback.gotDecimal128(this.getName(), decimal128);
    }

    @Override
    protected void doWriteJavaScript(String string) {
        this.bsonCallback.gotCode(this.getName(), string);
    }

    @Override
    protected void doWriteJavaScriptWithScope(String string) {
        this.getContext().callback = this.bsonCallback;
        this.getContext().code = string;
        this.getContext().name = this.getName();
        this.bsonCallback = this.bsonCallback.createBSONCallback();
    }

    @Override
    protected void doWriteMaxKey() {
        this.bsonCallback.gotMaxKey(this.getName());
    }

    @Override
    protected void doWriteMinKey() {
        this.bsonCallback.gotMinKey(this.getName());
    }

    @Override
    public void doWriteNull() {
        this.bsonCallback.gotNull(this.getName());
    }

    @Override
    public void doWriteObjectId(ObjectId objectId) {
        this.bsonCallback.gotObjectId(this.getName(), objectId);
    }

    @Override
    public void doWriteRegularExpression(BsonRegularExpression bsonRegularExpression) {
        this.bsonCallback.gotRegex(this.getName(), bsonRegularExpression.getPattern(), bsonRegularExpression.getOptions());
    }

    @Override
    public void doWriteString(String string) {
        this.bsonCallback.gotString(this.getName(), string);
    }

    @Override
    public void doWriteSymbol(String string) {
        this.bsonCallback.gotSymbol(this.getName(), string);
    }

    @Override
    public void doWriteTimestamp(BsonTimestamp bsonTimestamp) {
        this.bsonCallback.gotTimestamp(this.getName(), bsonTimestamp.getTime(), bsonTimestamp.getInc());
    }

    @Override
    public void doWriteUndefined() {
        this.bsonCallback.gotUndefined(this.getName());
    }

    @Override
    protected Context getContext() {
        return (Context)super.getContext();
    }

    @Override
    protected String getName() {
        if (this.getContext().getContextType() == BsonContextType.ARRAY) {
            return Integer.toString(this.getContext().index++);
        }
        return super.getName();
    }

    public class Context
    extends AbstractBsonWriter.Context {
        private int index;
        private BSONCallback callback;
        private String code;
        private String name;

        Context(Context context, BsonContextType bsonContextType) {
            super(BSONCallbackAdapter.this, context, bsonContextType);
        }

        @Override
        public Context getParentContext() {
            return (Context)super.getParentContext();
        }
    }
}

