/*
 * Decompiled with CFR 0.152.
 */
package org.bson;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.bson.BSONCallback;
import org.bson.BSONCallbackAdapter;
import org.bson.BSONDecoder;
import org.bson.BSONObject;
import org.bson.BasicBSONCallback;
import org.bson.Bits;
import org.bson.BsonBinaryReader;
import org.bson.BsonWriterSettings;
import org.bson.ByteBufNIO;
import org.bson.UuidRepresentation;
import org.bson.assertions.Assertions;
import org.bson.io.ByteBufferBsonInput;

public class BasicBSONDecoder
implements BSONDecoder {
    private static volatile UuidRepresentation defaultUuidRepresentation = UuidRepresentation.JAVA_LEGACY;

    public static void setDefaultUuidRepresentation(UuidRepresentation uuidRepresentation) {
        defaultUuidRepresentation = Assertions.notNull("uuidRepresentation", uuidRepresentation);
    }

    public static UuidRepresentation getDefaultUuidRepresentation() {
        return defaultUuidRepresentation;
    }

    @Override
    public BSONObject readObject(byte[] byArray) {
        BasicBSONCallback basicBSONCallback = new BasicBSONCallback();
        this.decode(byArray, (BSONCallback)basicBSONCallback);
        return (BSONObject)basicBSONCallback.get();
    }

    @Override
    public BSONObject readObject(InputStream inputStream) throws IOException {
        return this.readObject(this.readFully(inputStream));
    }

    @Override
    public int decode(byte[] byArray, BSONCallback bSONCallback) {
        try (BsonBinaryReader bsonBinaryReader = new BsonBinaryReader(new ByteBufferBsonInput(new ByteBufNIO(ByteBuffer.wrap(byArray))));){
            BSONCallbackAdapter bSONCallbackAdapter = new BSONCallbackAdapter(new BsonWriterSettings(), bSONCallback);
            bSONCallbackAdapter.pipe(bsonBinaryReader);
            int n = bsonBinaryReader.getBsonInput().getPosition();
            return n;
        }
    }

    @Override
    public int decode(InputStream inputStream, BSONCallback bSONCallback) throws IOException {
        return this.decode(this.readFully(inputStream), bSONCallback);
    }

    private byte[] readFully(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[4];
        Bits.readFully(inputStream, byArray);
        int n = Bits.readInt(byArray);
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, 4);
        Bits.readFully(inputStream, byArray2, 4, n - 4);
        return byArray2;
    }
}

