/*
 * Decompiled with CFR 0.152.
 */
package org.bson;

import java.lang.reflect.Array;
import java.util.Date;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import org.bson.AbstractBsonWriter;
import org.bson.BSON;
import org.bson.BSONEncoder;
import org.bson.BSONObject;
import org.bson.BsonBinary;
import org.bson.BsonBinarySubType;
import org.bson.BsonBinaryWriter;
import org.bson.BsonRegularExpression;
import org.bson.BsonTimestamp;
import org.bson.UuidRepresentation;
import org.bson.assertions.Assertions;
import org.bson.internal.UuidHelper;
import org.bson.io.BasicOutputBuffer;
import org.bson.io.OutputBuffer;
import org.bson.types.BSONTimestamp;
import org.bson.types.Binary;
import org.bson.types.Code;
import org.bson.types.CodeWScope;
import org.bson.types.Decimal128;
import org.bson.types.MaxKey;
import org.bson.types.MinKey;
import org.bson.types.ObjectId;
import org.bson.types.Symbol;

public class BasicBSONEncoder
implements BSONEncoder {
    private static volatile UuidRepresentation defaultUuidRepresentation = UuidRepresentation.JAVA_LEGACY;
    private BsonBinaryWriter bsonWriter;
    private OutputBuffer outputBuffer;

    public static void setDefaultUuidRepresentation(UuidRepresentation uuidRepresentation) {
        defaultUuidRepresentation = Assertions.notNull("uuidRepresentation", uuidRepresentation);
    }

    public static UuidRepresentation getDefaultUuidRepresentation() {
        return defaultUuidRepresentation;
    }

    @Override
    public byte[] encode(BSONObject bSONObject) {
        BasicOutputBuffer basicOutputBuffer = new BasicOutputBuffer();
        this.set(basicOutputBuffer);
        this.putObject(bSONObject);
        this.done();
        return basicOutputBuffer.toByteArray();
    }

    @Override
    public void done() {
        this.bsonWriter.close();
        this.bsonWriter = null;
    }

    @Override
    public void set(OutputBuffer outputBuffer) {
        if (this.bsonWriter != null) {
            throw new IllegalStateException("Performing another operation at this moment");
        }
        this.outputBuffer = outputBuffer;
        this.bsonWriter = new BsonBinaryWriter(outputBuffer);
    }

    protected OutputBuffer getOutputBuffer() {
        return this.outputBuffer;
    }

    protected BsonBinaryWriter getBsonWriter() {
        return this.bsonWriter;
    }

    @Override
    public int putObject(BSONObject bSONObject) {
        int n = this.getOutputBuffer().getPosition();
        this.bsonWriter.writeStartDocument();
        if (this.isTopLevelDocument() && bSONObject.containsField("_id")) {
            this._putObjectField("_id", bSONObject.get("_id"));
        }
        for (String string : bSONObject.keySet()) {
            if (this.isTopLevelDocument() && string.equals("_id")) continue;
            this._putObjectField(string, bSONObject.get(string));
        }
        this.bsonWriter.writeEndDocument();
        return this.getOutputBuffer().getPosition() - n;
    }

    private boolean isTopLevelDocument() {
        return this.bsonWriter.getContext().getParentContext() == null;
    }

    protected void putName(String string) {
        if (this.bsonWriter.getState() == AbstractBsonWriter.State.NAME) {
            this.bsonWriter.writeName(string);
        }
    }

    protected void _putObjectField(String string, Object object) {
        if ("_transientFields".equals(string)) {
            return;
        }
        if (string.contains("\u0000")) {
            throw new IllegalArgumentException("Document field names can't have a NULL character. (Bad Key: '" + string + "')");
        }
        if ("$where".equals(string) && object instanceof String) {
            this.putCode(string, new Code((String)object));
        }
        if (object == null) {
            this.putNull(string);
        } else if (object instanceof Date) {
            this.putDate(string, (Date)object);
        } else if (object instanceof Decimal128) {
            this.putDecimal128(string, (Decimal128)object);
        } else if (object instanceof Number) {
            this.putNumber(string, (Number)object);
        } else if (object instanceof Character) {
            this.putString(string, object.toString());
        } else if (object instanceof String) {
            this.putString(string, object.toString());
        } else if (object instanceof ObjectId) {
            this.putObjectId(string, (ObjectId)object);
        } else if (object instanceof Boolean) {
            this.putBoolean(string, (Boolean)object);
        } else if (object instanceof Pattern) {
            this.putPattern(string, (Pattern)object);
        } else if (object instanceof Iterable) {
            this.putIterable(string, (Iterable)object);
        } else if (object instanceof BSONObject) {
            this.putObject(string, (BSONObject)object);
        } else if (object instanceof Map) {
            this.putMap(string, (Map)object);
        } else if (object instanceof byte[]) {
            this.putBinary(string, (byte[])object);
        } else if (object instanceof Binary) {
            this.putBinary(string, (Binary)object);
        } else if (object instanceof UUID) {
            this.putUUID(string, (UUID)object);
        } else if (object.getClass().isArray()) {
            this.putArray(string, object);
        } else if (object instanceof Symbol) {
            this.putSymbol(string, (Symbol)object);
        } else if (object instanceof BSONTimestamp) {
            this.putTimestamp(string, (BSONTimestamp)object);
        } else if (object instanceof CodeWScope) {
            this.putCodeWScope(string, (CodeWScope)object);
        } else if (object instanceof Code) {
            this.putCode(string, (Code)object);
        } else if (object instanceof MinKey) {
            this.putMinKey(string);
        } else if (object instanceof MaxKey) {
            this.putMaxKey(string);
        } else if (!this.putSpecial(string, object)) {
            throw new IllegalArgumentException("Can't serialize " + object.getClass());
        }
    }

    protected void putNull(String string) {
        this.putName(string);
        this.bsonWriter.writeNull();
    }

    protected void putUndefined(String string) {
        this.putName(string);
        this.bsonWriter.writeUndefined();
    }

    protected void putTimestamp(String string, BSONTimestamp bSONTimestamp) {
        this.putName(string);
        this.bsonWriter.writeTimestamp(new BsonTimestamp(bSONTimestamp.getTime(), bSONTimestamp.getInc()));
    }

    protected void putCode(String string, Code code) {
        this.putName(string);
        this.bsonWriter.writeJavaScript(code.getCode());
    }

    protected void putCodeWScope(String string, CodeWScope codeWScope) {
        this.putName(string);
        this.bsonWriter.writeJavaScriptWithScope(codeWScope.getCode());
        this.putObject(codeWScope.getScope());
    }

    protected void putBoolean(String string, Boolean bl) {
        this.putName(string);
        this.bsonWriter.writeBoolean(bl);
    }

    protected void putDate(String string, Date date) {
        this.putName(string);
        this.bsonWriter.writeDateTime(date.getTime());
    }

    protected void putNumber(String string, Number number) {
        this.putName(string);
        if (number instanceof Integer || number instanceof Short || number instanceof Byte || number instanceof AtomicInteger) {
            this.bsonWriter.writeInt32(number.intValue());
        } else if (number instanceof Long || number instanceof AtomicLong) {
            this.bsonWriter.writeInt64(number.longValue());
        } else if (number instanceof Float || number instanceof Double) {
            this.bsonWriter.writeDouble(number.doubleValue());
        } else {
            throw new IllegalArgumentException("Can't serialize " + number.getClass());
        }
    }

    protected void putDecimal128(String string, Decimal128 decimal128) {
        this.putName(string);
        this.bsonWriter.writeDecimal128(decimal128);
    }

    protected void putBinary(String string, byte[] byArray) {
        this.putName(string);
        this.bsonWriter.writeBinaryData(new BsonBinary(byArray));
    }

    protected void putBinary(String string, Binary binary) {
        this.putName(string);
        this.bsonWriter.writeBinaryData(new BsonBinary(binary.getType(), binary.getData()));
    }

    protected void putUUID(String string, UUID uUID) {
        this.putName(string);
        UuidRepresentation uuidRepresentation = defaultUuidRepresentation;
        byte[] byArray = UuidHelper.encodeUuidToBinary(uUID, uuidRepresentation);
        this.bsonWriter.writeBinaryData(new BsonBinary(uuidRepresentation == UuidRepresentation.STANDARD ? BsonBinarySubType.UUID_STANDARD : BsonBinarySubType.UUID_LEGACY, byArray));
    }

    protected void putSymbol(String string, Symbol symbol) {
        this.putName(string);
        this.bsonWriter.writeSymbol(symbol.getSymbol());
    }

    protected void putString(String string, String string2) {
        this.putName(string);
        this.bsonWriter.writeString(string2);
    }

    protected void putPattern(String string, Pattern pattern) {
        this.putName(string);
        this.bsonWriter.writeRegularExpression(new BsonRegularExpression(pattern.pattern(), BSON.regexFlags(pattern.flags())));
    }

    protected void putObjectId(String string, ObjectId objectId) {
        this.putName(string);
        this.bsonWriter.writeObjectId(objectId);
    }

    protected void putArray(String string, Object object) {
        this.putName(string);
        this.bsonWriter.writeStartArray();
        if (object instanceof int[]) {
            for (int n : (int[])object) {
                this.bsonWriter.writeInt32(n);
            }
        } else if (object instanceof long[]) {
            for (long l : (long[])object) {
                this.bsonWriter.writeInt64(l);
            }
        } else if (object instanceof float[]) {
            for (float f : (float[])object) {
                this.bsonWriter.writeDouble(f);
            }
        } else if (object instanceof short[]) {
            for (short s : (short[])object) {
                this.bsonWriter.writeInt32(s);
            }
        } else if (object instanceof byte[]) {
            for (byte by : (byte[])object) {
                this.bsonWriter.writeInt32(by);
            }
        } else if (object instanceof double[]) {
            for (double d : (double[])object) {
                this.bsonWriter.writeDouble(d);
            }
        } else if (object instanceof boolean[]) {
            for (boolean bl : (boolean[])object) {
                this.bsonWriter.writeBoolean(bl);
            }
        } else if (object instanceof String[]) {
            for (String string2 : (String[])object) {
                this.bsonWriter.writeString(string2);
            }
        } else {
            int n = Array.getLength(object);
            for (int i = 0; i < n; ++i) {
                this._putObjectField(String.valueOf(i), Array.get(object, i));
            }
        }
        this.bsonWriter.writeEndArray();
    }

    protected void putIterable(String string, Iterable iterable) {
        this.putName(string);
        this.bsonWriter.writeStartArray();
        int n = 0;
        for (Object t : iterable) {
            this._putObjectField(String.valueOf(n), t);
        }
        this.bsonWriter.writeEndArray();
    }

    protected void putMap(String string, Map map) {
        this.putName(string);
        this.bsonWriter.writeStartDocument();
        for (Map.Entry entry : map.entrySet()) {
            this._putObjectField((String)entry.getKey(), entry.getValue());
        }
        this.bsonWriter.writeEndDocument();
    }

    protected int putObject(String string, BSONObject bSONObject) {
        this.putName(string);
        return this.putObject(bSONObject);
    }

    protected boolean putSpecial(String string, Object object) {
        return false;
    }

    protected void putMinKey(String string) {
        this.putName(string);
        this.bsonWriter.writeMinKey();
    }

    protected void putMaxKey(String string) {
        this.putName(string);
        this.bsonWriter.writeMaxKey();
    }

    private static void writeLongToArrayLittleEndian(byte[] byArray, int n, long l) {
        byArray[n] = (byte)(0xFFL & l);
        byArray[n + 1] = (byte)(0xFFL & l >> 8);
        byArray[n + 2] = (byte)(0xFFL & l >> 16);
        byArray[n + 3] = (byte)(0xFFL & l >> 24);
        byArray[n + 4] = (byte)(0xFFL & l >> 32);
        byArray[n + 5] = (byte)(0xFFL & l >> 40);
        byArray[n + 6] = (byte)(0xFFL & l >> 48);
        byArray[n + 7] = (byte)(0xFFL & l >> 56);
    }
}

