/*
 * Decompiled with CFR 0.152.
 */
package org.bson;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.bson.BSONEncoder;
import org.bson.BSONObject;
import org.bson.BasicBSONEncoder;
import org.bson.types.BasicBSONList;
import org.bson.types.ObjectId;

public class BasicBSONObject
extends LinkedHashMap<String, Object>
implements BSONObject {
    private static final long serialVersionUID = -4415279469780082174L;

    public BasicBSONObject() {
    }

    public BasicBSONObject(int n) {
        super(n);
    }

    public BasicBSONObject(String string, Object object) {
        this.put(string, object);
    }

    public BasicBSONObject(Map map) {
        super(map);
    }

    @Override
    public Map toMap() {
        return new LinkedHashMap<String, Object>(this);
    }

    @Override
    public Object removeField(String string) {
        return this.remove(string);
    }

    @Override
    public boolean containsField(String string) {
        return this.containsKey(string);
    }

    @Override
    public Object get(String string) {
        return super.get(string);
    }

    public int getInt(String string) {
        Object object = this.get(string);
        if (object == null) {
            throw new NullPointerException("no value for: " + string);
        }
        return this.toInt(object);
    }

    public int getInt(String string, int n) {
        Object object = this.get(string);
        if (object == null) {
            return n;
        }
        return this.toInt(object);
    }

    public long getLong(String string) {
        Object object = this.get(string);
        return ((Number)object).longValue();
    }

    public long getLong(String string, long l) {
        Object object = this.get(string);
        if (object == null) {
            return l;
        }
        return ((Number)object).longValue();
    }

    public double getDouble(String string) {
        Object object = this.get(string);
        return ((Number)object).doubleValue();
    }

    public double getDouble(String string, double d) {
        Object object = this.get(string);
        if (object == null) {
            return d;
        }
        return ((Number)object).doubleValue();
    }

    public String getString(String string) {
        Object object = this.get(string);
        if (object == null) {
            return null;
        }
        return object.toString();
    }

    public String getString(String string, String string2) {
        Object object = this.get(string);
        if (object == null) {
            return string2;
        }
        return object.toString();
    }

    public boolean getBoolean(String string) {
        return this.getBoolean(string, false);
    }

    public boolean getBoolean(String string, boolean bl) {
        Object object = this.get(string);
        if (object == null) {
            return bl;
        }
        if (object instanceof Number) {
            return ((Number)object).intValue() > 0;
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        throw new IllegalArgumentException("can't coerce to bool:" + object.getClass());
    }

    public ObjectId getObjectId(String string) {
        return (ObjectId)this.get(string);
    }

    public ObjectId getObjectId(String string, ObjectId objectId) {
        Object object = this.get(string);
        return object != null ? (ObjectId)object : objectId;
    }

    public Date getDate(String string) {
        return (Date)this.get(string);
    }

    public Date getDate(String string, Date date) {
        Object object = this.get(string);
        return object != null ? (Date)object : date;
    }

    @Override
    public void putAll(Map map) {
        for (Map.Entry entry : map.entrySet()) {
            this.put(entry.getKey().toString(), entry.getValue());
        }
    }

    @Override
    public void putAll(BSONObject bSONObject) {
        for (String string : bSONObject.keySet()) {
            this.put(string, bSONObject.get(string));
        }
    }

    public BasicBSONObject append(String string, Object object) {
        this.put(string, object);
        return this;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof BSONObject)) {
            return false;
        }
        BSONObject bSONObject = (BSONObject)object;
        if (!this.keySet().equals(bSONObject.keySet())) {
            return false;
        }
        return Arrays.equals(this.getEncoder().encode(BasicBSONObject.canonicalizeBSONObject(this)), this.getEncoder().encode(BasicBSONObject.canonicalizeBSONObject(bSONObject)));
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(BasicBSONObject.canonicalizeBSONObject(this).encode());
    }

    private byte[] encode() {
        return this.getEncoder().encode(this);
    }

    private BSONEncoder getEncoder() {
        return new BasicBSONEncoder();
    }

    private static Object canonicalize(Object object) {
        if (object instanceof BSONObject && !(object instanceof BasicBSONList)) {
            return BasicBSONObject.canonicalizeBSONObject((BSONObject)object);
        }
        if (object instanceof List) {
            return BasicBSONObject.canonicalizeList((List)object);
        }
        if (object instanceof Map) {
            return BasicBSONObject.canonicalizeMap((Map)object);
        }
        return object;
    }

    private static Map<String, Object> canonicalizeMap(Map<String, Object> map) {
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>(map.size());
        TreeSet<String> treeSet = new TreeSet<String>(map.keySet());
        for (String string : treeSet) {
            Object object = map.get(string);
            linkedHashMap.put(string, BasicBSONObject.canonicalize(object));
        }
        return linkedHashMap;
    }

    private static BasicBSONObject canonicalizeBSONObject(BSONObject bSONObject) {
        BasicBSONObject basicBSONObject = new BasicBSONObject();
        TreeSet<String> treeSet = new TreeSet<String>(bSONObject.keySet());
        for (String string : treeSet) {
            Object object = bSONObject.get(string);
            basicBSONObject.put(string, BasicBSONObject.canonicalize(object));
        }
        return basicBSONObject;
    }

    private static List canonicalizeList(List<Object> list) {
        ArrayList<Object> arrayList = new ArrayList<Object>(list.size());
        for (Object object : list) {
            arrayList.add(BasicBSONObject.canonicalize(object));
        }
        return arrayList;
    }

    private int toInt(Object object) {
        if (object instanceof Number) {
            return ((Number)object).intValue();
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? 1 : 0;
        }
        throw new IllegalArgumentException("can't convert: " + object.getClass().getName() + " to int");
    }
}

