/*
 * Decompiled with CFR 0.152.
 */
package org.bson;

import org.bson.Float32BinaryVector;
import org.bson.Int8BinaryVector;
import org.bson.PackedBitBinaryVector;
import org.bson.annotations.Beta;
import org.bson.annotations.Reason;
import org.bson.assertions.Assertions;

public abstract class BinaryVector {
    private final DataType dataType;

    BinaryVector(DataType dataType) {
        this.dataType = dataType;
    }

    @Beta(value={Reason.SERVER})
    public static PackedBitBinaryVector packedBitVector(byte[] byArray, byte by) {
        Assertions.notNull("data", byArray);
        Assertions.isTrueArgument("Padding must be between 0 and 7 bits. Provided padding: " + by, by >= 0 && by <= 7);
        Assertions.isTrueArgument("Padding must be 0 if vector is empty. Provided padding: " + by, by == 0 || byArray.length > 0);
        return new PackedBitBinaryVector(byArray, by);
    }

    public static Int8BinaryVector int8Vector(byte[] byArray) {
        Assertions.notNull("data", byArray);
        return new Int8BinaryVector(byArray);
    }

    public static Float32BinaryVector floatVector(float[] fArray) {
        Assertions.notNull("data", fArray);
        return new Float32BinaryVector(fArray);
    }

    public PackedBitBinaryVector asPackedBitVector() {
        this.ensureType(DataType.PACKED_BIT);
        return (PackedBitBinaryVector)this;
    }

    public Int8BinaryVector asInt8Vector() {
        this.ensureType(DataType.INT8);
        return (Int8BinaryVector)this;
    }

    public Float32BinaryVector asFloat32Vector() {
        this.ensureType(DataType.FLOAT32);
        return (Float32BinaryVector)this;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    private void ensureType(DataType dataType) {
        if (this.dataType != dataType) {
            throw new IllegalStateException("Expected vector data type " + (Object)((Object)dataType) + ", but found " + (Object)((Object)this.dataType));
        }
    }

    public static enum DataType {
        INT8(3),
        FLOAT32(39),
        PACKED_BIT(16);

        private final byte value;

        private DataType(byte by) {
            this.value = by;
        }

        public byte getValue() {
            return this.value;
        }
    }
}

