/*
 * Decompiled with CFR 0.152.
 */
package org.bson;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.bson.BsonBinary;
import org.bson.BsonJavaScriptWithScope;
import org.bson.BsonType;
import org.bson.BsonValue;
import org.bson.codecs.BsonArrayCodec;
import org.bson.codecs.DecoderContext;
import org.bson.json.JsonReader;

public class BsonArray
extends BsonValue
implements List<BsonValue>,
Cloneable {
    private final List<BsonValue> values;

    public BsonArray(List<? extends BsonValue> list) {
        this(list, true);
    }

    public BsonArray() {
        this(new ArrayList(), false);
    }

    public BsonArray(int n) {
        this(new ArrayList(n), false);
    }

    BsonArray(List<? extends BsonValue> list, boolean bl) {
        this.values = bl ? new ArrayList<BsonValue>(list) : list;
    }

    public static BsonArray parse(String string) {
        return new BsonArrayCodec().decode(new JsonReader(string), DecoderContext.builder().build());
    }

    public List<BsonValue> getValues() {
        return Collections.unmodifiableList(this.values);
    }

    @Override
    public BsonType getBsonType() {
        return BsonType.ARRAY;
    }

    @Override
    public int size() {
        return this.values.size();
    }

    @Override
    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    @Override
    public boolean contains(Object object) {
        return this.values.contains(object);
    }

    @Override
    public Iterator<BsonValue> iterator() {
        return this.values.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.values.toArray();
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        return this.values.toArray(TArray);
    }

    @Override
    public boolean add(BsonValue bsonValue) {
        return this.values.add(bsonValue);
    }

    @Override
    public boolean remove(Object object) {
        return this.values.remove(object);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this.values.containsAll(collection);
    }

    @Override
    public boolean addAll(Collection<? extends BsonValue> collection) {
        return this.values.addAll(collection);
    }

    @Override
    public boolean addAll(int n, Collection<? extends BsonValue> collection) {
        return this.values.addAll(n, collection);
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        return this.values.removeAll(collection);
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        return this.values.retainAll(collection);
    }

    @Override
    public void clear() {
        this.values.clear();
    }

    @Override
    public BsonValue get(int n) {
        return this.values.get(n);
    }

    @Override
    public BsonValue set(int n, BsonValue bsonValue) {
        return this.values.set(n, bsonValue);
    }

    @Override
    public void add(int n, BsonValue bsonValue) {
        this.values.add(n, bsonValue);
    }

    @Override
    public BsonValue remove(int n) {
        return this.values.remove(n);
    }

    @Override
    public int indexOf(Object object) {
        return this.values.indexOf(object);
    }

    @Override
    public int lastIndexOf(Object object) {
        return this.values.lastIndexOf(object);
    }

    @Override
    public ListIterator<BsonValue> listIterator() {
        return this.values.listIterator();
    }

    @Override
    public ListIterator<BsonValue> listIterator(int n) {
        return this.values.listIterator(n);
    }

    @Override
    public List<BsonValue> subList(int n, int n2) {
        return this.values.subList(n, n2);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof BsonArray)) {
            return false;
        }
        BsonArray bsonArray = (BsonArray)object;
        return this.getValues().equals(bsonArray.getValues());
    }

    @Override
    public int hashCode() {
        return this.values.hashCode();
    }

    public String toString() {
        return "BsonArray{values=" + this.getValues() + '}';
    }

    public BsonArray clone() {
        BsonArray bsonArray = new BsonArray(this.size());
        block6: for (BsonValue bsonValue : this) {
            switch (bsonValue.getBsonType()) {
                case DOCUMENT: {
                    bsonArray.add(bsonValue.asDocument().clone());
                    continue block6;
                }
                case ARRAY: {
                    bsonArray.add(bsonValue.asArray().clone());
                    continue block6;
                }
                case BINARY: {
                    bsonArray.add(BsonBinary.clone(bsonValue.asBinary()));
                    continue block6;
                }
                case JAVASCRIPT_WITH_SCOPE: {
                    bsonArray.add(BsonJavaScriptWithScope.clone(bsonValue.asJavaScriptWithScope()));
                    continue block6;
                }
            }
            bsonArray.add(bsonValue);
        }
        return bsonArray;
    }
}

