/*
 * Decompiled with CFR 0.152.
 */
package org.bson;

import java.util.Arrays;
import java.util.UUID;
import org.bson.BinaryVector;
import org.bson.BsonBinarySubType;
import org.bson.BsonInvalidOperationException;
import org.bson.BsonType;
import org.bson.BsonValue;
import org.bson.UuidRepresentation;
import org.bson.assertions.Assertions;
import org.bson.internal.UuidHelper;
import org.bson.internal.vector.BinaryVectorHelper;

public class BsonBinary
extends BsonValue {
    private final byte type;
    private final byte[] data;

    public BsonBinary(byte[] byArray) {
        this(BsonBinarySubType.BINARY, byArray);
    }

    public BsonBinary(BsonBinarySubType bsonBinarySubType, byte[] byArray) {
        if (bsonBinarySubType == null) {
            throw new IllegalArgumentException("type may not be null");
        }
        if (byArray == null) {
            throw new IllegalArgumentException("data may not be null");
        }
        this.type = bsonBinarySubType.getValue();
        this.data = byArray;
    }

    public BsonBinary(byte by, byte[] byArray) {
        if (byArray == null) {
            throw new IllegalArgumentException("data may not be null");
        }
        this.type = by;
        this.data = byArray;
    }

    public BsonBinary(UUID uUID) {
        this(uUID, UuidRepresentation.STANDARD);
    }

    public BsonBinary(BinaryVector binaryVector) {
        if (binaryVector == null) {
            throw new IllegalArgumentException("Vector must not be null");
        }
        this.data = BinaryVectorHelper.encodeVectorToBinary(binaryVector);
        this.type = BsonBinarySubType.VECTOR.getValue();
    }

    public BsonBinary(UUID uUID, UuidRepresentation uuidRepresentation) {
        if (uUID == null) {
            throw new IllegalArgumentException("uuid may not be null");
        }
        if (uuidRepresentation == null) {
            throw new IllegalArgumentException("uuidRepresentation may not be null");
        }
        this.data = UuidHelper.encodeUuidToBinary(uUID, uuidRepresentation);
        this.type = uuidRepresentation == UuidRepresentation.STANDARD ? BsonBinarySubType.UUID_STANDARD.getValue() : BsonBinarySubType.UUID_LEGACY.getValue();
    }

    public UUID asUuid() {
        if (!BsonBinarySubType.isUuid(this.type)) {
            throw new BsonInvalidOperationException("type must be a UUID subtype.");
        }
        if (this.type != BsonBinarySubType.UUID_STANDARD.getValue()) {
            throw new BsonInvalidOperationException("uuidRepresentation must be set to return the correct UUID.");
        }
        return UuidHelper.decodeBinaryToUuid((byte[])this.data.clone(), this.type, UuidRepresentation.STANDARD);
    }

    public BinaryVector asVector() {
        if (this.type != BsonBinarySubType.VECTOR.getValue()) {
            throw new BsonInvalidOperationException("type must be a Vector subtype.");
        }
        return BinaryVectorHelper.decodeBinaryToVector(this.data);
    }

    public UUID asUuid(UuidRepresentation uuidRepresentation) {
        byte by;
        Assertions.notNull("uuidRepresentation", uuidRepresentation);
        byte by2 = by = uuidRepresentation == UuidRepresentation.STANDARD ? BsonBinarySubType.UUID_STANDARD.getValue() : BsonBinarySubType.UUID_LEGACY.getValue();
        if (this.type != by) {
            throw new BsonInvalidOperationException("uuidRepresentation does not match current uuidRepresentation.");
        }
        return UuidHelper.decodeBinaryToUuid((byte[])this.data.clone(), this.type, uuidRepresentation);
    }

    @Override
    public BsonType getBsonType() {
        return BsonType.BINARY;
    }

    public byte getType() {
        return this.type;
    }

    public byte[] getData() {
        return this.data;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        BsonBinary bsonBinary = (BsonBinary)object;
        if (!Arrays.equals(this.data, bsonBinary.data)) {
            return false;
        }
        return this.type == bsonBinary.type;
    }

    public int hashCode() {
        int n = this.type;
        n = 31 * n + Arrays.hashCode(this.data);
        return n;
    }

    public String toString() {
        return "BsonBinary{type=" + this.type + ", data=" + Arrays.toString(this.data) + '}';
    }

    static BsonBinary clone(BsonBinary bsonBinary) {
        return new BsonBinary(bsonBinary.type, (byte[])bsonBinary.data.clone());
    }
}

