/*
 * Decompiled with CFR 0.152.
 */
package org.bson;

import java.util.List;
import java.util.Stack;
import org.bson.AbstractBsonReader;
import org.bson.AbstractBsonWriter;
import org.bson.BsonBinary;
import org.bson.BsonBinaryReader;
import org.bson.BsonBinarySubType;
import org.bson.BsonBinaryWriterSettings;
import org.bson.BsonContextType;
import org.bson.BsonDbPointer;
import org.bson.BsonElement;
import org.bson.BsonMaximumSizeExceededException;
import org.bson.BsonReader;
import org.bson.BsonRegularExpression;
import org.bson.BsonSerializationException;
import org.bson.BsonTimestamp;
import org.bson.BsonType;
import org.bson.BsonWriterSettings;
import org.bson.FieldNameValidator;
import org.bson.NoOpFieldNameValidator;
import org.bson.assertions.Assertions;
import org.bson.io.BsonInput;
import org.bson.io.BsonOutput;
import org.bson.types.Decimal128;
import org.bson.types.ObjectId;

public class BsonBinaryWriter
extends AbstractBsonWriter {
    private final BsonBinaryWriterSettings binaryWriterSettings;
    private final BsonOutput bsonOutput;
    private final Stack<Integer> maxDocumentSizeStack = new Stack();
    private Mark mark;

    public BsonBinaryWriter(BsonOutput bsonOutput, FieldNameValidator fieldNameValidator) {
        this(new BsonWriterSettings(), new BsonBinaryWriterSettings(), bsonOutput, fieldNameValidator);
    }

    public BsonBinaryWriter(BsonOutput bsonOutput) {
        this(new BsonWriterSettings(), new BsonBinaryWriterSettings(), bsonOutput);
    }

    public BsonBinaryWriter(BsonWriterSettings bsonWriterSettings, BsonBinaryWriterSettings bsonBinaryWriterSettings, BsonOutput bsonOutput) {
        this(bsonWriterSettings, bsonBinaryWriterSettings, bsonOutput, NoOpFieldNameValidator.INSTANCE);
    }

    public BsonBinaryWriter(BsonWriterSettings bsonWriterSettings, BsonBinaryWriterSettings bsonBinaryWriterSettings, BsonOutput bsonOutput, FieldNameValidator fieldNameValidator) {
        super(bsonWriterSettings, fieldNameValidator);
        this.binaryWriterSettings = bsonBinaryWriterSettings;
        this.bsonOutput = bsonOutput;
        this.maxDocumentSizeStack.push(bsonBinaryWriterSettings.getMaxDocumentSize());
    }

    @Override
    public void close() {
        super.close();
    }

    public BsonOutput getBsonOutput() {
        return this.bsonOutput;
    }

    public BsonBinaryWriterSettings getBinaryWriterSettings() {
        return this.binaryWriterSettings;
    }

    @Override
    protected Context getContext() {
        return (Context)super.getContext();
    }

    @Override
    protected void doWriteStartDocument() {
        if (this.getState() == AbstractBsonWriter.State.VALUE) {
            this.bsonOutput.writeByte(BsonType.DOCUMENT.getValue());
            this.writeCurrentName();
        }
        this.setContext(new Context(this.getContext(), BsonContextType.DOCUMENT, this.bsonOutput.getPosition()));
        this.bsonOutput.writeInt32(0);
    }

    @Override
    protected void doWriteEndDocument() {
        this.bsonOutput.writeByte(0);
        this.backpatchSize();
        this.setContext(this.getContext().getParentContext());
        if (this.getContext() != null && this.getContext().getContextType() == BsonContextType.JAVASCRIPT_WITH_SCOPE) {
            this.backpatchSize();
            this.setContext(this.getContext().getParentContext());
        }
    }

    @Override
    protected void doWriteStartArray() {
        this.bsonOutput.writeByte(BsonType.ARRAY.getValue());
        this.writeCurrentName();
        this.setContext(new Context(this.getContext(), BsonContextType.ARRAY, this.bsonOutput.getPosition()));
        this.bsonOutput.writeInt32(0);
    }

    @Override
    protected void doWriteEndArray() {
        this.bsonOutput.writeByte(0);
        this.backpatchSize();
        this.setContext(this.getContext().getParentContext());
    }

    @Override
    protected void doWriteBinaryData(BsonBinary bsonBinary) {
        this.bsonOutput.writeByte(BsonType.BINARY.getValue());
        this.writeCurrentName();
        int n = bsonBinary.getData().length;
        if (bsonBinary.getType() == BsonBinarySubType.OLD_BINARY.getValue()) {
            n += 4;
        }
        this.bsonOutput.writeInt32(n);
        this.bsonOutput.writeByte(bsonBinary.getType());
        if (bsonBinary.getType() == BsonBinarySubType.OLD_BINARY.getValue()) {
            this.bsonOutput.writeInt32(n - 4);
        }
        this.bsonOutput.writeBytes(bsonBinary.getData());
    }

    @Override
    public void doWriteBoolean(boolean bl) {
        this.bsonOutput.writeByte(BsonType.BOOLEAN.getValue());
        this.writeCurrentName();
        this.bsonOutput.writeByte(bl ? 1 : 0);
    }

    @Override
    protected void doWriteDateTime(long l) {
        this.bsonOutput.writeByte(BsonType.DATE_TIME.getValue());
        this.writeCurrentName();
        this.bsonOutput.writeInt64(l);
    }

    @Override
    protected void doWriteDBPointer(BsonDbPointer bsonDbPointer) {
        this.bsonOutput.writeByte(BsonType.DB_POINTER.getValue());
        this.writeCurrentName();
        this.bsonOutput.writeString(bsonDbPointer.getNamespace());
        this.bsonOutput.writeBytes(bsonDbPointer.getId().toByteArray());
    }

    @Override
    protected void doWriteDouble(double d) {
        this.bsonOutput.writeByte(BsonType.DOUBLE.getValue());
        this.writeCurrentName();
        this.bsonOutput.writeDouble(d);
    }

    @Override
    protected void doWriteInt32(int n) {
        this.bsonOutput.writeByte(BsonType.INT32.getValue());
        this.writeCurrentName();
        this.bsonOutput.writeInt32(n);
    }

    @Override
    protected void doWriteInt64(long l) {
        this.bsonOutput.writeByte(BsonType.INT64.getValue());
        this.writeCurrentName();
        this.bsonOutput.writeInt64(l);
    }

    @Override
    protected void doWriteDecimal128(Decimal128 decimal128) {
        this.bsonOutput.writeByte(BsonType.DECIMAL128.getValue());
        this.writeCurrentName();
        this.bsonOutput.writeInt64(decimal128.getLow());
        this.bsonOutput.writeInt64(decimal128.getHigh());
    }

    @Override
    protected void doWriteJavaScript(String string) {
        this.bsonOutput.writeByte(BsonType.JAVASCRIPT.getValue());
        this.writeCurrentName();
        this.bsonOutput.writeString(string);
    }

    @Override
    protected void doWriteJavaScriptWithScope(String string) {
        this.bsonOutput.writeByte(BsonType.JAVASCRIPT_WITH_SCOPE.getValue());
        this.writeCurrentName();
        this.setContext(new Context(this.getContext(), BsonContextType.JAVASCRIPT_WITH_SCOPE, this.bsonOutput.getPosition()));
        this.bsonOutput.writeInt32(0);
        this.bsonOutput.writeString(string);
    }

    @Override
    protected void doWriteMaxKey() {
        this.bsonOutput.writeByte(BsonType.MAX_KEY.getValue());
        this.writeCurrentName();
    }

    @Override
    protected void doWriteMinKey() {
        this.bsonOutput.writeByte(BsonType.MIN_KEY.getValue());
        this.writeCurrentName();
    }

    @Override
    public void doWriteNull() {
        this.bsonOutput.writeByte(BsonType.NULL.getValue());
        this.writeCurrentName();
    }

    @Override
    public void doWriteObjectId(ObjectId objectId) {
        this.bsonOutput.writeByte(BsonType.OBJECT_ID.getValue());
        this.writeCurrentName();
        this.bsonOutput.writeBytes(objectId.toByteArray());
    }

    @Override
    public void doWriteRegularExpression(BsonRegularExpression bsonRegularExpression) {
        this.bsonOutput.writeByte(BsonType.REGULAR_EXPRESSION.getValue());
        this.writeCurrentName();
        this.bsonOutput.writeCString(bsonRegularExpression.getPattern());
        this.bsonOutput.writeCString(bsonRegularExpression.getOptions());
    }

    @Override
    public void doWriteString(String string) {
        this.bsonOutput.writeByte(BsonType.STRING.getValue());
        this.writeCurrentName();
        this.bsonOutput.writeString(string);
    }

    @Override
    public void doWriteSymbol(String string) {
        this.bsonOutput.writeByte(BsonType.SYMBOL.getValue());
        this.writeCurrentName();
        this.bsonOutput.writeString(string);
    }

    @Override
    public void doWriteTimestamp(BsonTimestamp bsonTimestamp) {
        this.bsonOutput.writeByte(BsonType.TIMESTAMP.getValue());
        this.writeCurrentName();
        this.bsonOutput.writeInt64(bsonTimestamp.getValue());
    }

    @Override
    public void doWriteUndefined() {
        this.bsonOutput.writeByte(BsonType.UNDEFINED.getValue());
        this.writeCurrentName();
    }

    @Override
    public void pipe(BsonReader bsonReader) {
        Assertions.notNull("reader", bsonReader);
        this.pipeDocument(bsonReader, null);
    }

    @Override
    public void pipe(BsonReader bsonReader, List<BsonElement> list) {
        Assertions.notNull("reader", bsonReader);
        Assertions.notNull("extraElements", list);
        this.pipeDocument(bsonReader, list);
    }

    private void pipeDocument(BsonReader bsonReader, List<BsonElement> list) {
        if (bsonReader instanceof BsonBinaryReader) {
            BsonInput bsonInput;
            int n;
            BsonBinaryReader bsonBinaryReader = (BsonBinaryReader)bsonReader;
            if (this.getState() == AbstractBsonWriter.State.VALUE) {
                this.bsonOutput.writeByte(BsonType.DOCUMENT.getValue());
                this.writeCurrentName();
            }
            if ((n = (bsonInput = bsonBinaryReader.getBsonInput()).readInt32()) < 5) {
                throw new BsonSerializationException("Document size must be at least 5");
            }
            int n2 = this.bsonOutput.getPosition();
            this.bsonOutput.writeInt32(n);
            byte[] byArray = new byte[n - 4];
            bsonInput.readBytes(byArray);
            this.bsonOutput.writeBytes(byArray);
            bsonBinaryReader.setState(AbstractBsonReader.State.TYPE);
            if (list != null) {
                this.bsonOutput.truncateToPosition(this.bsonOutput.getPosition() - 1);
                this.setContext(new Context(this.getContext(), BsonContextType.DOCUMENT, n2));
                this.setState(AbstractBsonWriter.State.NAME);
                this.pipeExtraElements(list);
                this.bsonOutput.writeByte(0);
                this.bsonOutput.writeInt32(n2, this.bsonOutput.getPosition() - n2);
                this.setContext(this.getContext().getParentContext());
            }
            if (this.getContext() == null) {
                this.setState(AbstractBsonWriter.State.DONE);
            } else {
                if (this.getContext().getContextType() == BsonContextType.JAVASCRIPT_WITH_SCOPE) {
                    this.backpatchSize();
                    this.setContext(this.getContext().getParentContext());
                }
                this.setState(this.getNextState());
            }
            this.validateSize(this.bsonOutput.getPosition() - n2);
        } else if (list != null) {
            super.pipe(bsonReader, list);
        } else {
            super.pipe(bsonReader);
        }
    }

    public void pushMaxDocumentSize(int n) {
        this.maxDocumentSizeStack.push(n);
    }

    public void popMaxDocumentSize() {
        this.maxDocumentSizeStack.pop();
    }

    public void mark() {
        this.mark = new Mark();
    }

    public void reset() {
        if (this.mark == null) {
            throw new IllegalStateException("Can not reset without first marking");
        }
        this.mark.reset();
        this.mark = null;
    }

    private void writeCurrentName() {
        if (this.getContext().getContextType() == BsonContextType.ARRAY) {
            this.bsonOutput.writeCString(Integer.toString(this.getContext().index++));
        } else {
            this.bsonOutput.writeCString(this.getName());
        }
    }

    private void backpatchSize() {
        int n = this.bsonOutput.getPosition() - this.getContext().startPosition;
        this.validateSize(n);
        this.bsonOutput.writeInt32(this.bsonOutput.getPosition() - n, n);
    }

    private void validateSize(int n) {
        if (n > this.maxDocumentSizeStack.peek()) {
            throw new BsonMaximumSizeExceededException(String.format("Document size of %d is larger than maximum of %d.", n, this.maxDocumentSizeStack.peek()));
        }
    }

    protected class Mark
    extends AbstractBsonWriter.Mark {
        private final int position;

        protected Mark() {
            super(BsonBinaryWriter.this);
            this.position = BsonBinaryWriter.this.bsonOutput.getPosition();
        }

        @Override
        protected void reset() {
            super.reset();
            BsonBinaryWriter.this.bsonOutput.truncateToPosition(((BsonBinaryWriter)BsonBinaryWriter.this).mark.position);
        }
    }

    protected class Context
    extends AbstractBsonWriter.Context {
        private final int startPosition;
        private int index;

        public Context(Context context, BsonContextType bsonContextType, int n) {
            super(BsonBinaryWriter.this, context, bsonContextType);
            this.startPosition = n;
        }

        public Context(Context context) {
            super(BsonBinaryWriter.this, context);
            this.startPosition = context.startPosition;
            this.index = context.index;
        }

        @Override
        public Context getParentContext() {
            return (Context)super.getParentContext();
        }

        @Override
        public Context copy() {
            return new Context(this);
        }
    }
}

