/*
 * Decompiled with CFR 0.152.
 */
package org.bson;

import org.bson.BsonType;
import org.bson.BsonValue;

public final class BsonBoolean
extends BsonValue
implements Comparable<BsonBoolean> {
    private final boolean value;
    public static final BsonBoolean TRUE = new BsonBoolean(true);
    public static final BsonBoolean FALSE = new BsonBoolean(false);

    public static BsonBoolean valueOf(boolean bl) {
        return bl ? TRUE : FALSE;
    }

    public BsonBoolean(boolean bl) {
        this.value = bl;
    }

    @Override
    public int compareTo(BsonBoolean bsonBoolean) {
        return Boolean.valueOf(this.value).compareTo(bsonBoolean.value);
    }

    @Override
    public BsonType getBsonType() {
        return BsonType.BOOLEAN;
    }

    public boolean getValue() {
        return this.value;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        BsonBoolean bsonBoolean = (BsonBoolean)object;
        return this.value == bsonBoolean.value;
    }

    public int hashCode() {
        return this.value ? 1 : 0;
    }

    public String toString() {
        return "BsonBoolean{value=" + this.value + '}';
    }
}

