/*
 * Decompiled with CFR 0.152.
 */
package org.bson;

import org.bson.BsonType;
import org.bson.BsonValue;
import org.bson.types.ObjectId;

public class BsonDbPointer
extends BsonValue {
    private final String namespace;
    private final ObjectId id;

    public BsonDbPointer(String string, ObjectId objectId) {
        if (string == null) {
            throw new IllegalArgumentException("namespace can not be null");
        }
        if (objectId == null) {
            throw new IllegalArgumentException("id can not be null");
        }
        this.namespace = string;
        this.id = objectId;
    }

    @Override
    public BsonType getBsonType() {
        return BsonType.DB_POINTER;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public ObjectId getId() {
        return this.id;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        BsonDbPointer bsonDbPointer = (BsonDbPointer)object;
        if (!this.id.equals(bsonDbPointer.id)) {
            return false;
        }
        return this.namespace.equals(bsonDbPointer.namespace);
    }

    public int hashCode() {
        int n = this.namespace.hashCode();
        n = 31 * n + this.id.hashCode();
        return n;
    }

    public String toString() {
        return "BsonDbPointer{namespace='" + this.namespace + '\'' + ", id=" + this.id + '}';
    }
}

