/*
 * Decompiled with CFR 0.152.
 */
package org.bson;

import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bson.BsonArray;
import org.bson.BsonBinary;
import org.bson.BsonBinaryReader;
import org.bson.BsonBinaryWriter;
import org.bson.BsonBoolean;
import org.bson.BsonDateTime;
import org.bson.BsonDecimal128;
import org.bson.BsonDocumentReader;
import org.bson.BsonDouble;
import org.bson.BsonElement;
import org.bson.BsonInt32;
import org.bson.BsonInt64;
import org.bson.BsonInvalidOperationException;
import org.bson.BsonJavaScriptWithScope;
import org.bson.BsonNumber;
import org.bson.BsonObjectId;
import org.bson.BsonReader;
import org.bson.BsonRegularExpression;
import org.bson.BsonString;
import org.bson.BsonTimestamp;
import org.bson.BsonType;
import org.bson.BsonValue;
import org.bson.BsonWriter;
import org.bson.ByteBuf;
import org.bson.codecs.BsonDocumentCodec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;
import org.bson.io.BasicOutputBuffer;
import org.bson.json.JsonMode;
import org.bson.json.JsonReader;
import org.bson.json.JsonWriter;
import org.bson.json.JsonWriterSettings;

public class BsonDocument
extends BsonValue
implements Map<String, BsonValue>,
Cloneable,
Bson,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<String, BsonValue> map;

    public static BsonDocument parse(String string) {
        return new BsonDocumentCodec().decode(new JsonReader(string), DecoderContext.builder().build());
    }

    public BsonDocument(List<BsonElement> list) {
        this(list.size());
        for (BsonElement bsonElement : list) {
            this.put(bsonElement.getName(), bsonElement.getValue());
        }
    }

    public BsonDocument(String string, BsonValue bsonValue) {
        this();
        this.put(string, bsonValue);
    }

    public BsonDocument(int n) {
        this.map = new LinkedHashMap<String, BsonValue>(n);
    }

    public BsonDocument() {
        this.map = new LinkedHashMap<String, BsonValue>();
    }

    public <C> BsonDocument toBsonDocument(Class<C> clazz, CodecRegistry codecRegistry) {
        return this;
    }

    @Override
    public BsonType getBsonType() {
        return BsonType.DOCUMENT;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object object) {
        return this.map.containsKey(object);
    }

    @Override
    public boolean containsValue(Object object) {
        return this.map.containsValue(object);
    }

    @Override
    public BsonValue get(Object object) {
        return this.map.get(object);
    }

    public BsonDocument getDocument(Object object) {
        this.throwIfKeyAbsent(object);
        return this.get(object).asDocument();
    }

    public BsonArray getArray(Object object) {
        this.throwIfKeyAbsent(object);
        return this.get(object).asArray();
    }

    public BsonNumber getNumber(Object object) {
        this.throwIfKeyAbsent(object);
        return this.get(object).asNumber();
    }

    public BsonInt32 getInt32(Object object) {
        this.throwIfKeyAbsent(object);
        return this.get(object).asInt32();
    }

    public BsonInt64 getInt64(Object object) {
        this.throwIfKeyAbsent(object);
        return this.get(object).asInt64();
    }

    public BsonDecimal128 getDecimal128(Object object) {
        this.throwIfKeyAbsent(object);
        return this.get(object).asDecimal128();
    }

    public BsonDouble getDouble(Object object) {
        this.throwIfKeyAbsent(object);
        return this.get(object).asDouble();
    }

    public BsonBoolean getBoolean(Object object) {
        this.throwIfKeyAbsent(object);
        return this.get(object).asBoolean();
    }

    public BsonString getString(Object object) {
        this.throwIfKeyAbsent(object);
        return this.get(object).asString();
    }

    public BsonDateTime getDateTime(Object object) {
        this.throwIfKeyAbsent(object);
        return this.get(object).asDateTime();
    }

    public BsonTimestamp getTimestamp(Object object) {
        this.throwIfKeyAbsent(object);
        return this.get(object).asTimestamp();
    }

    public BsonObjectId getObjectId(Object object) {
        this.throwIfKeyAbsent(object);
        return this.get(object).asObjectId();
    }

    public BsonRegularExpression getRegularExpression(Object object) {
        this.throwIfKeyAbsent(object);
        return this.get(object).asRegularExpression();
    }

    public BsonBinary getBinary(Object object) {
        this.throwIfKeyAbsent(object);
        return this.get(object).asBinary();
    }

    public boolean isNull(Object object) {
        if (!this.containsKey(object)) {
            return false;
        }
        return this.get(object).isNull();
    }

    public boolean isDocument(Object object) {
        if (!this.containsKey(object)) {
            return false;
        }
        return this.get(object).isDocument();
    }

    public boolean isArray(Object object) {
        if (!this.containsKey(object)) {
            return false;
        }
        return this.get(object).isArray();
    }

    public boolean isNumber(Object object) {
        if (!this.containsKey(object)) {
            return false;
        }
        return this.get(object).isNumber();
    }

    public boolean isInt32(Object object) {
        if (!this.containsKey(object)) {
            return false;
        }
        return this.get(object).isInt32();
    }

    public boolean isInt64(Object object) {
        if (!this.containsKey(object)) {
            return false;
        }
        return this.get(object).isInt64();
    }

    public boolean isDecimal128(Object object) {
        if (!this.containsKey(object)) {
            return false;
        }
        return this.get(object).isDecimal128();
    }

    public boolean isDouble(Object object) {
        if (!this.containsKey(object)) {
            return false;
        }
        return this.get(object).isDouble();
    }

    public boolean isBoolean(Object object) {
        if (!this.containsKey(object)) {
            return false;
        }
        return this.get(object).isBoolean();
    }

    public boolean isString(Object object) {
        if (!this.containsKey(object)) {
            return false;
        }
        return this.get(object).isString();
    }

    public boolean isDateTime(Object object) {
        if (!this.containsKey(object)) {
            return false;
        }
        return this.get(object).isDateTime();
    }

    public boolean isTimestamp(Object object) {
        if (!this.containsKey(object)) {
            return false;
        }
        return this.get(object).isTimestamp();
    }

    public boolean isObjectId(Object object) {
        if (!this.containsKey(object)) {
            return false;
        }
        return this.get(object).isObjectId();
    }

    public boolean isBinary(Object object) {
        if (!this.containsKey(object)) {
            return false;
        }
        return this.get(object).isBinary();
    }

    public BsonValue get(Object object, BsonValue bsonValue) {
        BsonValue bsonValue2 = this.get(object);
        return bsonValue2 != null ? bsonValue2 : bsonValue;
    }

    public BsonDocument getDocument(Object object, BsonDocument bsonDocument) {
        if (!this.containsKey(object)) {
            return bsonDocument;
        }
        return this.get(object).asDocument();
    }

    public BsonArray getArray(Object object, BsonArray bsonArray) {
        if (!this.containsKey(object)) {
            return bsonArray;
        }
        return this.get(object).asArray();
    }

    public BsonNumber getNumber(Object object, BsonNumber bsonNumber) {
        if (!this.containsKey(object)) {
            return bsonNumber;
        }
        return this.get(object).asNumber();
    }

    public BsonInt32 getInt32(Object object, BsonInt32 bsonInt32) {
        if (!this.containsKey(object)) {
            return bsonInt32;
        }
        return this.get(object).asInt32();
    }

    public BsonInt64 getInt64(Object object, BsonInt64 bsonInt64) {
        if (!this.containsKey(object)) {
            return bsonInt64;
        }
        return this.get(object).asInt64();
    }

    public BsonDecimal128 getDecimal128(Object object, BsonDecimal128 bsonDecimal128) {
        if (!this.containsKey(object)) {
            return bsonDecimal128;
        }
        return this.get(object).asDecimal128();
    }

    public BsonDouble getDouble(Object object, BsonDouble bsonDouble) {
        if (!this.containsKey(object)) {
            return bsonDouble;
        }
        return this.get(object).asDouble();
    }

    public BsonBoolean getBoolean(Object object, BsonBoolean bsonBoolean) {
        if (!this.containsKey(object)) {
            return bsonBoolean;
        }
        return this.get(object).asBoolean();
    }

    public BsonString getString(Object object, BsonString bsonString) {
        if (!this.containsKey(object)) {
            return bsonString;
        }
        return this.get(object).asString();
    }

    public BsonDateTime getDateTime(Object object, BsonDateTime bsonDateTime) {
        if (!this.containsKey(object)) {
            return bsonDateTime;
        }
        return this.get(object).asDateTime();
    }

    public BsonTimestamp getTimestamp(Object object, BsonTimestamp bsonTimestamp) {
        if (!this.containsKey(object)) {
            return bsonTimestamp;
        }
        return this.get(object).asTimestamp();
    }

    public BsonObjectId getObjectId(Object object, BsonObjectId bsonObjectId) {
        if (!this.containsKey(object)) {
            return bsonObjectId;
        }
        return this.get(object).asObjectId();
    }

    public BsonBinary getBinary(Object object, BsonBinary bsonBinary) {
        if (!this.containsKey(object)) {
            return bsonBinary;
        }
        return this.get(object).asBinary();
    }

    public BsonRegularExpression getRegularExpression(Object object, BsonRegularExpression bsonRegularExpression) {
        if (!this.containsKey(object)) {
            return bsonRegularExpression;
        }
        return this.get(object).asRegularExpression();
    }

    @Override
    public BsonValue put(String string, BsonValue bsonValue) {
        if (bsonValue == null) {
            throw new IllegalArgumentException(String.format("The value for key %s can not be null", string));
        }
        return this.map.put(string, bsonValue);
    }

    @Override
    public BsonValue remove(Object object) {
        return this.map.remove(object);
    }

    @Override
    public void putAll(Map<? extends String, ? extends BsonValue> map) {
        for (Map.Entry<? extends String, ? extends BsonValue> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.map.keySet();
    }

    @Override
    public Collection<BsonValue> values() {
        return this.map.values();
    }

    @Override
    public Set<Map.Entry<String, BsonValue>> entrySet() {
        return this.map.entrySet();
    }

    public BsonDocument append(String string, BsonValue bsonValue) {
        this.put(string, bsonValue);
        return this;
    }

    public String getFirstKey() {
        return this.keySet().iterator().next();
    }

    public BsonReader asBsonReader() {
        return new BsonDocumentReader(this);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof BsonDocument)) {
            return false;
        }
        BsonDocument bsonDocument = (BsonDocument)object;
        return this.entrySet().equals(bsonDocument.entrySet());
    }

    @Override
    public int hashCode() {
        return this.entrySet().hashCode();
    }

    public String toJson() {
        return this.toJson(JsonWriterSettings.builder().outputMode(JsonMode.RELAXED).build());
    }

    public String toJson(JsonWriterSettings jsonWriterSettings) {
        StringWriter stringWriter = new StringWriter();
        new BsonDocumentCodec().encode((BsonWriter)new JsonWriter(stringWriter, jsonWriterSettings), this, EncoderContext.builder().build());
        return stringWriter.toString();
    }

    public String toString() {
        return this.toJson();
    }

    public BsonDocument clone() {
        BsonDocument bsonDocument = new BsonDocument(this.size());
        block6: for (Map.Entry<String, BsonValue> entry : this.entrySet()) {
            switch (entry.getValue().getBsonType()) {
                case DOCUMENT: {
                    bsonDocument.put(entry.getKey(), entry.getValue().asDocument().clone());
                    continue block6;
                }
                case ARRAY: {
                    bsonDocument.put(entry.getKey(), entry.getValue().asArray().clone());
                    continue block6;
                }
                case BINARY: {
                    bsonDocument.put(entry.getKey(), BsonBinary.clone(entry.getValue().asBinary()));
                    continue block6;
                }
                case JAVASCRIPT_WITH_SCOPE: {
                    bsonDocument.put(entry.getKey(), BsonJavaScriptWithScope.clone(entry.getValue().asJavaScriptWithScope()));
                    continue block6;
                }
            }
            bsonDocument.put(entry.getKey(), entry.getValue());
        }
        return bsonDocument;
    }

    private void throwIfKeyAbsent(Object object) {
        if (!this.containsKey(object)) {
            throw new BsonInvalidOperationException("Document does not contain key " + object);
        }
    }

    private Object writeReplace() {
        return new SerializationProxy(this);
    }

    private void readObject(ObjectInputStream objectInputStream) throws InvalidObjectException {
        throw new InvalidObjectException("Proxy required");
    }

    private static class SerializationProxy
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final byte[] bytes;

        SerializationProxy(BsonDocument bsonDocument) {
            BasicOutputBuffer basicOutputBuffer = new BasicOutputBuffer();
            new BsonDocumentCodec().encode((BsonWriter)new BsonBinaryWriter(basicOutputBuffer), bsonDocument, EncoderContext.builder().build());
            this.bytes = new byte[basicOutputBuffer.size()];
            int n = 0;
            for (ByteBuf byteBuf : basicOutputBuffer.getByteBuffers()) {
                System.arraycopy(byteBuf.array(), byteBuf.position(), this.bytes, n, byteBuf.limit());
                n += byteBuf.position();
            }
        }

        private Object readResolve() {
            return new BsonDocumentCodec().decode(new BsonBinaryReader(ByteBuffer.wrap(this.bytes).order(ByteOrder.LITTLE_ENDIAN)), DecoderContext.builder().build());
        }
    }
}

