/*
 * Decompiled with CFR 0.152.
 */
package org.bson;

import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.bson.BsonDocument;
import org.bson.BsonDocumentWriter;
import org.bson.BsonInvalidOperationException;
import org.bson.BsonValue;
import org.bson.codecs.Encoder;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.configuration.CodecRegistry;

public final class BsonDocumentWrapper<T>
extends BsonDocument {
    private static final long serialVersionUID = 1L;
    private final transient T wrappedDocument;
    private final transient Encoder<T> encoder;
    private BsonDocument unwrapped;

    public static BsonDocument asBsonDocument(Object object, CodecRegistry codecRegistry) {
        if (object == null) {
            return null;
        }
        if (object instanceof BsonDocument) {
            return (BsonDocument)object;
        }
        return new BsonDocumentWrapper<Object>(object, codecRegistry.get(object.getClass()));
    }

    public BsonDocumentWrapper(T t, Encoder<T> encoder) {
        if (t == null) {
            throw new IllegalArgumentException("Document can not be null");
        }
        this.wrappedDocument = t;
        this.encoder = encoder;
    }

    public T getWrappedDocument() {
        return this.wrappedDocument;
    }

    public Encoder<T> getEncoder() {
        return this.encoder;
    }

    public boolean isUnwrapped() {
        return this.unwrapped != null;
    }

    @Override
    public int size() {
        return this.getUnwrapped().size();
    }

    @Override
    public boolean isEmpty() {
        return this.getUnwrapped().isEmpty();
    }

    @Override
    public boolean containsKey(Object object) {
        return this.getUnwrapped().containsKey(object);
    }

    @Override
    public boolean containsValue(Object object) {
        return this.getUnwrapped().containsValue(object);
    }

    @Override
    public BsonValue get(Object object) {
        return this.getUnwrapped().get(object);
    }

    @Override
    public BsonValue put(String string, BsonValue bsonValue) {
        return this.getUnwrapped().put(string, bsonValue);
    }

    @Override
    public BsonValue remove(Object object) {
        return this.getUnwrapped().remove(object);
    }

    @Override
    public void putAll(Map<? extends String, ? extends BsonValue> map) {
        super.putAll(map);
    }

    @Override
    public void clear() {
        super.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.getUnwrapped().keySet();
    }

    @Override
    public Collection<BsonValue> values() {
        return this.getUnwrapped().values();
    }

    @Override
    public Set<Map.Entry<String, BsonValue>> entrySet() {
        return this.getUnwrapped().entrySet();
    }

    @Override
    public boolean equals(Object object) {
        return this.getUnwrapped().equals(object);
    }

    @Override
    public int hashCode() {
        return this.getUnwrapped().hashCode();
    }

    @Override
    public String toString() {
        return this.getUnwrapped().toString();
    }

    @Override
    public BsonDocument clone() {
        return this.getUnwrapped().clone();
    }

    private BsonDocument getUnwrapped() {
        if (this.encoder == null) {
            throw new BsonInvalidOperationException("Can not unwrap a BsonDocumentWrapper with no Encoder");
        }
        if (this.unwrapped == null) {
            BsonDocument bsonDocument = new BsonDocument();
            BsonDocumentWriter bsonDocumentWriter = new BsonDocumentWriter(bsonDocument);
            this.encoder.encode(bsonDocumentWriter, this.wrappedDocument, EncoderContext.builder().build());
            this.unwrapped = bsonDocument;
        }
        return this.unwrapped;
    }

    private Object writeReplace() {
        return this.getUnwrapped();
    }

    private void readObject(ObjectInputStream objectInputStream) throws InvalidObjectException {
        throw new InvalidObjectException("Proxy required");
    }
}

