/*
 * Decompiled with CFR 0.152.
 */
package org.bson;

import org.bson.AbstractBsonWriter;
import org.bson.BsonArray;
import org.bson.BsonBinary;
import org.bson.BsonBoolean;
import org.bson.BsonContextType;
import org.bson.BsonDateTime;
import org.bson.BsonDbPointer;
import org.bson.BsonDecimal128;
import org.bson.BsonDocument;
import org.bson.BsonDouble;
import org.bson.BsonInt32;
import org.bson.BsonInt64;
import org.bson.BsonInvalidOperationException;
import org.bson.BsonJavaScript;
import org.bson.BsonJavaScriptWithScope;
import org.bson.BsonMaxKey;
import org.bson.BsonMinKey;
import org.bson.BsonNull;
import org.bson.BsonObjectId;
import org.bson.BsonRegularExpression;
import org.bson.BsonString;
import org.bson.BsonSymbol;
import org.bson.BsonTimestamp;
import org.bson.BsonUndefined;
import org.bson.BsonValue;
import org.bson.BsonWriterSettings;
import org.bson.types.Decimal128;
import org.bson.types.ObjectId;

public class BsonDocumentWriter
extends AbstractBsonWriter {
    private final BsonDocument document;

    public BsonDocumentWriter(BsonDocument bsonDocument) {
        super(new BsonWriterSettings());
        this.document = bsonDocument;
        this.setContext(new Context());
    }

    public BsonDocument getDocument() {
        return this.document;
    }

    @Override
    protected void doWriteStartDocument() {
        switch (this.getState()) {
            case INITIAL: {
                this.setContext(new Context(this.document, BsonContextType.DOCUMENT, this.getContext()));
                break;
            }
            case VALUE: {
                this.setContext(new Context(new BsonDocument(), BsonContextType.DOCUMENT, this.getContext()));
                break;
            }
            case SCOPE_DOCUMENT: {
                this.setContext(new Context(new BsonDocument(), BsonContextType.SCOPE_DOCUMENT, this.getContext()));
                break;
            }
            default: {
                throw new BsonInvalidOperationException("Unexpected state " + (Object)((Object)this.getState()));
            }
        }
    }

    @Override
    protected void doWriteEndDocument() {
        BsonValue bsonValue = this.getContext().container;
        this.setContext(this.getContext().getParentContext());
        if (this.getContext().getContextType() == BsonContextType.JAVASCRIPT_WITH_SCOPE) {
            BsonDocument bsonDocument = (BsonDocument)bsonValue;
            BsonString bsonString = (BsonString)this.getContext().container;
            this.setContext(this.getContext().getParentContext());
            this.write(new BsonJavaScriptWithScope(bsonString.getValue(), bsonDocument));
        } else if (this.getContext().getContextType() != BsonContextType.TOP_LEVEL) {
            this.write(bsonValue);
        }
    }

    @Override
    protected void doWriteStartArray() {
        this.setContext(new Context(new BsonArray(), BsonContextType.ARRAY, this.getContext()));
    }

    @Override
    protected void doWriteEndArray() {
        BsonValue bsonValue = this.getContext().container;
        this.setContext(this.getContext().getParentContext());
        this.write(bsonValue);
    }

    @Override
    protected void doWriteBinaryData(BsonBinary bsonBinary) {
        this.write(bsonBinary);
    }

    @Override
    public void doWriteBoolean(boolean bl) {
        this.write(BsonBoolean.valueOf(bl));
    }

    @Override
    protected void doWriteDateTime(long l) {
        this.write(new BsonDateTime(l));
    }

    @Override
    protected void doWriteDBPointer(BsonDbPointer bsonDbPointer) {
        this.write(bsonDbPointer);
    }

    @Override
    protected void doWriteDouble(double d) {
        this.write(new BsonDouble(d));
    }

    @Override
    protected void doWriteInt32(int n) {
        this.write(new BsonInt32(n));
    }

    @Override
    protected void doWriteInt64(long l) {
        this.write(new BsonInt64(l));
    }

    @Override
    protected void doWriteDecimal128(Decimal128 decimal128) {
        this.write(new BsonDecimal128(decimal128));
    }

    @Override
    protected void doWriteJavaScript(String string) {
        this.write(new BsonJavaScript(string));
    }

    @Override
    protected void doWriteJavaScriptWithScope(String string) {
        this.setContext(new Context(new BsonString(string), BsonContextType.JAVASCRIPT_WITH_SCOPE, this.getContext()));
    }

    @Override
    protected void doWriteMaxKey() {
        this.write(new BsonMaxKey());
    }

    @Override
    protected void doWriteMinKey() {
        this.write(new BsonMinKey());
    }

    @Override
    public void doWriteNull() {
        this.write(BsonNull.VALUE);
    }

    @Override
    public void doWriteObjectId(ObjectId objectId) {
        this.write(new BsonObjectId(objectId));
    }

    @Override
    public void doWriteRegularExpression(BsonRegularExpression bsonRegularExpression) {
        this.write(bsonRegularExpression);
    }

    @Override
    public void doWriteString(String string) {
        this.write(new BsonString(string));
    }

    @Override
    public void doWriteSymbol(String string) {
        this.write(new BsonSymbol(string));
    }

    @Override
    public void doWriteTimestamp(BsonTimestamp bsonTimestamp) {
        this.write(bsonTimestamp);
    }

    @Override
    public void doWriteUndefined() {
        this.write(new BsonUndefined());
    }

    @Override
    protected Context getContext() {
        return (Context)super.getContext();
    }

    private void write(BsonValue bsonValue) {
        this.getContext().add(bsonValue);
    }

    private class Context
    extends AbstractBsonWriter.Context {
        private BsonValue container;

        Context(BsonValue bsonValue, BsonContextType bsonContextType, Context context) {
            super(BsonDocumentWriter.this, context, bsonContextType);
            this.container = bsonValue;
        }

        Context() {
            super(BsonDocumentWriter.this, null, BsonContextType.TOP_LEVEL);
        }

        void add(BsonValue bsonValue) {
            if (this.container instanceof BsonArray) {
                ((BsonArray)this.container).add(bsonValue);
            } else {
                ((BsonDocument)this.container).put(BsonDocumentWriter.this.getName(), bsonValue);
            }
        }
    }
}

