/*
 * Decompiled with CFR 0.152.
 */
package org.bson;

import java.math.BigDecimal;
import org.bson.BsonNumber;
import org.bson.BsonType;
import org.bson.types.Decimal128;

public class BsonDouble
extends BsonNumber
implements Comparable<BsonDouble> {
    private final double value;

    public BsonDouble(double d) {
        this.value = d;
    }

    @Override
    public int compareTo(BsonDouble bsonDouble) {
        return Double.compare(this.value, bsonDouble.value);
    }

    @Override
    public BsonType getBsonType() {
        return BsonType.DOUBLE;
    }

    public double getValue() {
        return this.value;
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return (long)this.value;
    }

    @Override
    public Decimal128 decimal128Value() {
        if (Double.isNaN(this.value)) {
            return Decimal128.NaN;
        }
        if (Double.isInfinite(this.value)) {
            return this.value > 0.0 ? Decimal128.POSITIVE_INFINITY : Decimal128.NEGATIVE_INFINITY;
        }
        return new Decimal128(new BigDecimal(this.value));
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        BsonDouble bsonDouble = (BsonDouble)object;
        return Double.compare(bsonDouble.value, this.value) == 0;
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.value);
        return (int)(l ^ l >>> 32);
    }

    public String toString() {
        return "BsonDouble{value=" + this.value + '}';
    }
}

