/*
 * Decompiled with CFR 0.152.
 */
package org.bson;

import org.bson.BsonNumber;
import org.bson.BsonType;
import org.bson.types.Decimal128;

public final class BsonInt64
extends BsonNumber
implements Comparable<BsonInt64> {
    private final long value;

    public BsonInt64(long l) {
        this.value = l;
    }

    @Override
    public int compareTo(BsonInt64 bsonInt64) {
        return this.value < bsonInt64.value ? -1 : (this.value == bsonInt64.value ? 0 : 1);
    }

    @Override
    public BsonType getBsonType() {
        return BsonType.INT64;
    }

    public long getValue() {
        return this.value;
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public Decimal128 decimal128Value() {
        return new Decimal128(this.value);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        BsonInt64 bsonInt64 = (BsonInt64)object;
        return this.value == bsonInt64.value;
    }

    public int hashCode() {
        return (int)(this.value ^ this.value >>> 32);
    }

    public String toString() {
        return "BsonInt64{value=" + this.value + '}';
    }
}

