/*
 * Decompiled with CFR 0.152.
 */
package org.bson;

import org.bson.BsonDocument;
import org.bson.BsonType;
import org.bson.BsonValue;

public class BsonJavaScriptWithScope
extends BsonValue {
    private final String code;
    private final BsonDocument scope;

    public BsonJavaScriptWithScope(String string, BsonDocument bsonDocument) {
        if (string == null) {
            throw new IllegalArgumentException("code can not be null");
        }
        if (bsonDocument == null) {
            throw new IllegalArgumentException("scope can not be null");
        }
        this.code = string;
        this.scope = bsonDocument;
    }

    @Override
    public BsonType getBsonType() {
        return BsonType.JAVASCRIPT_WITH_SCOPE;
    }

    public String getCode() {
        return this.code;
    }

    public BsonDocument getScope() {
        return this.scope;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        BsonJavaScriptWithScope bsonJavaScriptWithScope = (BsonJavaScriptWithScope)object;
        if (!this.code.equals(bsonJavaScriptWithScope.code)) {
            return false;
        }
        return this.scope.equals(bsonJavaScriptWithScope.scope);
    }

    public int hashCode() {
        int n = this.code.hashCode();
        n = 31 * n + this.scope.hashCode();
        return n;
    }

    public String toString() {
        return "BsonJavaScriptWithScope{code=" + this.getCode() + "scope=" + this.scope + '}';
    }

    static BsonJavaScriptWithScope clone(BsonJavaScriptWithScope bsonJavaScriptWithScope) {
        return new BsonJavaScriptWithScope(bsonJavaScriptWithScope.code, bsonJavaScriptWithScope.scope.clone());
    }
}

