/*
 * Decompiled with CFR 0.152.
 */
package org.bson;

import org.bson.BsonType;
import org.bson.BsonValue;
import org.bson.types.ObjectId;

public class BsonObjectId
extends BsonValue
implements Comparable<BsonObjectId> {
    private final ObjectId value;

    public BsonObjectId() {
        this(new ObjectId());
    }

    public BsonObjectId(ObjectId objectId) {
        if (objectId == null) {
            throw new IllegalArgumentException("value may not be null");
        }
        this.value = objectId;
    }

    public ObjectId getValue() {
        return this.value;
    }

    @Override
    public BsonType getBsonType() {
        return BsonType.OBJECT_ID;
    }

    @Override
    public int compareTo(BsonObjectId bsonObjectId) {
        return this.value.compareTo(bsonObjectId.value);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        BsonObjectId bsonObjectId = (BsonObjectId)object;
        return this.value.equals(bsonObjectId.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public String toString() {
        return "BsonObjectId{value=" + this.value.toHexString() + '}';
    }
}

