/*
 * Decompiled with CFR 0.152.
 */
package org.bson;

import java.util.Arrays;
import org.bson.BsonType;
import org.bson.BsonValue;
import org.bson.assertions.Assertions;

public final class BsonRegularExpression
extends BsonValue {
    private final String pattern;
    private final String options;

    public BsonRegularExpression(String string, String string2) {
        this.pattern = Assertions.notNull("pattern", string);
        this.options = string2 == null ? "" : this.sortOptionCharacters(string2);
    }

    public BsonRegularExpression(String string) {
        this(string, null);
    }

    @Override
    public BsonType getBsonType() {
        return BsonType.REGULAR_EXPRESSION;
    }

    public String getPattern() {
        return this.pattern;
    }

    public String getOptions() {
        return this.options;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        BsonRegularExpression bsonRegularExpression = (BsonRegularExpression)object;
        if (!this.options.equals(bsonRegularExpression.options)) {
            return false;
        }
        return this.pattern.equals(bsonRegularExpression.pattern);
    }

    public int hashCode() {
        int n = this.pattern.hashCode();
        n = 31 * n + this.options.hashCode();
        return n;
    }

    public String toString() {
        return "BsonRegularExpression{pattern='" + this.pattern + '\'' + ", options='" + this.options + '\'' + '}';
    }

    private String sortOptionCharacters(String string) {
        char[] cArray = string.toCharArray();
        Arrays.sort(cArray);
        return new String(cArray);
    }
}

