/*
 * Decompiled with CFR 0.152.
 */
package org.bson;

import org.bson.BsonType;
import org.bson.BsonValue;

public class BsonString
extends BsonValue
implements Comparable<BsonString> {
    private final String value;

    public BsonString(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Value can not be null");
        }
        this.value = string;
    }

    @Override
    public int compareTo(BsonString bsonString) {
        return this.value.compareTo(bsonString.value);
    }

    @Override
    public BsonType getBsonType() {
        return BsonType.STRING;
    }

    public String getValue() {
        return this.value;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        BsonString bsonString = (BsonString)object;
        return this.value.equals(bsonString.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public String toString() {
        return "BsonString{value='" + this.value + '\'' + '}';
    }
}

